/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AIOption;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.deck.RandomDeckGenerator;
import forge.deckchooser.FDeckChooser;
import forge.game.GameType;
import forge.game.card.CardView;
import forge.gamemodes.match.GameLobby;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import forge.gui.CardDetailPanel;
import forge.gui.GuiBase;
import forge.gui.interfaces.ILobbyView;
import forge.gui.util.SOptionPane;
import forge.interfaces.IPlayerChangeListener;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.LblHeader;
import forge.screens.home.PlayerPanel;
import forge.screens.home.StartButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FScrollPanel;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.NameGenerator;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class VLobby
implements ILobbyView {
    static final int MAX_PLAYERS = 8;
    final Localizer localizer = Localizer.getInstance();
    private static final ForgePreferences prefs = FModel.getPreferences();
    private final GameLobby lobby;
    private IPlayerChangeListener playerChangeListener = null;
    private final LblHeader lblTitle = new LblHeader(this.localizer.getMessage("lblHeaderConstructedMode", new Object[0]));
    private int activePlayersNum = 0;
    private int playerWithFocus = 0;
    private final StartButton btnStart = new StartButton();
    private final JPanel pnlStart = new JPanel(new MigLayout("insets 0, gap 0, wrap 2"));
    private final JComboBox gamesInMatch = new JComboBox<String>(new String[]{"1", "3", "5"});
    private final JPanel gamesInMatchFrame = new JPanel(new MigLayout("insets 0, gap 0, wrap 2"));
    private final JPanel constructedFrame = new JPanel(new MigLayout("insets 0, gap 0, wrap 2"));
    private final FPanel variantsPanel = new FPanel(new MigLayout("insets 10, gapx 10"));
    private final VariantCheckBox vntVanguard = new VariantCheckBox(GameType.Vanguard);
    private final VariantCheckBox vntMomirBasic = new VariantCheckBox(GameType.MomirBasic);
    private final VariantCheckBox vntMoJhoSto = new VariantCheckBox(GameType.MoJhoSto);
    private final VariantCheckBox vntCommander = new VariantCheckBox(GameType.Commander);
    private final VariantCheckBox vntOathbreaker = new VariantCheckBox(GameType.Oathbreaker);
    private final VariantCheckBox vntTinyLeaders = new VariantCheckBox(GameType.TinyLeaders);
    private final VariantCheckBox vntBrawl = new VariantCheckBox(GameType.Brawl);
    private final VariantCheckBox vntPlanechase = new VariantCheckBox(GameType.Planechase);
    private final VariantCheckBox vntArchenemy = new VariantCheckBox(GameType.Archenemy);
    private final VariantCheckBox vntArchenemyRumble = new VariantCheckBox(GameType.ArchenemyRumble);
    private final ImmutableList<VariantCheckBox> vntBoxesLocal = ImmutableList.of(this.vntVanguard, this.vntMomirBasic, this.vntMoJhoSto, this.vntCommander, this.vntOathbreaker, this.vntBrawl, this.vntTinyLeaders, this.vntPlanechase, this.vntArchenemy, this.vntArchenemyRumble);
    private final ImmutableList<VariantCheckBox> vntBoxesNetwork = ImmutableList.of(this.vntVanguard, this.vntMomirBasic, this.vntMoJhoSto, this.vntCommander, this.vntOathbreaker, this.vntBrawl, this.vntTinyLeaders);
    private final JPanel playersFrame = new JPanel(new MigLayout("insets 0, gap 0 5, wrap, hidemode 3"));
    private final FScrollPanel playersScroll = new FScrollPanel(new MigLayout("insets 0, gap 0, wrap, hidemode 3"), true);
    private final List<PlayerPanel> playerPanels = new ArrayList<PlayerPanel>(8);
    private final Map<ForgePreferences.FPref, FDeckChooser> cachedDeckChoosers = new HashMap<ForgePreferences.FPref, FDeckChooser>();
    private final FLabel addPlayerBtn = new FLabel.ButtonBuilder().fontSize(14).text(this.localizer.getMessage("lblAddAPlayer", new Object[0])).build();
    private final JPanel decksFrame = new JPanel(new MigLayout("insets 0, gap 0, wrap, hidemode 3"));
    private final FCheckBox cbSingletons = new FCheckBox(this.localizer.getMessage("cbSingletons", new Object[0]));
    private final FCheckBox cbArtifacts = new FCheckBox(this.localizer.getMessage("cbRemoveArtifacts", new Object[0]));
    private final Deck[] decks = new Deck[8];
    private final List<FList<Object>> schemeDeckLists = new ArrayList<FList<Object>>();
    private final List<FPanel> schemeDeckPanels = new ArrayList<FPanel>(8);
    private final List<FList<Object>> planarDeckLists = new ArrayList<FList<Object>>();
    private final List<FPanel> planarDeckPanels = new ArrayList<FPanel>(8);
    private final List<FList<Object>> vgdAvatarLists = new ArrayList<FList<Object>>();
    private final List<FPanel> vgdPanels = new ArrayList<FPanel>(8);
    private final List<CardDetailPanel> vgdAvatarDetails = new ArrayList<CardDetailPanel>();
    private final List<PaperCard> vgdAllAvatars = new ArrayList<PaperCard>();
    private final List<PaperCard> nonRandomHumanAvatars = new ArrayList<PaperCard>();
    private final List<PaperCard> nonRandomAiAvatars = new ArrayList<PaperCard>();
    private final Vector<Object> humanListData = new Vector();
    private final Vector<Object> aiListData = new Vector();
    private static final ImmutableList<String> genderOptions = ImmutableList.of("Male", "Female", "Any");
    private static final ImmutableList<String> typeOptions = ImmutableList.of("Fantasy", "Generic", "Any");
    final ActionListener nameListener = e -> {
        FTextField nField = (FTextField)e.getSource();
        nField.transferFocus();
    };

    public VLobby(GameLobby lobby) {
        this.lobby = lobby;
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        ImmutableList<VariantCheckBox> vntBoxes = null;
        vntBoxes = lobby.isAllowNetworking() ? this.vntBoxesNetwork : this.vntBoxesLocal;
        this.variantsPanel.setOpaque(false);
        this.variantsPanel.add(this.newLabel(this.localizer.getMessage("lblVariants", new Object[0])));
        for (VariantCheckBox vcb : vntBoxes) {
            this.variantsPanel.add(vcb);
        }
        this.constructedFrame.add((Component)new FScrollPane(this.variantsPanel, false, true, 21, 30), "w 100%, h 45px!, gapbottom 10px, spanx 2, wrap");
        this.playersFrame.setOpaque(false);
        this.playersFrame.add((Component)this.playersScroll, "w 100%, h 100%-35px");
        if (lobby.hasControl()) {
            this.addPlayerBtn.setFocusable(true);
            this.addPlayerBtn.setCommand(lobby::addSlot);
            this.playersFrame.add((Component)this.addPlayerBtn, "height 30px!, growx, pushx");
        }
        this.constructedFrame.add((Component)this.playersFrame, "gapright 10px, w 50%-5px, growy, pushy");
        this.populateVanguardLists();
        for (int i = 0; i < 8; ++i) {
            this.buildDeckPanels(i);
        }
        this.constructedFrame.add((Component)this.decksFrame, "w 50%-5px, growy, pushy");
        this.constructedFrame.setOpaque(false);
        this.decksFrame.setOpaque(false);
        if (lobby.hasControl()) {
            this.pnlStart.setOpaque(false);
            this.pnlStart.add((Component)this.btnStart, "align center");
            this.btnStart.addActionListener(arg0 -> {
                Runnable startGame = lobby.startGame();
                if (startGame != null) {
                    if (!this.gamesInMatch.getSelectedItem().equals((Object)ForgePreferences.FPref.UI_MATCHES_PER_GAME)) {
                        FModel.getPreferences().setPref(ForgePreferences.FPref.UI_MATCHES_PER_GAME, (String)this.gamesInMatch.getSelectedItem());
                    }
                    startGame.run();
                }
            });
        }
        this.gamesInMatchFrame.add((Component)this.newLabel(this.localizer.getMessage("lblGamesInMatch", new Object[0])), "w 150px!, h 30px!");
        this.gamesInMatchFrame.add((Component)this.gamesInMatch, "w 50px!, h 30px!");
        this.gamesInMatchFrame.setOpaque(false);
        this.gamesInMatch.setSelectedItem("3");
        this.pnlStart.add(this.gamesInMatchFrame);
    }

    public void updateDeckPanel() {
        for (PlayerPanel playerPanel : this.playerPanels) {
            playerPanel.getDeckChooser().restoreSavedState();
        }
    }

    public void focusOnAvatar() {
        this.getPlayerPanelWithFocus().focusOnAvatar();
    }

    private PlayerPanel getPlayerPanel(int slot) {
        return this.playerPanels.get(slot);
    }

    @Override
    public void update(int slot, LobbySlotType type) {
        FDeckChooser deckChooser = this.getDeckChooser(slot);
        deckChooser.setIsAi(type == LobbySlotType.AI);
        DeckType selectedDeckType = deckChooser.getSelectedDeckType();
        switch (selectedDeckType) {
            case STANDARD_CARDGEN_DECK: 
            case PIONEER_CARDGEN_DECK: 
            case HISTORIC_CARDGEN_DECK: 
            case MODERN_CARDGEN_DECK: 
            case LEGACY_CARDGEN_DECK: 
            case VINTAGE_CARDGEN_DECK: 
            case PAUPER_CARDGEN_DECK: 
            case COLOR_DECK: 
            case STANDARD_COLOR_DECK: 
            case MODERN_COLOR_DECK: 
            case RANDOM_CARDGEN_COMMANDER_DECK: 
            case RANDOM_COMMANDER_DECK: {
                deckChooser.refreshDeckListForAI();
                break;
            }
        }
    }

    @Override
    public void update(boolean fullUpdate) {
        this.activePlayersNum = this.lobby.getNumberOfSlots();
        this.addPlayerBtn.setEnabled(this.activePlayersNum < 8);
        boolean allowNetworking = this.lobby.isAllowNetworking();
        GuiBase.setNetworkplay(allowNetworking);
        ImmutableList<VariantCheckBox> vntBoxes = null;
        vntBoxes = allowNetworking ? this.vntBoxesNetwork : this.vntBoxesLocal;
        for (VariantCheckBox vcb : vntBoxes) {
            vcb.setSelected(this.hasVariant(vcb.variant));
            vcb.setEnabled(this.lobby.hasControl());
        }
        for (int i = 0; i < 8; ++i) {
            boolean hasPanel;
            boolean bl = hasPanel = i < this.playerPanels.size();
            if (i < this.activePlayersNum) {
                boolean isSlotAI;
                boolean isNewPanel;
                PlayerPanel panel;
                LobbySlot slot = this.lobby.getSlot(i);
                if (hasPanel) {
                    panel = this.playerPanels.get(i);
                    isNewPanel = !panel.isVisible();
                } else {
                    panel = new PlayerPanel(this, allowNetworking, i, slot, this.lobby.mayEdit(i), this.lobby.hasControl());
                    this.playerPanels.add(panel);
                    String constraints = "pushx, growx, wrap, hidemode 3";
                    if (i == 0) {
                        constraints = constraints + ", gaptop 5px";
                    }
                    this.playersScroll.add((Component)panel, constraints);
                    isNewPanel = true;
                }
                LobbySlotType type = slot.getType();
                panel.setType(type);
                panel.setPlayerName(slot.getName());
                panel.setAvatarIndex(slot.getAvatarIndex());
                panel.setTeam(slot.getTeam());
                panel.setIsReady(slot.isReady());
                panel.setIsDevMode(slot.isDevMode());
                panel.setIsArchenemy(slot.isArchenemy());
                panel.setUseAiSimulation(slot.getAiOptions().contains((Object)AIOption.USE_SIMULATION));
                panel.setMayEdit(this.lobby.mayEdit(i));
                panel.setMayControl(this.lobby.mayControl(i));
                panel.setMayRemove(this.lobby.mayRemove(i));
                panel.update();
                boolean bl2 = isSlotAI = slot.getType() == LobbySlotType.AI;
                if (isNewPanel || fullUpdate) {
                    FDeckChooser deckChooser = this.createDeckChooser(this.lobby.getGameType(), i, isSlotAI);
                    deckChooser.populate();
                    panel.setDeckChooser(deckChooser);
                    if (i == 0) {
                        slot.setIsDevMode(prefs.getPrefBoolean(ForgePreferences.FPref.DEV_MODE_ENABLED));
                        this.changePlayerFocus(0);
                    }
                } else {
                    panel.getDeckChooser().setIsAi(isSlotAI);
                }
                if (fullUpdate && (type == LobbySlotType.LOCAL || isSlotAI)) {
                    panel.getDeckChooser().getLstDecks().getSelectCommand().run();
                    this.selectSchemeDeck(i);
                    this.selectPlanarDeck(i);
                    this.selectVanguardAvatar(i);
                }
                if (!isNewPanel) continue;
                panel.setVisible(true);
                continue;
            }
            if (!hasPanel) continue;
            this.playerPanels.get(i).setVisible(false);
        }
        if (this.playerWithFocus >= this.activePlayersNum) {
            this.changePlayerFocus(this.activePlayersNum - 1);
        } else {
            this.populateDeckPanel(this.lobby.getGameType());
        }
        this.refreshPanels(true, true);
    }

    @Override
    public void setPlayerChangeListener(IPlayerChangeListener listener) {
        this.playerChangeListener = listener;
    }

    void setReady(int index, boolean ready) {
        if (ready && this.decks[index] == null && !this.vntMomirBasic.isSelected() && !this.vntMoJhoSto.isSelected()) {
            SOptionPane.showErrorDialog("Select a deck before readying!");
            this.update(false);
            return;
        }
        this.firePlayerChangeListener(index);
        this.changePlayerFocus(index);
    }

    void setDevMode(int index) {
        for (int i = 0; i < this.activePlayersNum; ++i) {
            this.getPlayerPanel(i).setIsReady(false);
            this.firePlayerChangeListener(i);
        }
        this.changePlayerFocus(index);
    }

    void firePlayerChangeListener(int index) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, this.getSlot(index));
        }
    }

    private void fireDeckChangeListener(int index, Deck deck) {
        this.decks[index] = deck;
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.deckUpdate(deck));
        }
    }

    private void fireDeckSectionChangeListener(int index, DeckSection section, CardPool cards) {
        Deck deck = this.decks[index];
        Deck copy = deck == null ? new Deck() : new Deck(this.decks[index]);
        copy.putSection(section, cards);
        this.decks[index] = copy;
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.deckUpdate(section, cards));
        }
    }

    void removePlayer(int index) {
        this.lobby.removeSlot(index);
    }

    boolean hasVariant(GameType variant) {
        return this.lobby.hasVariant(variant);
    }

    private UpdateLobbyPlayerEvent getSlot(int index) {
        PlayerPanel panel = this.getPlayerPanel(index);
        return UpdateLobbyPlayerEvent.create(panel.getType(), panel.getPlayerName(), panel.getAvatarIndex(), -1, panel.getTeam(), panel.isArchenemy(), panel.isReady(), panel.isDevMode(), panel.getAiOptions());
    }

    private void buildDeckPanels(int playerIndex) {
        this.buildDeckPanel(this.localizer.getMessage("lblSchemeDeck", new Object[0]), playerIndex, this.schemeDeckLists, this.schemeDeckPanels, e -> this.selectSchemeDeck(playerIndex));
        this.buildDeckPanel(this.localizer.getMessage("lblPlanarDeck", new Object[0]), playerIndex, this.planarDeckLists, this.planarDeckPanels, e -> this.selectPlanarDeck(playerIndex));
        this.buildDeckPanel(this.localizer.getMessage("lblVanguardAvatar", new Object[0]), playerIndex, this.vgdAvatarLists, this.vgdPanels, e -> this.selectVanguardAvatar(playerIndex));
        Iterables.getLast(this.vgdAvatarLists).setListData(this.isPlayerAI(playerIndex) ? this.aiListData : this.humanListData);
        Iterables.getLast(this.vgdAvatarLists).setSelectedIndex(0);
        CardDetailPanel vgdDetail = new CardDetailPanel();
        this.vgdAvatarDetails.add(vgdDetail);
        Iterables.getLast(this.vgdPanels).add((Component)vgdDetail, "h 200px, pushx, growx, hidemode 3");
    }

    private void buildDeckPanel(String formatName, int playerIndex, List<FList<Object>> deckLists, List<FPanel> deckPanels, ListSelectionListener selectionListener) {
        FPanel deckPanel = new FPanel();
        deckPanel.setBorderToggle(false);
        deckPanel.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        deckPanel.add((Component)new FLabel.Builder().text("Select " + formatName).fontStyle(1).fontSize(14).fontAlign(0).build(), "gaptop 10px, gapbottom 5px, growx, pushx");
        FList deckList = new FList();
        deckList.setSelectionMode(0);
        deckList.addListSelectionListener(selectionListener);
        FScrollPane scrollPane = new FScrollPane(deckList, true, 20, 31);
        deckPanel.add((Component)scrollPane, "grow, push");
        deckLists.add(deckList);
        deckPanels.add(deckPanel);
    }

    private FDeckChooser getDeckChooser(int iSlot) {
        return this.getPlayerPanel(iSlot).getDeckChooser();
    }

    private void selectMainDeck(FDeckChooser mainChooser, int playerIndex, boolean isCommanderDeck) {
        DeckType type = mainChooser.getSelectedDeckType();
        Deck deck = mainChooser.getDeck();
        if (deck == null) {
            mainChooser.getLstDecks().setSelectedIndex(0);
        }
        Collection selectedDecks = mainChooser.getLstDecks().getSelectedItems();
        if (playerIndex < this.activePlayersNum && this.lobby.mayEdit(playerIndex)) {
            String text = type.toString() + ": " + Lang.joinHomogenous(selectedDecks, DeckProxy::getName);
            if (isCommanderDeck) {
                this.getPlayerPanel(playerIndex).setCommanderDeckSelectorButtonText(text);
            } else {
                this.getPlayerPanel(playerIndex).setDeckSelectorButtonText(text);
            }
            this.fireDeckChangeListener(playerIndex, deck);
        }
        mainChooser.saveState();
    }

    private void selectSchemeDeck(int playerIndex) {
        if (playerIndex >= this.activePlayersNum || !this.hasVariant(GameType.Archenemy) && !this.hasVariant(GameType.ArchenemyRumble)) {
            return;
        }
        Object selected = this.getSchemeDeckLists().get(playerIndex).getSelectedValue();
        Deck deck = this.decks[playerIndex];
        CardPool schemePool = null;
        if (selected instanceof String) {
            String sel = (String)selected;
            if (sel.contains("Use deck's scheme section")) {
                if (deck.has(DeckSection.Schemes)) {
                    schemePool = deck.get(DeckSection.Schemes);
                } else {
                    sel = "Random";
                }
            }
            if (sel.equals("Random")) {
                Deck randomDeck = RandomDeckGenerator.getRandomUserDeck(this.lobby, this.isPlayerAI(playerIndex));
                schemePool = randomDeck.get(DeckSection.Schemes);
            }
        } else if (selected instanceof Deck) {
            schemePool = ((Deck)selected).get(DeckSection.Schemes);
        }
        if (schemePool == null) {
            schemePool = DeckgenUtil.generateSchemePool();
        }
        this.fireDeckSectionChangeListener(playerIndex, DeckSection.Schemes, schemePool);
        this.getDeckChooser(playerIndex).saveState();
    }

    private void selectPlanarDeck(int playerIndex) {
        if (playerIndex >= this.activePlayersNum || !this.hasVariant(GameType.Planechase)) {
            return;
        }
        Object selected = this.getPlanarDeckLists().get(playerIndex).getSelectedValue();
        Deck deck = this.decks[playerIndex];
        CardPool planePool = null;
        if (selected instanceof String) {
            String sel = (String)selected;
            if (sel.contains("Use deck's planes section")) {
                if (deck.has(DeckSection.Planes)) {
                    planePool = deck.get(DeckSection.Planes);
                } else {
                    sel = "Random";
                }
            }
            if (sel.equals("Random")) {
                Deck randomDeck = RandomDeckGenerator.getRandomUserDeck(this.lobby, this.isPlayerAI(playerIndex));
                planePool = randomDeck.get(DeckSection.Planes);
            }
        } else if (selected instanceof Deck) {
            planePool = ((Deck)selected).get(DeckSection.Planes);
        }
        if (planePool == null) {
            planePool = DeckgenUtil.generatePlanarPool();
        }
        this.fireDeckSectionChangeListener(playerIndex, DeckSection.Planes, planePool);
        this.getDeckChooser(playerIndex).saveState();
    }

    private void selectVanguardAvatar(int playerIndex) {
        if (playerIndex >= this.activePlayersNum || !this.hasVariant(GameType.Vanguard)) {
            return;
        }
        Object selected = this.vgdAvatarLists.get(playerIndex).getSelectedValue();
        PlayerPanel pp = this.getPlayerPanel(playerIndex);
        CardDetailPanel cdp = this.vgdAvatarDetails.get(playerIndex);
        PaperCard vanguardAvatar = null;
        Deck deck = this.decks[playerIndex];
        if (selected instanceof PaperCard) {
            pp.setVanguardButtonText(((PaperCard)selected).getName());
            cdp.setCard(CardView.getCardForUi((PaperCard)selected));
            cdp.setVisible(true);
            this.refreshPanels(false, true);
            vanguardAvatar = (PaperCard)selected;
        } else {
            String sel = (String)selected;
            pp.setVanguardButtonText(sel);
            cdp.setVisible(false);
            if (sel == null) {
                return;
            }
            vanguardAvatar = sel.contains("Use deck's default avatar") && deck != null && deck.has(DeckSection.Avatar) ? deck.get(DeckSection.Avatar).get(0) : (this.isPlayerAI(playerIndex) ? Aggregates.random(this.getNonRandomAiAvatars()) : Aggregates.random(this.getNonRandomHumanAvatars()));
        }
        CardPool avatarOnce = new CardPool();
        avatarOnce.add(vanguardAvatar);
        this.fireDeckSectionChangeListener(playerIndex, DeckSection.Avatar, avatarOnce);
        this.getDeckChooser(playerIndex).saveState();
    }

    private void populateDeckPanel(GameType forGameType) {
        this.decksFrame.removeAll();
        if (!this.lobby.mayEdit(this.playerWithFocus)) {
            return;
        }
        switch (forGameType) {
            case Constructed: {
                this.decksFrame.add((Component)this.getDeckChooser(this.playerWithFocus), "grow, push");
                if (!this.getDeckChooser(this.playerWithFocus).getSelectedDeckType().toString().contains(this.localizer.getMessage("lblRandom", new Object[0]))) break;
                String strCheckboxConstraints = "h 30px!, gap 0 20px 0 0";
                this.decksFrame.add((Component)this.cbSingletons, "h 30px!, gap 0 20px 0 0");
                this.decksFrame.add((Component)this.cbArtifacts, "h 30px!, gap 0 20px 0 0");
                break;
            }
            case Archenemy: 
            case ArchenemyRumble: {
                if (this.isPlayerArchenemy(this.playerWithFocus)) {
                    this.decksFrame.add((Component)this.schemeDeckPanels.get(this.playerWithFocus), "grow, push");
                    break;
                }
                this.populateDeckPanel(GameType.Constructed);
                break;
            }
            case Commander: 
            case Oathbreaker: 
            case TinyLeaders: 
            case Brawl: {
                this.decksFrame.add((Component)this.getDeckChooser(this.playerWithFocus), "grow, push");
                break;
            }
            case Planechase: {
                this.decksFrame.add((Component)this.planarDeckPanels.get(this.playerWithFocus), "grow, push");
                break;
            }
            case Vanguard: {
                this.updateVanguardList(this.playerWithFocus);
                this.decksFrame.add((Component)this.vgdPanels.get(this.playerWithFocus), "grow, push");
                break;
            }
        }
        this.refreshPanels(false, true);
    }

    JButton getBtnStart() {
        return this.btnStart;
    }

    public LblHeader getLblTitle() {
        return this.lblTitle;
    }

    public JPanel getConstructedFrame() {
        return this.constructedFrame;
    }

    public JPanel getPanelStart() {
        return this.pnlStart;
    }

    public List<FDeckChooser> getDeckChoosers() {
        ArrayList<FDeckChooser> choosers = new ArrayList<FDeckChooser>(this.playerPanels.size());
        for (PlayerPanel playerPanel : this.playerPanels) {
            choosers.add(playerPanel.getDeckChooser());
        }
        return choosers;
    }

    FCheckBox getCbSingletons() {
        return this.cbSingletons;
    }

    FCheckBox getCbArtifacts() {
        return this.cbArtifacts;
    }

    public final List<PlayerPanel> getPlayerPanels() {
        return this.playerPanels;
    }

    private PlayerPanel getPlayerPanelWithFocus() {
        return this.getPlayerPanels().get(this.playerWithFocus);
    }

    boolean hasFocus(int iPlayer) {
        return iPlayer == this.playerWithFocus;
    }

    void setCurrentGameMode(GameType mode) {
        this.lobby.setGameType(mode);
        this.update(true);
    }

    private boolean isPlayerAI(int playernum) {
        if (playernum < this.activePlayersNum) {
            return this.playerPanels.get(playernum).isAi();
        }
        return true;
    }

    private void refreshPanels(boolean refreshPlayerFrame, boolean refreshDeckFrame) {
        if (refreshPlayerFrame) {
            this.playersScroll.validate();
            this.playersScroll.repaint();
        }
        if (refreshDeckFrame) {
            this.decksFrame.validate();
            this.decksFrame.repaint();
        }
    }

    public void changePlayerFocus(int newFocusOwner) {
        this.changePlayerFocus(newFocusOwner, this.lobby.getGameType());
    }

    void changePlayerFocus(int newFocusOwner, GameType gType) {
        PlayerPanel oldFocus = this.getPlayerPanelWithFocus();
        if (oldFocus != null) {
            oldFocus.setFocused(false);
        }
        this.playerWithFocus = newFocusOwner;
        PlayerPanel newFocus = this.getPlayerPanelWithFocus();
        newFocus.setFocused(true);
        this.playersScroll.getViewport().scrollRectToVisible(newFocus.getBounds());
        this.populateDeckPanel(gType);
        this.refreshPanels(true, true);
    }

    void updateAvatarPrefs() {
        int pOneIndex = this.getPlayerPanel(0).getAvatarIndex();
        int pTwoIndex = this.getPlayerPanel(1).getAvatarIndex();
        prefs.setPref(ForgePreferences.FPref.UI_AVATARS, pOneIndex + "," + pTwoIndex);
        prefs.save();
    }

    void updateSleevePrefs() {
        int pOneIndex = this.getPlayerPanel(0).getSleeveIndex();
        int pTwoIndex = this.getPlayerPanel(1).getSleeveIndex();
        prefs.setPref(ForgePreferences.FPref.UI_SLEEVES, pOneIndex + "," + pTwoIndex);
        prefs.save();
    }

    FLabel newLabel(String title) {
        return new FLabel.Builder().text(title).fontSize(14).fontStyle(2).build();
    }

    List<Integer> getUsedAvatars() {
        ArrayList<Integer> usedAvatars = Lists.newArrayListWithCapacity(8);
        for (PlayerPanel pp : this.playerPanels) {
            usedAvatars.add(pp.getAvatarIndex());
        }
        return usedAvatars;
    }

    List<Integer> getUsedSleeves() {
        ArrayList<Integer> usedSleeves = Lists.newArrayListWithCapacity(8);
        for (PlayerPanel pp : this.playerPanels) {
            usedSleeves.add(pp.getSleeveIndex());
        }
        return usedSleeves;
    }

    final String getNewName() {
        String newName;
        String confirmMsg;
        FSkin.SkinImage icon;
        String title = this.localizer.getMessage("lblGetNewRandomName", new Object[0]);
        String message = this.localizer.getMessage("lbltypeofName", new Object[0]);
        int genderIndex = FOptionPane.showOptionDialog(message, title, icon = FOptionPane.QUESTION_ICON, genderOptions, 2);
        if (genderIndex < 0) {
            return null;
        }
        int typeIndex = FOptionPane.showOptionDialog(message, title, icon, typeOptions, 2);
        if (typeIndex < 0) {
            return null;
        }
        String gender = (String)genderOptions.get(genderIndex);
        String type = (String)typeOptions.get(typeIndex);
        List<String> usedNames = this.getPlayerNames();
        do {
            newName = NameGenerator.getRandomName(gender, type, usedNames);
        } while (!FOptionPane.showConfirmDialog(confirmMsg = this.localizer.getMessage("lblconfirmName", new Object[0]).replace("%s", "\"" + newName + "\""), title, this.localizer.getMessage("lblUseThisName", new Object[0]), this.localizer.getMessage("lblTryAgain", new Object[0]), true));
        return newName;
    }

    List<String> getPlayerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PlayerPanel pp : this.playerPanels) {
            names.add(pp.getPlayerName());
        }
        return names;
    }

    private FDeckChooser createDeckChooser(GameType type, int iSlot, boolean ai) {
        ForgePreferences.FPref prefKey;
        DeckType deckType;
        boolean forCommander;
        switch (type) {
            case Commander: {
                forCommander = true;
                deckType = iSlot == 0 ? DeckType.COMMANDER_DECK : DeckType.RANDOM_CARDGEN_COMMANDER_DECK;
                prefKey = ForgePreferences.FPref.COMMANDER_DECK_STATES[iSlot];
                break;
            }
            case TinyLeaders: {
                forCommander = true;
                deckType = iSlot == 0 ? DeckType.TINY_LEADERS_DECK : DeckType.RANDOM_CARDGEN_COMMANDER_DECK;
                prefKey = ForgePreferences.FPref.TINY_LEADER_DECK_STATES[iSlot];
                break;
            }
            case Oathbreaker: {
                forCommander = true;
                deckType = iSlot == 0 ? DeckType.OATHBREAKER_DECK : DeckType.RANDOM_CARDGEN_COMMANDER_DECK;
                prefKey = ForgePreferences.FPref.OATHBREAKER_DECK_STATES[iSlot];
                break;
            }
            case Brawl: {
                forCommander = true;
                deckType = iSlot == 0 ? DeckType.BRAWL_DECK : DeckType.CUSTOM_DECK;
                prefKey = ForgePreferences.FPref.BRAWL_DECK_STATES[iSlot];
                break;
            }
            default: {
                forCommander = false;
                deckType = iSlot == 0 ? DeckType.PRECONSTRUCTED_DECK : DeckType.COLOR_DECK;
                prefKey = ForgePreferences.FPref.CONSTRUCTED_DECK_STATES[iSlot];
            }
        }
        return this.cachedDeckChoosers.computeIfAbsent(prefKey, key -> {
            GameType gameType = forCommander ? type : GameType.Constructed;
            FDeckChooser fdc = new FDeckChooser(null, ai, gameType, forCommander);
            fdc.initialize(prefKey, deckType);
            fdc.getLstDecks().setSelectCommand(() -> this.selectMainDeck(fdc, iSlot, forCommander));
            return fdc;
        });
    }

    public List<FList<Object>> getPlanarDeckLists() {
        return this.planarDeckLists;
    }

    public List<FList<Object>> getSchemeDeckLists() {
        return this.schemeDeckLists;
    }

    public boolean isPlayerArchenemy(int playernum) {
        return this.getPlayerPanel(playernum).isArchenemy();
    }

    public List<FList<Object>> getVanguardLists() {
        return this.vgdAvatarLists;
    }

    public Iterable<PaperCard> getAllAvatars() {
        if (this.vgdAllAvatars.isEmpty()) {
            for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
                if (!c.getRules().getType().isVanguard()) continue;
                this.vgdAllAvatars.add(c);
            }
        }
        return this.vgdAllAvatars;
    }

    public List<PaperCard> getNonRandomHumanAvatars() {
        return this.nonRandomHumanAvatars;
    }

    public List<PaperCard> getNonRandomAiAvatars() {
        return this.nonRandomAiAvatars;
    }

    private void populateVanguardLists() {
        this.humanListData.add("Use deck's default avatar (random if unavailable)");
        this.humanListData.add("Random");
        this.aiListData.add("Use deck's default avatar (random if unavailable)");
        this.aiListData.add("Random");
        for (PaperCard cp : this.getAllAvatars()) {
            this.humanListData.add(cp);
            if (!cp.getRules().getAiHints().getRemRandomDecks()) {
                this.nonRandomHumanAvatars.add(cp);
            }
            if (cp.getRules().getAiHints().getRemAIDecks()) continue;
            this.aiListData.add(cp);
            if (cp.getRules().getAiHints().getRemRandomDecks()) continue;
            this.nonRandomAiAvatars.add(cp);
        }
    }

    public void updateVanguardList(int playerIndex) {
        FList<Object> vgdList = this.getVanguardLists().get(playerIndex);
        Object lastSelection = vgdList.getSelectedValue();
        vgdList.setListData(this.isPlayerAI(playerIndex) ? this.aiListData : this.humanListData);
        if (null != lastSelection) {
            vgdList.setSelectedValue(lastSelection, true);
        }
        if (-1 == vgdList.getSelectedIndex()) {
            vgdList.setSelectedIndex(0);
        }
    }

    private class VariantCheckBox
    extends FCheckBox {
        private final GameType variant;

        private VariantCheckBox(GameType variantType) {
            super(variantType.toString());
            this.variant = variantType;
            this.setToolTipText(variantType.getDescription());
            this.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    VLobby.this.lobby.applyVariant(variantType);
                } else {
                    VLobby.this.lobby.removeVariant(variantType);
                }
                VLobby.this.update(false);
            });
        }
    }
}

