/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import forge.Singletons;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.ILocalRepaint;
import forge.gui.framework.IVTopLevelUI;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.home.CHomeUI;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.LblGroup;
import forge.screens.home.LblMenuItem;
import forge.screens.home.PnlGroup;
import forge.screens.home.gauntlet.VSubmenuGauntletBuild;
import forge.screens.home.gauntlet.VSubmenuGauntletCommander;
import forge.screens.home.gauntlet.VSubmenuGauntletContests;
import forge.screens.home.gauntlet.VSubmenuGauntletLoad;
import forge.screens.home.gauntlet.VSubmenuGauntletQuick;
import forge.screens.home.online.VSubmenuOnlineLobby;
import forge.screens.home.puzzle.VSubmenuPuzzleCreate;
import forge.screens.home.puzzle.VSubmenuPuzzleSolve;
import forge.screens.home.quest.VSubmenuChallenges;
import forge.screens.home.quest.VSubmenuDuels;
import forge.screens.home.quest.VSubmenuQuestDecks;
import forge.screens.home.quest.VSubmenuQuestDraft;
import forge.screens.home.quest.VSubmenuQuestLoadData;
import forge.screens.home.quest.VSubmenuQuestPrefs;
import forge.screens.home.quest.VSubmenuQuestStart;
import forge.screens.home.sanctioned.VSubmenuConstructed;
import forge.screens.home.sanctioned.VSubmenuDraft;
import forge.screens.home.sanctioned.VSubmenuSealed;
import forge.screens.home.settings.VSubmenuAchievements;
import forge.screens.home.settings.VSubmenuAvatars;
import forge.screens.home.settings.VSubmenuDownloaders;
import forge.screens.home.settings.VSubmenuPreferences;
import forge.screens.home.settings.VSubmenuReleaseNotes;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPanel;
import forge.toolbox.FSkin;
import forge.view.FView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VHomeUI implements IVTopLevelUI
{
    SINGLETON_INSTANCE;

    private final FSkin.SkinColor clrTheme = FSkin.getColor(FSkin.Colors.CLR_THEME);
    private final FSkin.SkinColor l00 = this.clrTheme.stepColor(0);
    private final List<IVSubmenu<? extends ICDoc>> allSubmenus = new ArrayList<IVSubmenu<? extends ICDoc>>();
    private final Map<EDocID, LblMenuItem> allSubmenuLabels = new HashMap<EDocID, LblMenuItem>();
    private final Map<EMenuGroup, LblGroup> allGroupLabels = new HashMap<EMenuGroup, LblGroup>();
    private final PnlMenu pnlMenu = new PnlMenu();
    private final PnlDisplay pnlDisplay = new PnlDisplay();
    private final FScrollPanel pnlSubmenus;
    private JLabel lblLogo = new FLabel.Builder().icon(FSkin.getIcon(FSkinProp.ICO_LOGO)).iconAlignX(0).iconInBackground(true).iconScaleFactor(1.0).build();

    private VHomeUI() {
        JPanel pnlMainMenu = new JPanel(new MigLayout("w 200px!, ax center, insets 0, gap 0, wrap"));
        pnlMainMenu.setOpaque(false);
        int logoSize = 170;
        int logoBottomGap = 4;
        int pnlMainMenuHeight = 174;
        pnlMainMenu.add((Component)this.lblLogo, "w 170px!, h 170px!, gap 0 4px 0 4px");
        this.pnlMenu.add(pnlMainMenu);
        this.pnlSubmenus = new FScrollPanel(new MigLayout("insets 0, gap 0, wrap, hidemode 3"), true, 20, 31);
        this.allSubmenus.add(VSubmenuConstructed.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuDraft.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuSealed.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuOnlineLobby.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuQuestStart.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuQuestLoadData.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuQuestDecks.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuDuels.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuChallenges.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuQuestDraft.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuQuestPrefs.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuGauntletQuick.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuGauntletBuild.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuGauntletLoad.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuGauntletContests.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuGauntletCommander.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuPuzzleSolve.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuPuzzleCreate.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuPreferences.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuAchievements.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuAvatars.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuDownloaders.SINGLETON_INSTANCE);
        this.allSubmenus.add(VSubmenuReleaseNotes.SINGLETON_INSTANCE);
        TreeMap<EMenuGroup, PnlGroup> allGroupPanels = new TreeMap<EMenuGroup, PnlGroup>();
        for (EMenuGroup e : EMenuGroup.values()) {
            allGroupPanels.put(e, new PnlGroup());
            ((JPanel)allGroupPanels.get((Object)e)).setVisible(false);
            ((JPanel)allGroupPanels.get((Object)e)).setLayout(new MigLayout("insets 0, gap 0, wrap"));
            ((JPanel)allGroupPanels.get((Object)e)).setName(e.toString());
        }
        for (IVSubmenu iVSubmenu : this.allSubmenus) {
            this.allSubmenuLabels.put(iVSubmenu.getItemEnum(), new LblMenuItem(iVSubmenu));
            ((JPanel)allGroupPanels.get((Object)iVSubmenu.getGroupEnum())).add((Component)this.allSubmenuLabels.get((Object)iVSubmenu.getItemEnum()), "w 100%!, h 30px!, gap 0 0 1px 1px");
        }
        for (EMenuGroup eMenuGroup : allGroupPanels.keySet()) {
            this.allGroupLabels.put(eMenuGroup, new LblGroup(eMenuGroup));
            this.pnlSubmenus.add((Component)this.allGroupLabels.get((Object)eMenuGroup), "w 100%!, h 30px!, gap 0 0 3px 3px");
            this.pnlSubmenus.add((Component)allGroupPanels.get((Object)eMenuGroup), "w 100%!, gap 0 0 0 0");
            if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.valueOf("SUBMENU_" + eMenuGroup.toString()))) continue;
            this.allGroupLabels.get((Object)eMenuGroup).groupClick(eMenuGroup);
        }
        this.pnlMenu.add((Component)this.pnlSubmenus, "w 100%!, h 100% - 174px!");
        this.pnlDisplay.setBackground(this.l00.alphaColor(100));
    }

    public JPanel getPnlMenu() {
        return this.pnlMenu;
    }

    public PnlDisplay getPnlDisplay() {
        return this.pnlDisplay;
    }

    public FScrollPanel getPnlSubmenus() {
        return this.pnlSubmenus;
    }

    public Map<EDocID, LblMenuItem> getAllSubmenuLabels() {
        return this.allSubmenuLabels;
    }

    @Override
    public void instantiate() {
    }

    @Override
    public void populate() {
        FPanel pnl = FView.SINGLETON_INSTANCE.getPnlInsets();
        ((JComponent)pnl).setBorder(null);
        pnl.setLayout(new MigLayout("insets 0, gap 0"));
        pnl.add((Component)this.pnlMenu, "w 205px!, h 100%!");
        pnl.add((Component)this.pnlDisplay, "w 100% - 205px!, h 100%!");
    }

    @Override
    public boolean onSwitching(FScreen fromScreen, FScreen toScreen) {
        return true;
    }

    @Override
    public boolean onClosing(FScreen screen) {
        Singletons.getControl().exitForge();
        return false;
    }

    private class PnlMenu
    extends JPanel {
        private final FSkin.SkinColor d80;

        public PnlMenu() {
            this.d80 = VHomeUI.this.clrTheme.stepColor(-80);
            this.setLayout(new MigLayout("insets 0, gap 0, wrap, hidemode 3"));
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            LblMenuItem lblSelected = CHomeUI.SINGLETON_INSTANCE.getLblSelected();
            FScrollPanel scrollPanel = SINGLETON_INSTANCE.getPnlSubmenus();
            Graphics2D g2d = (Graphics2D)g2.create();
            int w = this.getWidth();
            int y1 = 0;
            int y2 = 0;
            int h1 = this.getHeight();
            int h2 = 0;
            if (lblSelected.isShowing()) {
                int scrollPanelTop = scrollPanel.getY();
                int labelTop = lblSelected.getY() + lblSelected.getParent().getY() + scrollPanelTop - scrollPanel.getVerticalScrollBar().getValue();
                y2 = labelTop + lblSelected.getHeight();
                if (y2 > scrollPanelTop) {
                    if (labelTop < scrollPanelTop) {
                        labelTop = scrollPanelTop;
                    }
                    h2 = h1 - y2;
                    h1 = labelTop - y1;
                }
            }
            FSkin.setGraphicsColor(g2d, VHomeUI.this.l00);
            g2d.fillRect(0, y1, w, h1);
            if (h2 > 0) {
                g2d.fillRect(0, y2, w, h2);
            }
            int x = w - 8;
            FSkin.setGraphicsGradientPaint(g2d, (float)x, 0.0f, VHomeUI.this.l00, (float)w, 0.0f, this.d80);
            g2d.fillRect(x, y1, w, h1);
            if (h2 > 0) {
                g2d.fillRect(x, y2, w, h2);
            }
            g2d.dispose();
        }
    }

    public class PnlDisplay
    extends FSkin.SkinnedPanel
    implements ILocalRepaint {
        public PnlDisplay() {
            this.setOpaque(false);
        }

        @Override
        public void repaintSelf() {
            Dimension d = this.getSize();
            this.repaint(0, 0, d.width, d.height);
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g2d = (Graphics2D)g2.create();
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
        }
    }
}

