/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import forge.Singletons;
import forge.ai.AIOption;
import forge.deck.DeckSection;
import forge.deckchooser.FDeckChooser;
import forge.game.GameType;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gui.framework.FScreen;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorVariant;
import forge.screens.home.VLobby;
import forge.screens.home.sanctioned.AvatarSelector;
import forge.screens.home.sanctioned.SleeveSelector;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FPanel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.NameGenerator;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class PlayerPanel
extends FPanel {
    final Localizer localizer = Localizer.getInstance();
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final FSkin.SkinColor unfocusedPlayerOverlay = FSkin.getColor(FSkin.Colors.CLR_OVERLAY).alphaColor(120);
    private LobbySlotType type;
    private final int index;
    private String playerName = "";
    private boolean mayEdit;
    private boolean mayControl;
    private boolean mayRemove;
    private final FLabel nameRandomiser;
    private final FLabel avatarLabel = new FLabel.Builder().opaque(true).hoverable(true).iconScaleFactor(0.99f).iconInBackground(true).build();
    private final FLabel sleeveLabel = new FLabel.Builder().opaque(true).hoverable(true).iconScaleFactor(0.99f).iconInBackground(true).build();
    private int avatarIndex;
    private int sleeveIndex;
    private final FTextField txtPlayerName = new FTextField.Builder().build();
    private FRadioButton radioHuman;
    private FRadioButton radioAi;
    private JCheckBoxMenuItem radioAiUseSimulation;
    private FRadioButton radioOpen;
    private FCheckBox chkReady;
    private final FComboBoxWrapper<Object> teamComboBox = new FComboBoxWrapper();
    private final FComboBoxWrapper<Object> aeTeamComboBox = new FComboBoxWrapper();
    private final FLabel closeBtn;
    private final FLabel deckBtn = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSelectaDeck", new Object[0])).build();
    private final FLabel deckLabel;
    private final String variantBtnConstraints = "height 30px, hidemode 3";
    private final FLabel scmDeckSelectorBtn = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSelectaSchemeDeck", new Object[0])).build();
    private final FLabel scmDeckEditor = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSchemeDeckEditor", new Object[0])).build();
    private final FLabel scmLabel;
    private final FLabel cmdDeckSelectorBtn = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSelectaCommanderDeck", new Object[0])).build();
    private final FLabel cmdLabel;
    private final FLabel pchDeckSelectorBtn = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSelectaPlanarDeck", new Object[0])).build();
    private final FLabel pchDeckEditor = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblPlanarDeckEditor", new Object[0])).build();
    private final FLabel pchLabel;
    private final FLabel vgdSelectorBtn = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblSelectaVanguardAvatar", new Object[0])).build();
    private final FLabel vgdLabel;
    private FCheckBox chkDevMode;
    private boolean allowNetworking;
    private FDeckChooser deckChooser;
    private final VLobby lobby;
    private final FocusAdapter nameFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source instanceof FTextField) {
                FTextField nField = (FTextField)source;
                String newName = nField.getText().trim();
                if (PlayerPanel.this.index == 0 && !StringUtils.isBlank(newName) && StringUtils.isAlphanumericSpace(newName) && prefs.getPref(ForgePreferences.FPref.PLAYER_NAME) != newName) {
                    prefs.setPref(ForgePreferences.FPref.PLAYER_NAME, newName);
                    prefs.save();
                }
                PlayerPanel.this.lobby.firePlayerChangeListener(PlayerPanel.this.index);
            }
        }
    };
    private final FocusAdapter avatarFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
        }
    };
    private final FMouseAdapter avatarMouseListener = new FMouseAdapter(){

        @Override
        public void onLeftClick(MouseEvent e) {
            if (!PlayerPanel.this.avatarLabel.isEnabled()) {
                return;
            }
            FLabel avatar = (FLabel)e.getSource();
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
            avatar.requestFocusInWindow();
            AvatarSelector aSel = new AvatarSelector(PlayerPanel.this.playerName, PlayerPanel.this.avatarIndex, PlayerPanel.this.lobby.getUsedAvatars());
            for (FLabel lbl : aSel.getSelectables()) {
                lbl.setCommand(() -> {
                    PlayerPanel.this.setAvatarIndex(Integer.parseInt(lbl.getName().substring(11)));
                    aSel.setVisible(false);
                });
            }
            aSel.setVisible(true);
            aSel.dispose();
            if (PlayerPanel.this.index < 2) {
                PlayerPanel.this.lobby.updateAvatarPrefs();
            }
            PlayerPanel.this.lobby.firePlayerChangeListener(PlayerPanel.this.index);
        }

        @Override
        public void onRightClick(MouseEvent e) {
            if (!PlayerPanel.this.avatarLabel.isEnabled()) {
                return;
            }
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
            PlayerPanel.this.avatarLabel.requestFocusInWindow();
            PlayerPanel.this.setRandomAvatar();
            if (PlayerPanel.this.index < 2) {
                PlayerPanel.this.lobby.updateAvatarPrefs();
            }
        }
    };
    private final FocusAdapter sleeveFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
        }
    };
    private final FMouseAdapter sleeveMouseListener = new FMouseAdapter(){

        @Override
        public void onLeftClick(MouseEvent e) {
            if (!PlayerPanel.this.sleeveLabel.isEnabled()) {
                return;
            }
            FLabel sleeve = (FLabel)e.getSource();
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
            sleeve.requestFocusInWindow();
            SleeveSelector sSel = new SleeveSelector(PlayerPanel.this.playerName, PlayerPanel.this.sleeveIndex, PlayerPanel.this.lobby.getUsedSleeves());
            for (FLabel lbl : sSel.getSelectables()) {
                lbl.setCommand(() -> {
                    PlayerPanel.this.setSleeveIndex(Integer.parseInt(lbl.getName().substring(11)));
                    sSel.setVisible(false);
                });
            }
            sSel.setVisible(true);
            sSel.dispose();
            if (PlayerPanel.this.index < 2) {
                PlayerPanel.this.lobby.updateSleevePrefs();
            }
            PlayerPanel.this.lobby.firePlayerChangeListener(PlayerPanel.this.index);
        }

        @Override
        public void onRightClick(MouseEvent e) {
            if (!PlayerPanel.this.sleeveLabel.isEnabled()) {
                return;
            }
            PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
            PlayerPanel.this.sleeveLabel.requestFocusInWindow();
            PlayerPanel.this.setRandomSleeve();
            if (PlayerPanel.this.index < 2) {
                PlayerPanel.this.lobby.updateSleevePrefs();
            }
        }
    };
    private final ActionListener teamListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FComboBox cb = (FComboBox)e.getSource();
            cb.requestFocusInWindow();
            Object selection = cb.getSelectedItem();
            if (null != selection) {
                PlayerPanel.this.lobby.changePlayerFocus(PlayerPanel.this.index);
                PlayerPanel.this.lobby.firePlayerChangeListener(PlayerPanel.this.index);
            }
        }
    };
    private final FSkin.LineSkinBorder focusedBorder = new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS).alphaColor(255), 3);
    private final FSkin.LineSkinBorder defaultBorder = new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_THEME).alphaColor(200), 2);

    public PlayerPanel(VLobby lobby, boolean allowNetworking, int index, LobbySlot slot, boolean mayEdit, boolean mayControl) {
        this.lobby = lobby;
        this.index = index;
        this.mayEdit = mayEdit;
        this.mayControl = mayControl;
        this.allowNetworking = allowNetworking;
        this.deckLabel = lobby.newLabel(this.localizer.getMessage("lblDeck", new Object[0]) + ":");
        this.scmLabel = lobby.newLabel(this.localizer.getMessage("lblSchemeDeck", new Object[0]) + ":");
        this.cmdLabel = lobby.newLabel(this.localizer.getMessage("lblCommanderDeck", new Object[0]) + ":");
        this.pchLabel = lobby.newLabel(this.localizer.getMessage("lblPlanarDeck", new Object[0]) + ":");
        this.vgdLabel = lobby.newLabel(this.localizer.getMessage("lblVanguard", new Object[0]) + ":");
        this.setLayout(new MigLayout("insets 10px, gap 5px"));
        this.closeBtn = this.createCloseButton();
        this.add((Component)this.closeBtn, "w 20, h 20, pos (container.w-20) 0");
        this.createAvatar();
        this.add((Component)this.avatarLabel, "spany 2, width 80px, height 80px");
        this.createNameEditor();
        this.add((Component)lobby.newLabel(this.localizer.getMessage("lblName", new Object[0]) + ":"), "w 40px, h 30px, gaptop 5px");
        this.add((Component)this.txtPlayerName, "h 30px, pushx, growx");
        this.nameRandomiser = this.createNameRandomizer();
        this.add((Component)this.nameRandomiser, "h 30px, w 30px, gaptop 5px");
        this.createPlayerTypeOptions();
        this.add((Component)this.radioHuman, "gapright 5px");
        this.add((Component)this.radioAi, "wrap");
        this.add((Component)lobby.newLabel(this.localizer.getMessage("lblTeam", new Object[0]) + ":"), "w 40px, h 30px");
        this.populateTeamsComboBoxes();
        this.setTeam(slot == null ? index : slot.getTeam());
        this.setIsArchenemy(slot != null && slot.isArchenemy());
        this.teamComboBox.addActionListener(this.teamListener);
        this.aeTeamComboBox.addActionListener(this.teamListener);
        this.teamComboBox.addTo(this, "height 30px, hidemode 3, pushx, growx, gaptop 5px");
        this.aeTeamComboBox.addTo(this, "height 30px, hidemode 3, pushx, growx, gaptop 5px");
        this.createReadyButton();
        if (allowNetworking) {
            this.add((Component)this.radioOpen, "cell 4 1, ax left, sx 2");
            this.add((Component)this.chkReady, "cell 5 1, ax left, sx 2, wrap");
        }
        this.add((Component)this.deckLabel, "height 30px, hidemode 3, cell 0 2, sx 2, ax right");
        this.add((Component)this.deckBtn, "height 30px, hidemode 3, cell 2 2, pushx, growx, wmax 100%-153px, h 30px, spanx 4, wrap");
        this.addHandlersDeckSelector();
        this.add((Component)this.cmdLabel, "height 30px, hidemode 3, cell 0 2, sx 2, ax right");
        this.add((Component)this.cmdDeckSelectorBtn, "height 30px, hidemode 3, cell 2 2, pushx, growx, wmax 100%-153px, h 30px, spanx 4, wrap");
        this.add((Component)this.scmLabel, "height 30px, hidemode 3, cell 0 4, sx 2, ax right");
        this.add((Component)this.scmDeckSelectorBtn, "height 30px, hidemode 3, cell 2 4, growx, pushx");
        this.add((Component)this.scmDeckEditor, "height 30px, hidemode 3, cell 3 4, sx 3, growx, wrap");
        this.add((Component)this.pchLabel, "height 30px, hidemode 3, cell 0 5, sx 2, ax right");
        this.add((Component)this.pchDeckSelectorBtn, "height 30px, hidemode 3, cell 2 5, growx, pushx");
        this.add((Component)this.pchDeckEditor, "height 30px, hidemode 3, cell 3 5, sx 3, growx, wrap");
        this.add((Component)this.vgdLabel, "height 30px, hidemode 3, cell 0 6, sx 2, ax right");
        this.add((Component)this.vgdSelectorBtn, "height 30px, hidemode 3, cell 2 6, sx 4, growx, wrap");
        this.addHandlersToVariantsControls();
        this.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftMouseDown(MouseEvent e) {
                PlayerPanel.this.avatarLabel.requestFocusInWindow();
            }
        });
        if (this.isNetworkHost()) {
            this.createDevModeButton();
            this.add(this.chkDevMode);
        }
        this.type = slot == null ? LobbySlotType.LOCAL : slot.getType();
        this.setPlayerName(slot == null ? "" : slot.getName());
        this.setAvatarIndex(slot == null ? 0 : slot.getAvatarIndex());
        this.update();
    }

    boolean isNetworkHost() {
        return this.allowNetworking && this.index == 0;
    }

    void update() {
        this.avatarLabel.setEnabled(this.mayEdit);
        this.avatarLabel.setIcon(FSkin.getAvatars().get(this.type == LobbySlotType.OPEN ? -1 : this.avatarIndex));
        this.avatarLabel.repaintSelf();
        this.sleeveLabel.setEnabled(this.mayEdit);
        this.sleeveLabel.setIcon(FSkin.getSleeves().get(this.type == LobbySlotType.OPEN ? -1 : this.sleeveIndex));
        this.sleeveLabel.repaintSelf();
        this.txtPlayerName.setEnabled(this.mayEdit);
        this.txtPlayerName.setText(this.type == LobbySlotType.OPEN ? "" : this.playerName);
        this.nameRandomiser.setEnabled(this.mayEdit);
        this.teamComboBox.setEnabled(this.mayEdit);
        this.deckLabel.setVisible(this.mayEdit);
        this.deckBtn.setVisible(this.mayEdit);
        this.chkReady.setVisible(this.type == LobbySlotType.LOCAL || this.type == LobbySlotType.REMOTE);
        this.chkReady.setEnabled(this.mayEdit);
        if (this.chkDevMode != null) {
            this.chkDevMode.setEnabled(this.mayEdit);
        }
        this.closeBtn.setVisible(this.mayRemove);
        if (this.mayRemove) {
            this.radioHuman.setEnabled(this.mayControl);
            this.radioAi.setEnabled(this.mayControl);
            this.radioOpen.setEnabled(this.mayControl);
        } else {
            this.radioHuman.setVisible(this.mayControl);
            this.radioAi.setVisible(this.mayControl);
            this.radioOpen.setVisible(this.mayControl);
        }
        this.radioHuman.setSelected(this.type == LobbySlotType.LOCAL);
        this.radioAi.setSelected(this.type == LobbySlotType.AI);
        this.radioOpen.setSelected(this.type == LobbySlotType.OPEN);
        this.updateVariantControlsVisibility();
    }

    private FMouseAdapter radioMouseAdapter(final FRadioButton source, final LobbySlotType type) {
        return new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                if (!source.isEnabled()) {
                    return;
                }
                PlayerPanel.this.setType(type);
                PlayerPanel.this.lobby.firePlayerChangeListener(PlayerPanel.this.index);
                PlayerPanel.this.avatarLabel.requestFocusInWindow();
                PlayerPanel.this.lobby.updateVanguardList(PlayerPanel.this.index);
            }
        };
    }

    private void updateVariantControlsVisibility() {
        boolean isOathbreaker = this.lobby.hasVariant(GameType.Oathbreaker);
        boolean isTinyLeaders = this.lobby.hasVariant(GameType.TinyLeaders);
        boolean isBrawl = this.lobby.hasVariant(GameType.Brawl);
        boolean isCommanderApplied = this.mayEdit && (this.lobby.hasVariant(GameType.Commander) || isOathbreaker || isTinyLeaders || isBrawl);
        boolean isPlanechaseApplied = this.mayEdit && this.lobby.hasVariant(GameType.Planechase);
        boolean isVanguardApplied = this.mayEdit && this.lobby.hasVariant(GameType.Vanguard);
        boolean isArchenemyApplied = this.mayEdit && this.lobby.hasVariant(GameType.Archenemy);
        boolean archenemyVisiblity = this.mayEdit && this.lobby.hasVariant(GameType.ArchenemyRumble) || isArchenemyApplied && this.isArchenemy();
        boolean isDeckBuildingAllowed = this.mayEdit && !isCommanderApplied && !this.lobby.hasVariant(GameType.MomirBasic) && !this.lobby.hasVariant(GameType.MoJhoSto);
        this.deckLabel.setVisible(isDeckBuildingAllowed);
        this.deckBtn.setVisible(isDeckBuildingAllowed);
        this.cmdDeckSelectorBtn.setVisible(isCommanderApplied);
        this.cmdLabel.setVisible(isCommanderApplied);
        this.scmDeckSelectorBtn.setVisible(archenemyVisiblity);
        this.scmDeckEditor.setVisible(archenemyVisiblity);
        this.scmLabel.setVisible(archenemyVisiblity);
        this.teamComboBox.setVisible(!isArchenemyApplied);
        this.aeTeamComboBox.setVisible(isArchenemyApplied);
        this.pchDeckSelectorBtn.setVisible(isPlanechaseApplied);
        this.pchDeckEditor.setVisible(isPlanechaseApplied);
        this.pchLabel.setVisible(isPlanechaseApplied);
        this.vgdSelectorBtn.setVisible(isVanguardApplied);
        this.vgdLabel.setVisible(isVanguardApplied);
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (!this.hasFocusInLobby()) {
            FSkin.setGraphicsColor(g2, unfocusedPlayerOverlay);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean hasFocusInLobby() {
        return this.lobby.hasFocus(this.index);
    }

    LobbySlotType getType() {
        return this.type;
    }

    public boolean isAi() {
        return this.type == LobbySlotType.AI;
    }

    public Set<AIOption> getAiOptions() {
        return this.isSimulatedAi() ? ImmutableSet.of(AIOption.USE_SIMULATION) : Collections.emptySet();
    }

    private boolean isSimulatedAi() {
        return this.radioAi.isSelected() && this.radioAiUseSimulation.isSelected();
    }

    public void setUseAiSimulation(boolean useSimulation) {
        this.radioAiUseSimulation.setSelected(useSimulation);
    }

    public boolean isArchenemy() {
        return this.aeTeamComboBox.getSelectedIndex() == 0;
    }

    public void setType(LobbySlotType type) {
        this.type = type;
        switch (type) {
            case LOCAL: {
                this.radioHuman.setSelected(true);
                break;
            }
            case AI: {
                this.radioAi.setSelected(true);
                break;
            }
            case OPEN: {
                this.radioOpen.setSelected(true);
                break;
            }
        }
        this.update();
    }

    public void setRemote(boolean remote) {
        if (remote) {
            this.setType(LobbySlotType.REMOTE);
            this.radioHuman.setSelected(false);
            this.radioAi.setSelected(false);
            this.radioOpen.setSelected(false);
        } else {
            this.setType(LobbySlotType.OPEN);
        }
    }

    public void setVanguardButtonText(String text) {
        this.vgdSelectorBtn.setText(text);
    }

    public void setDeckSelectorButtonText(String text) {
        this.deckBtn.setText(text);
    }

    public void setCommanderDeckSelectorButtonText(String text) {
        this.cmdDeckSelectorBtn.setText(text);
    }

    public void focusOnAvatar() {
        this.avatarLabel.requestFocusInWindow();
    }

    private void populateTeamsComboBoxes() {
        this.aeTeamComboBox.addItem(this.localizer.getMessage("lblArchenemy", new Object[0]));
        this.aeTeamComboBox.addItem(this.localizer.getMessage("lblHeroes", new Object[0]));
        for (int i = 1; i <= 8; ++i) {
            this.teamComboBox.addItem(i);
        }
        this.teamComboBox.setEnabled(true);
    }

    private void addHandlersToVariantsControls() {
        this.scmDeckSelectorBtn.setCommand(() -> {
            this.lobby.setCurrentGameMode(this.lobby.hasVariant(GameType.Archenemy) ? GameType.Archenemy : GameType.ArchenemyRumble);
            this.scmDeckSelectorBtn.requestFocusInWindow();
            this.lobby.changePlayerFocus(this.index);
        });
        this.scmDeckEditor.setCommand(() -> {
            this.lobby.setCurrentGameMode(this.lobby.hasVariant(GameType.Archenemy) ? GameType.Archenemy : GameType.ArchenemyRumble);
            Predicate predSchemes = arg0 -> arg0.getRules().getType().isScheme();
            Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_ARCHENEMY);
            CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorVariant(FModel.getDecks().getScheme(), predSchemes, DeckSection.Schemes, FScreen.DECK_EDITOR_ARCHENEMY, CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture()));
        });
        this.cmdDeckSelectorBtn.setCommand(() -> {
            this.lobby.setCurrentGameMode(this.lobby.hasVariant(GameType.Oathbreaker) ? GameType.Oathbreaker : (this.lobby.hasVariant(GameType.TinyLeaders) ? GameType.TinyLeaders : (this.lobby.hasVariant(GameType.Brawl) ? GameType.Brawl : GameType.Commander)));
            this.cmdDeckSelectorBtn.requestFocusInWindow();
            this.lobby.changePlayerFocus(this.index);
        });
        this.pchDeckSelectorBtn.setCommand(() -> {
            this.lobby.setCurrentGameMode(GameType.Planechase);
            this.pchDeckSelectorBtn.requestFocusInWindow();
            this.lobby.changePlayerFocus(this.index, GameType.Planechase);
        });
        this.pchDeckEditor.setCommand(() -> {
            this.lobby.setCurrentGameMode(GameType.Planechase);
            Predicate predPlanes = arg0 -> arg0.getRules().getType().isPlane() || arg0.getRules().getType().isPhenomenon();
            Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_PLANECHASE);
            CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorVariant(FModel.getDecks().getPlane(), predPlanes, DeckSection.Planes, FScreen.DECK_EDITOR_PLANECHASE, CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture()));
        });
        this.vgdSelectorBtn.setCommand(() -> {
            this.lobby.setCurrentGameMode(GameType.Vanguard);
            this.vgdSelectorBtn.requestFocusInWindow();
            this.lobby.changePlayerFocus(this.index, GameType.Vanguard);
        });
    }

    private void createPlayerTypeOptions() {
        this.radioHuman = new FRadioButton(this.localizer.getMessage("lblHuman", new Object[0]));
        this.radioAi = new FRadioButton(this.localizer.getMessage("lblAI", new Object[0]));
        this.radioOpen = new FRadioButton(this.localizer.getMessage("lblOpen", new Object[0]));
        JPopupMenu menu = new JPopupMenu();
        this.radioAiUseSimulation = new JCheckBoxMenuItem(this.localizer.getMessage("lblUseSimulation", new Object[0]));
        menu.add(this.radioAiUseSimulation);
        this.radioAiUseSimulation.addActionListener(e -> this.lobby.firePlayerChangeListener(this.index));
        this.radioAi.setComponentPopupMenu(menu);
        this.radioHuman.addMouseListener(this.radioMouseAdapter(this.radioHuman, LobbySlotType.LOCAL));
        this.radioAi.addMouseListener(this.radioMouseAdapter(this.radioAi, LobbySlotType.AI));
        this.radioOpen.addMouseListener(this.radioMouseAdapter(this.radioOpen, LobbySlotType.OPEN));
        ButtonGroup tempBtnGroup = new ButtonGroup();
        tempBtnGroup.add(this.radioHuman);
        tempBtnGroup.add(this.radioAi);
        tempBtnGroup.add(this.radioOpen);
    }

    private void createReadyButton() {
        this.chkReady = new FCheckBox(this.localizer.getMessage("lblReady", new Object[0]));
        this.chkReady.addActionListener(e -> this.lobby.setReady(this.index, this.chkReady.isSelected()));
    }

    private void createDevModeButton() {
        this.chkDevMode = new FCheckBox(this.localizer.getMessage("cbDevMode", new Object[0]));
        this.chkDevMode.addActionListener(e -> {
            boolean toggle = this.chkDevMode.isSelected();
            prefs.setPref(ForgePreferences.FPref.DEV_MODE_ENABLED, String.valueOf(toggle));
            ForgePreferences.DEV_MODE = toggle;
            prefs.save();
            this.lobby.setDevMode(this.index);
        });
    }

    private void addHandlersDeckSelector() {
        this.deckBtn.setCommand(() -> {
            this.lobby.setCurrentGameMode(GameType.Constructed);
            this.deckBtn.requestFocusInWindow();
            this.lobby.changePlayerFocus(this.index, GameType.Constructed);
        });
    }

    private FLabel createNameRandomizer() {
        FLabel newNameBtn = new FLabel.Builder().tooltip(this.localizer.getMessage("lblGetaNewRandomName", new Object[0])).iconInBackground(false).icon(FSkin.getIcon(FSkinProp.ICO_EDIT)).hoverable(true).opaque(false).unhoveredAlpha(0.9f).build();
        newNameBtn.setCommand(() -> {
            String newName = this.lobby.getNewName();
            if (null == newName) {
                return;
            }
            this.txtPlayerName.setText(newName);
            if (this.index == 0) {
                prefs.setPref(ForgePreferences.FPref.PLAYER_NAME, newName);
                prefs.save();
            }
            this.txtPlayerName.requestFocus();
            this.lobby.changePlayerFocus(this.index);
        });
        newNameBtn.addFocusListener(this.nameFocusListener);
        return newNameBtn;
    }

    private void createNameEditor() {
        String name;
        if (this.index == 0) {
            name = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
            if (name.isEmpty()) {
                name = this.localizer.getMessage("lblHuman", new Object[0]);
            }
        } else {
            name = NameGenerator.getRandomName("Any", "Any", this.lobby.getPlayerNames());
        }
        this.txtPlayerName.setText(name);
        this.txtPlayerName.setFocusable(true);
        this.txtPlayerName.setFont(FSkin.getRelativeFont(14));
        this.txtPlayerName.addActionListener(this.lobby.nameListener);
        this.txtPlayerName.addFocusListener(this.nameFocusListener);
    }

    private FLabel createCloseButton() {
        FLabel closeBtn = new FLabel.Builder().tooltip(this.localizer.getMessage("lblRemove", new Object[0])).iconInBackground(false).icon(FSkin.getIcon(FSkinProp.ICO_CLOSE)).hoverable(true).build();
        closeBtn.setCommand(() -> {
            if (this.type == LobbySlotType.REMOTE && !SOptionPane.showConfirmDialog(String.format(this.localizer.getMessage("lblReallyKick", new Object[0]), this.playerName), this.localizer.getMessage("lblKick", new Object[0]), false)) {
                return;
            }
            this.lobby.removePlayer(this.index);
        });
        return closeBtn;
    }

    private void createAvatar() {
        String[] currentPrefs = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        if (this.index < currentPrefs.length) {
            this.avatarIndex = Integer.parseInt(currentPrefs[this.index]);
            this.avatarLabel.setIcon(FSkin.getAvatars().get(this.avatarIndex));
        } else {
            this.setRandomAvatar(false);
        }
        this.avatarLabel.setToolTipText(this.localizer.getMessage("ttlblAvatar", new Object[0]));
        this.avatarLabel.addFocusListener(this.avatarFocusListener);
        this.avatarLabel.addMouseListener(this.avatarMouseListener);
    }

    private void createSleeve() {
        String[] currentPrefs = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SLEEVES).split(",");
        if (this.index < currentPrefs.length) {
            this.sleeveIndex = Integer.parseInt(currentPrefs[this.index]);
            this.sleeveLabel.setIcon(FSkin.getSleeves().get(this.sleeveIndex));
        } else {
            this.setRandomSleeve(false);
        }
        this.sleeveLabel.setToolTipText("L-click: Select sleeve. R-click: Randomize sleeve.");
        this.sleeveLabel.addFocusListener(this.sleeveFocusListener);
        this.sleeveLabel.addMouseListener(this.sleeveMouseListener);
    }

    private void setRandomAvatar() {
        this.setRandomAvatar(true);
    }

    private void setRandomAvatar(boolean fireListeners) {
        int random = 0;
        List<Integer> usedAvatars = this.lobby.getUsedAvatars();
        while (usedAvatars.contains(random = MyRandom.getRandom().nextInt(FSkin.getAvatars().size()))) {
        }
        this.setAvatarIndex(random);
        if (fireListeners) {
            this.lobby.firePlayerChangeListener(this.index);
        }
    }

    private void setRandomSleeve() {
        this.setRandomSleeve(true);
    }

    private void setRandomSleeve(boolean fireListeners) {
        int random = 0;
        List<Integer> usedSleeves = this.lobby.getUsedSleeves();
        while (usedSleeves.contains(random = MyRandom.getRandom().nextInt(FSkin.getSleeves().size()))) {
        }
        this.setSleeveIndex(random);
        if (fireListeners) {
            this.lobby.firePlayerChangeListener(this.index);
        }
    }

    public void setFocused(boolean focused) {
        this.avatarLabel.setBorder(focused ? this.focusedBorder : this.defaultBorder);
    }

    String getPlayerName() {
        return this.txtPlayerName.getText();
    }

    public void setPlayerName(String string) {
        this.playerName = string;
        this.txtPlayerName.setText(string);
    }

    public int getAvatarIndex() {
        return this.avatarIndex;
    }

    public void setAvatarIndex(int avatarIndex0) {
        this.avatarIndex = avatarIndex0;
        FSkin.SkinImage icon = FSkin.getAvatars().get(this.avatarIndex);
        this.avatarLabel.setIcon(icon);
        this.avatarLabel.repaintSelf();
    }

    public int getSleeveIndex() {
        return this.sleeveIndex;
    }

    public void setSleeveIndex(int sleeveIndex0) {
        this.sleeveIndex = sleeveIndex0;
        FSkin.SkinImage icon = FSkin.getSleeves().get(this.sleeveIndex);
        this.sleeveLabel.setIcon(icon);
        this.sleeveLabel.repaintSelf();
    }

    public int getTeam() {
        return this.teamComboBox.getSelectedIndex();
    }

    public void setTeam(int team) {
        this.teamComboBox.suppressActionListeners();
        this.teamComboBox.setSelectedIndex(team);
        this.teamComboBox.unsuppressActionListeners();
    }

    public int getArchenemyTeam() {
        return this.aeTeamComboBox.getSelectedIndex();
    }

    public void setIsArchenemy(boolean isArchenemy) {
        this.aeTeamComboBox.suppressActionListeners();
        this.aeTeamComboBox.setSelectedIndex(isArchenemy ? 0 : 1);
        this.aeTeamComboBox.unsuppressActionListeners();
    }

    public boolean isReady() {
        return this.chkReady.isSelected();
    }

    public void setIsReady(boolean isReady) {
        this.chkReady.setSelected(isReady);
    }

    public boolean isDevMode() {
        return this.chkDevMode != null && this.chkDevMode.isSelected();
    }

    public void setIsDevMode(boolean isDevMode) {
        if (this.chkDevMode != null) {
            this.chkDevMode.setSelected(isDevMode);
        }
    }

    public void setMayEdit(boolean mayEdit) {
        this.mayEdit = mayEdit;
    }

    public void setMayControl(boolean mayControl) {
        this.mayControl = mayControl;
    }

    public void setMayRemove(boolean mayRemove) {
        this.mayRemove = mayRemove;
    }

    FDeckChooser getDeckChooser() {
        return this.deckChooser;
    }

    void setDeckChooser(FDeckChooser deckChooser) {
        this.deckChooser = deckChooser;
    }
}

