/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import forge.gui.framework.ICDoc;
import forge.gui.framework.ILocalRepaint;
import forge.screens.home.CHomeUI;
import forge.screens.home.IVSubmenu;
import forge.toolbox.FSkin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class LblMenuItem
extends FSkin.SkinnedLabel
implements ILocalRepaint {
    private boolean selected = false;
    private boolean hovered = false;
    private final FSkin.SkinColor clrTheme = FSkin.getColor(FSkin.Colors.CLR_THEME);
    private final FSkin.SkinColor l00 = this.clrTheme.stepColor(0);
    private final FSkin.SkinColor l20 = this.clrTheme.stepColor(20);
    private final FSkin.SkinColor d20 = this.clrTheme.stepColor(-20);
    private final FSkin.SkinColor d60 = this.clrTheme.stepColor(-60);
    private final FSkin.SkinColor d80 = this.clrTheme.stepColor(-80);
    private final FSkin.SkinColor alpha100 = this.l00.alphaColor(100);

    public LblMenuItem(final IVSubmenu<? extends ICDoc> doc0) {
        super("      " + doc0.getMenuTitle());
        this.setFont(FSkin.getRelativeFont(14));
        this.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CHomeUI.SINGLETON_INSTANCE.itemClick(doc0.getDocumentID());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LblMenuItem.this.hovered = true;
                LblMenuItem.this.repaintSelf();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LblMenuItem.this.hovered = false;
                LblMenuItem.this.repaintSelf();
            }
        });
    }

    public void setSelected(boolean b0) {
        this.selected = b0;
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        int w = this.getWidth();
        int h2 = this.getHeight();
        if (this.selected) {
            FSkin.setGraphicsColor(g2d, this.alpha100);
            g2d.fillRect(0, 0, w, h2);
            FSkin.setGraphicsColor(g2d, this.d20);
            g2d.drawLine(0, 0, w - 3, 0);
            FSkin.setGraphicsColor(g2d, this.l20);
            g2d.drawLine(0, h2 - 1, w - 3, h2 - 1);
        } else if (this.hovered) {
            FSkin.setGraphicsColor(g2d, this.d60);
            g2d.fillRect(0, 0, this.getWidth(), h2);
            FSkin.setGraphicsGradientPaint(g2d, 192.0f, 0.0f, this.l00, 200.0f, 0.0f, this.d80);
            g2d.fillRect(w - 2, 0, w, h2);
            FSkin.setGraphicsColor(g2d, this.d20);
            g2d.drawLine(0, 0, w - 3, 0);
            FSkin.setGraphicsColor(g2d, this.l20);
            g2d.drawLine(0, h2 - 1, w - 3, h2 - 1);
        }
        super.paintComponent(g2);
        g2d.dispose();
    }
}

