/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import forge.gui.framework.ILocalRepaint;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.EMenuGroup;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class LblGroup
extends FSkin.SkinnedLabel
implements ILocalRepaint {
    private static final boolean isCompactMenu = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_MAIN_MENU);
    private static EMenuGroup activeMenuGroup = null;
    private boolean hovered = false;
    private final FSkin.SkinColor clrTheme = FSkin.getColor(FSkin.Colors.CLR_THEME);
    private final FSkin.SkinColor l20 = this.clrTheme.stepColor(20);
    private final FSkin.SkinColor l25 = this.clrTheme.stepColor(25);
    private final FSkin.SkinColor l40 = this.clrTheme.stepColor(40);
    private final FSkin.SkinColor d20 = this.clrTheme.stepColor(-20);
    private final FSkin.SkinColor d80 = this.clrTheme.stepColor(-80);

    public LblGroup(final EMenuGroup e0) {
        super("  " + e0.getTitle());
        this.setFont(FSkin.getRelativeBoldFont(14));
        this.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LblGroup.this.groupClick(e0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LblGroup.this.hovered = true;
                LblGroup.this.repaintSelf();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LblGroup.this.hovered = false;
                LblGroup.this.repaintSelf();
            }
        });
    }

    public void groupClick(EMenuGroup menuGroup) {
        this.toggleMenuGroupCollapseState(menuGroup);
    }

    private void toggleMenuGroupCollapseState(EMenuGroup menuGroup) {
        if (isCompactMenu) {
            if (menuGroup != activeMenuGroup) {
                if (activeMenuGroup != null) {
                    this.setMenuGroupCollapseState(activeMenuGroup);
                }
                this.setMenuGroupCollapseState(menuGroup);
                activeMenuGroup = menuGroup;
            }
        } else {
            this.setMenuGroupCollapseState(menuGroup);
            activeMenuGroup = menuGroup;
        }
    }

    private void setMenuGroupCollapseState(EMenuGroup e0) {
        Component[] menuObjects;
        for (Component c : menuObjects = this.getParent().getComponents()) {
            if (c.getName() == null || !c.getName().equals(e0.toString())) continue;
            if (c.isVisible()) {
                c.setVisible(false);
                FModel.getPreferences().setPref(ForgePreferences.FPref.valueOf("SUBMENU_" + e0.toString()), "false");
            } else {
                c.setVisible(true);
                FModel.getPreferences().setPref(ForgePreferences.FPref.valueOf("SUBMENU_" + e0.toString()), "true");
            }
            FModel.getPreferences().save();
            break;
        }
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        if (this.hovered) {
            int w = this.getWidth();
            int h2 = this.getHeight();
            FSkin.setGraphicsColor(g2, this.l20);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            FSkin.setGraphicsGradientPaint(g2d, (float)(w - 10), 0.0f, this.l25, (float)w, 0.0f, this.d80);
            g2d.fillRect(w - 10, 0, w, h2);
            FSkin.setGraphicsColor(g2, this.l40);
            g2d.drawLine(0, 0, w - 6, 0);
            FSkin.setGraphicsColor(g2, this.d20);
            g2d.drawLine(0, h2 - 1, w - 6, h2 - 1);
        }
        super.paintComponent(g2);
        g2d.dispose();
    }
}

