/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import com.google.common.collect.Iterables;
import forge.deck.DeckProxy;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.VLobby;
import forge.toolbox.FList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CLobby {
    private final VLobby view;

    public CLobby(VLobby view) {
        this.view = view;
    }

    private void addDecks(Iterable<DeckProxy> commanderDecks, FList<Object> deckList, String ... initialItems) {
        Vector<String> listData = new Vector<String>(Arrays.asList(initialItems));
        listData.add("Generate");
        if (!Iterables.isEmpty(commanderDecks)) {
            listData.add("Random");
            for (DeckProxy comDeck : commanderDecks) {
                listData.add((String)((Object)comDeck.getDeck()));
            }
        }
        Object val = deckList.getSelectedValue();
        deckList.setListData(listData);
        if (null != val) {
            deckList.setSelectedValue(val, true);
        }
        if (-1 == deckList.getSelectedIndex()) {
            deckList.setSelectedIndex(0);
        }
    }

    public void update() {
        SwingUtilities.invokeLater(() -> {
            Iterable<DeckProxy> schemeDecks = DeckProxy.getAllSchemeDecks();
            Iterable<DeckProxy> planarDecks = DeckProxy.getAllPlanarDecks();
            for (int i = 0; i < 8; ++i) {
                this.addDecks(schemeDecks, this.view.getSchemeDeckLists().get(i), "Use deck's scheme section (random if unavailable)");
                this.addDecks(planarDecks, this.view.getPlanarDeckLists().get(i), "Use deck's planes section (random if unavailable)");
                this.view.updateVanguardList(i);
            }
            this.view.getBtnStart().requestFocusInWindow();
        });
    }

    public void initialize() {
        ForgePreferences prefs = FModel.getPreferences();
        this.view.getCbSingletons().addActionListener(arg0 -> {
            prefs.setPref(ForgePreferences.FPref.DECKGEN_SINGLETONS, String.valueOf(this.view.getCbSingletons().isSelected()));
            prefs.save();
        });
        this.view.getCbArtifacts().addActionListener(arg0 -> {
            prefs.setPref(ForgePreferences.FPref.DECKGEN_ARTIFACTS, String.valueOf(this.view.getCbArtifacts().isSelected()));
            prefs.save();
        });
        this.view.getCbSingletons().setSelected(prefs.getPrefBoolean(ForgePreferences.FPref.DECKGEN_SINGLETONS));
        this.view.getCbArtifacts().setSelected(prefs.getPrefBoolean(ForgePreferences.FPref.DECKGEN_ARTIFACTS));
    }
}

