/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.views;

import forge.itemmanager.SItemManagerUtil;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VStatisticsImporter {
    private FLabel lblTotal = new FLabel.Builder().text(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalCards", new Object[0]).toUpperCase(), 0)).tooltip(Localizer.getInstance().getMessage("lblTotalCards", new Object[0])).fontStyle(1).fontSize(10).fontStyle(1).build();
    private FLabel lblTotalMain = new FLabel.Builder().text(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalMain", new Object[0]).toUpperCase(), 0)).tooltip(Localizer.getInstance().getMessage("lblTotalMain", new Object[0])).fontStyle(1).fontSize(10).fontStyle(1).build();
    private FLabel lblTotalSide = new FLabel.Builder().text(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalSide", new Object[0]).toUpperCase(), 0)).tooltip(Localizer.getInstance().getMessage("lblTotalSide", new Object[0])).fontStyle(1).fontSize(10).fontStyle(1).build();
    private FLabel lblTotalCommander = new FLabel.Builder().text(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalCommander", new Object[0]).toUpperCase(), 0)).tooltip(Localizer.getInstance().getMessage("lblTotalCommander", new Object[0])).fontStyle(1).fontSize(10).fontStyle(1).build();
    private FLabel lblTitle = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblSummaryStats", new Object[0])).tooltip(Localizer.getInstance().getMessage("lblSummaryStats", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private final JPanel pnlStats = new JPanel();
    private final FLabel lblMulti = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.MULTICOLOR, true);
    private final FLabel lblBlack = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.BLACK, false);
    private final FLabel lblBlue = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.BLUE, true);
    private final FLabel lblGreen = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.GREEN, false);
    private final FLabel lblRed = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.RED, true);
    private final FLabel lblWhite = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.WHITE, false);
    private final FLabel lblColorless = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.COLORLESS, true);
    private final FLabel lblArtifact = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.ARTIFACT, true);
    private final FLabel lblCreature = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CREATURE, false);
    private final FLabel lblEnchantment = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.ENCHANTMENT, true);
    private final FLabel lblInstant = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.INSTANT, false);
    private final FLabel lblLand = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.LAND, true);
    private final FLabel lblPlaneswalker = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.PLANESWALKER, false);
    private final FLabel lblSorcery = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.SORCERY, true);
    private final FLabel lblCMC0 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_0, true);
    private final FLabel lblCMC1 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_1, false);
    private final FLabel lblCMC2 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_2, true);
    private final FLabel lblCMC3 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_3, false);
    private final FLabel lblCMC4 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_4, true);
    private final FLabel lblCMC5 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_5, false);
    private final FLabel lblCMC6 = VStatisticsImporter.buildLabel(SItemManagerUtil.StatTypes.CMC_6, true);
    private final FScrollPane scroller = new FScrollPane(this.pnlStats, false);
    private final boolean isViewForCommanderEditor;

    private static FLabel buildLabel(FSkin.SkinImage icon, boolean zebra) {
        FLabel lbl = new FLabel.Builder().text("0 (0%)").icon(icon).iconScaleAuto(false).fontSize(11).build();
        if (zebra) {
            lbl.setOpaque(true);
            lbl.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        }
        return lbl;
    }

    private static FLabel buildLabel(SItemManagerUtil.StatTypes statType, boolean zebra) {
        return VStatisticsImporter.buildLabel(FSkin.getImage(statType.skinProp, 18, 18), zebra);
    }

    public VStatisticsImporter(boolean isCommanderEditor) {
        this.scroller.getViewport().setBorder(null);
        this.lblMulti.setToolTipText(Localizer.getInstance().getMessage("lblMulticolorCardCount", new Object[0]));
        this.lblBlack.setToolTipText(Localizer.getInstance().getMessage("lblBlackCardCount", new Object[0]));
        this.lblBlue.setToolTipText(Localizer.getInstance().getMessage("lblBlueCardCount", new Object[0]));
        this.lblGreen.setToolTipText(Localizer.getInstance().getMessage("lblGreenCardCount", new Object[0]));
        this.lblRed.setToolTipText(Localizer.getInstance().getMessage("lblRedCardCount", new Object[0]));
        this.lblWhite.setToolTipText(Localizer.getInstance().getMessage("lblWhiteCardCount", new Object[0]));
        this.lblColorless.setToolTipText(Localizer.getInstance().getMessage("lblColorlessCardCount", new Object[0]));
        this.lblArtifact.setToolTipText(Localizer.getInstance().getMessage("lblArtifactCardCount", new Object[0]));
        this.lblCreature.setToolTipText(Localizer.getInstance().getMessage("lblCreatureCardCount", new Object[0]));
        this.lblEnchantment.setToolTipText(Localizer.getInstance().getMessage("lblEnchantmentCardCount", new Object[0]));
        this.lblInstant.setToolTipText(Localizer.getInstance().getMessage("lblInstantCardCount", new Object[0]));
        this.lblLand.setToolTipText(Localizer.getInstance().getMessage("lblLandCardCount", new Object[0]));
        this.lblPlaneswalker.setToolTipText(Localizer.getInstance().getMessage("lblPlaneswalkerCardCount", new Object[0]));
        this.lblSorcery.setToolTipText(Localizer.getInstance().getMessage("lblSorceryCardCount", new Object[0]));
        this.lblCMC0.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(0)));
        this.lblCMC1.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(1)));
        this.lblCMC2.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(2)));
        this.lblCMC3.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(3)));
        this.lblCMC4.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(4)));
        this.lblCMC5.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(5)));
        this.lblCMC6.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", "6+"));
        this.pnlStats.setOpaque(false);
        this.pnlStats.setLayout(new MigLayout("insets 0, gap 0, ax center, wrap 3"));
        this.pnlStats.add((Component)this.lblTitle, "w 96%!, h 20px!, span 3 1, gap 2% 0 0 0");
        String constraints = "w 35%!, h 30px!";
        this.pnlStats.add((Component)this.lblMulti, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblArtifact, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC0, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblBlack, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCreature, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC1, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblBlue, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblEnchantment, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC2, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblGreen, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblInstant, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC3, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblRed, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblLand, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC4, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblWhite, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblPlaneswalker, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC5, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblColorless, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblSorcery, "w 35%!, h 30px!");
        this.pnlStats.add((Component)this.lblCMC6, "w 35%!, h 30px!");
        if (isCommanderEditor) {
            this.pnlStats.add((Component)this.lblTotalMain, "w 35%!, h 30px!");
            this.pnlStats.add((Component)this.lblTotalSide, "w 35%!, h 30px!");
            this.pnlStats.add((Component)this.lblTotalCommander, "w 35%!, h 30px!");
        } else {
            this.pnlStats.add((Component)this.lblTotalMain, "w 35%!, h 30px!");
            this.pnlStats.add((Component)this.lblTotalSide, "w 35%!, h 30px!");
            this.pnlStats.add((Component)this.lblTotal, "w 35%!, h 30px!");
        }
        this.isViewForCommanderEditor = isCommanderEditor;
    }

    public boolean isViewForCommanderEditor() {
        return this.isViewForCommanderEditor;
    }

    public FLabel getLblMulti() {
        return this.lblMulti;
    }

    public FLabel getLblBlack() {
        return this.lblBlack;
    }

    public FLabel getLblBlue() {
        return this.lblBlue;
    }

    public FLabel getLblGreen() {
        return this.lblGreen;
    }

    public FLabel getLblRed() {
        return this.lblRed;
    }

    public FLabel getLblWhite() {
        return this.lblWhite;
    }

    public FLabel getLblColorless() {
        return this.lblColorless;
    }

    public FLabel getLblArtifact() {
        return this.lblArtifact;
    }

    public FLabel getLblEnchantment() {
        return this.lblEnchantment;
    }

    public FLabel getLblCreature() {
        return this.lblCreature;
    }

    public FLabel getLblSorcery() {
        return this.lblSorcery;
    }

    public FLabel getLblInstant() {
        return this.lblInstant;
    }

    public FLabel getLblPlaneswalker() {
        return this.lblPlaneswalker;
    }

    public FLabel getLblLand() {
        return this.lblLand;
    }

    public FLabel getLblCMC0() {
        return this.lblCMC0;
    }

    public FLabel getLblCMC1() {
        return this.lblCMC1;
    }

    public FLabel getLblCMC2() {
        return this.lblCMC2;
    }

    public FLabel getLblCMC3() {
        return this.lblCMC3;
    }

    public FLabel getLblCMC4() {
        return this.lblCMC4;
    }

    public FLabel getLblCMC5() {
        return this.lblCMC5;
    }

    public FLabel getLblCMC6() {
        return this.lblCMC6;
    }

    public FLabel getLblTotal() {
        return this.lblTotal;
    }

    public FLabel getLblTotalMain() {
        return this.lblTotalMain;
    }

    public FLabel getLblTotalSide() {
        return this.lblTotalSide;
    }

    public FLabel getLblTotalCommander() {
        return this.lblTotalCommander;
    }

    public JPanel getMainPanel() {
        return this.pnlStats;
    }
}

