/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.views;

import forge.gui.GuiBase;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.itemmanager.SItemManagerUtil;
import forge.screens.deckeditor.controllers.CStatistics;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VStatistics implements IVDoc<CStatistics>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblStatistics", new Object[0]));
    private FLabel lblTotal = new FLabel.Builder().text(String.format("%s: 0", Localizer.getInstance().getMessage("lblTotalCards", new Object[0]).toUpperCase())).tooltip(Localizer.getInstance().getMessage("lblTotalCards", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private FLabel lblTMC = new FLabel.Builder().text(String.format("%s: 0", Localizer.getInstance().getMessage("lblTotalManaCost", new Object[0]).toLowerCase())).tooltip(Localizer.getInstance().getMessage("lblTotalManaCost", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private FLabel lblAMC = new FLabel.Builder().text(String.format("%s: 0.00", Localizer.getInstance().getMessage("lblAverageManaCost", new Object[0]).toUpperCase())).tooltip(Localizer.getInstance().getMessage("lblAverageManaCost", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private FLabel lblCardCountHeader = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblCardByColorTypeCMC", new Object[0])).tooltip(Localizer.getInstance().getMessage("lblBreakdownOfColorTypeCMC", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private FLabel lblShardCountHeader = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblColoredManaSymbolsINManaCost", new Object[0])).tooltip(Localizer.getInstance().getMessage("lblAmountOfManaSymbolsInManaCostOfCards", new Object[0])).fontStyle(1).fontSize(11).fontStyle(1).build();
    private final JPanel pnlStats = new JPanel();
    private final FLabel lblMulti = VStatistics.buildLabel(SItemManagerUtil.StatTypes.MULTICOLOR, true);
    private final FLabel lblBlack = VStatistics.buildLabel(SItemManagerUtil.StatTypes.BLACK, false);
    private final FLabel lblBlue = VStatistics.buildLabel(SItemManagerUtil.StatTypes.BLUE, true);
    private final FLabel lblGreen = VStatistics.buildLabel(SItemManagerUtil.StatTypes.GREEN, false);
    private final FLabel lblRed = VStatistics.buildLabel(SItemManagerUtil.StatTypes.RED, true);
    private final FLabel lblWhite = VStatistics.buildLabel(SItemManagerUtil.StatTypes.WHITE, false);
    private final FLabel lblColorless = VStatistics.buildLabel(SItemManagerUtil.StatTypes.COLORLESS, true);
    private final FLabel lblWhiteShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.WHITE, true);
    private final FLabel lblBlueShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.BLUE, true);
    private final FLabel lblBlackShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.BLACK, true);
    private final FLabel lblRedShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.RED, false);
    private final FLabel lblGreenShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.GREEN, false);
    private final FLabel lblColorlessShard = VStatistics.buildLabel(SItemManagerUtil.StatTypes.COLORLESS, false);
    private final FLabel lblArtifact = VStatistics.buildLabel(SItemManagerUtil.StatTypes.ARTIFACT, true);
    private final FLabel lblCreature = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CREATURE, false);
    private final FLabel lblEnchantment = VStatistics.buildLabel(SItemManagerUtil.StatTypes.ENCHANTMENT, true);
    private final FLabel lblInstant = VStatistics.buildLabel(SItemManagerUtil.StatTypes.INSTANT, false);
    private final FLabel lblLand = VStatistics.buildLabel(SItemManagerUtil.StatTypes.LAND, true);
    private final FLabel lblPlaneswalker = VStatistics.buildLabel(SItemManagerUtil.StatTypes.PLANESWALKER, false);
    private final FLabel lblSorcery = VStatistics.buildLabel(SItemManagerUtil.StatTypes.SORCERY, true);
    private final FLabel lblCMC0 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_0, true);
    private final FLabel lblCMC1 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_1, false);
    private final FLabel lblCMC2 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_2, true);
    private final FLabel lblCMC3 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_3, false);
    private final FLabel lblCMC4 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_4, true);
    private final FLabel lblCMC5 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_5, false);
    private final FLabel lblCMC6 = VStatistics.buildLabel(SItemManagerUtil.StatTypes.CMC_6, true);
    private final FScrollPane scroller = new FScrollPane(this.pnlStats, false);

    private VStatistics() {
        this.scroller.getViewport().setBorder(null);
        this.lblMulti.setToolTipText(Localizer.getInstance().getMessage("lblMulticolorCardCount", new Object[0]));
        this.lblBlack.setToolTipText(Localizer.getInstance().getMessage("lblBlackCardCount", new Object[0]));
        this.lblBlue.setToolTipText(Localizer.getInstance().getMessage("lblBlueCardCount", new Object[0]));
        this.lblGreen.setToolTipText(Localizer.getInstance().getMessage("lblGreenCardCount", new Object[0]));
        this.lblRed.setToolTipText(Localizer.getInstance().getMessage("lblRedCardCount", new Object[0]));
        this.lblWhite.setToolTipText(Localizer.getInstance().getMessage("lblWhiteCardCount", new Object[0]));
        this.lblColorless.setToolTipText(Localizer.getInstance().getMessage("lblColorlessCardCount", new Object[0]));
        this.lblBlackShard.setToolTipText(Localizer.getInstance().getMessage("lblBlackManaSymbolCount", new Object[0]));
        this.lblBlueShard.setToolTipText(Localizer.getInstance().getMessage("lblBlueManaSymbolCount", new Object[0]));
        this.lblGreenShard.setToolTipText(Localizer.getInstance().getMessage("lblGreenManaSymbolCount", new Object[0]));
        this.lblRedShard.setToolTipText(Localizer.getInstance().getMessage("lblRedManaSymbolCount", new Object[0]));
        this.lblWhiteShard.setToolTipText(Localizer.getInstance().getMessage("lblWhiteManaSymbolCount", new Object[0]));
        this.lblArtifact.setToolTipText(Localizer.getInstance().getMessage("lblArtifactCardCount", new Object[0]));
        this.lblCreature.setToolTipText(Localizer.getInstance().getMessage("lblCreatureCardCount", new Object[0]));
        this.lblEnchantment.setToolTipText(Localizer.getInstance().getMessage("lblEnchantmentCardCount", new Object[0]));
        this.lblInstant.setToolTipText(Localizer.getInstance().getMessage("lblInstantCardCount", new Object[0]));
        this.lblLand.setToolTipText(Localizer.getInstance().getMessage("lblLandCardCount", new Object[0]));
        this.lblPlaneswalker.setToolTipText(Localizer.getInstance().getMessage("lblPlaneswalkerCardCount", new Object[0]));
        this.lblSorcery.setToolTipText(Localizer.getInstance().getMessage("lblSorceryCardCount", new Object[0]));
        this.lblCMC0.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(0)));
        this.lblCMC1.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(1)));
        this.lblCMC2.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(2)));
        this.lblCMC3.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(3)));
        this.lblCMC4.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(4)));
        this.lblCMC5.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", String.valueOf(5)));
        this.lblCMC6.setToolTipText(Localizer.getInstance().getMessage("lblCMCNCardCount", "6+"));
        this.pnlStats.setOpaque(false);
        this.pnlStats.setLayout(new MigLayout("insets 0, gap 0, ax center, wrap 3"));
        this.pnlStats.add((Component)this.lblTotal, "w 96%!, h 20px!, span 3 1, gap 2% 0 0 0");
        this.pnlStats.add((Component)this.lblTMC, "w 96%!, h 20px!, span 3 1, gap 2% 0 0 0");
        this.pnlStats.add((Component)this.lblAMC, "w 96%!, h 20px!, span 3 1, gap 2% 0 0 0");
        String constraints = "w 32%!, h 35px!";
        this.pnlStats.add((Component)this.lblCardCountHeader, "w 96%!, h 40px!, span 3 1, gap 2% 0 0 0");
        this.pnlStats.add((Component)this.lblMulti, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblArtifact, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC0, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblBlack, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCreature, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC1, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblBlue, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblEnchantment, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC2, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblGreen, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblInstant, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC3, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblRed, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblLand, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC4, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblWhite, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblPlaneswalker, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC5, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblColorless, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblSorcery, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblCMC6, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblShardCountHeader, "w 96%!, h 40px!, span 3 1, gap 2% 0 0 0");
        this.pnlStats.add((Component)this.lblWhiteShard, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblBlueShard, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblBlackShard, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblRedShard, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblGreenShard, "w 32%!, h 35px!");
        this.pnlStats.add((Component)this.lblColorlessShard, "w 32%!, h 35px!");
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.EDITOR_STATISTICS;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CStatistics getLayoutControl() {
        return CStatistics.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void populate() {
        this.parentCell.getBody().setLayout(new MigLayout("insets 0, gap 0"));
        this.parentCell.getBody().add((Component)this.scroller, "w 96%!, h 96%!, gap 2% 0 2% 0");
    }

    public FLabel getLblMulti() {
        return this.lblMulti;
    }

    public FLabel getLblBlack() {
        return this.lblBlack;
    }

    public FLabel getLblBlue() {
        return this.lblBlue;
    }

    public FLabel getLblGreen() {
        return this.lblGreen;
    }

    public FLabel getLblRed() {
        return this.lblRed;
    }

    public FLabel getLblWhite() {
        return this.lblWhite;
    }

    public FLabel getLblColorless() {
        return this.lblColorless;
    }

    public FLabel getLblBlackShard() {
        return this.lblBlackShard;
    }

    public FLabel getLblBlueShard() {
        return this.lblBlueShard;
    }

    public FLabel getLblGreenShard() {
        return this.lblGreenShard;
    }

    public FLabel getLblRedShard() {
        return this.lblRedShard;
    }

    public FLabel getLblWhiteShard() {
        return this.lblWhiteShard;
    }

    public FLabel getLblColorlessShard() {
        return this.lblColorlessShard;
    }

    public FLabel getLblArtifact() {
        return this.lblArtifact;
    }

    public FLabel getLblEnchantment() {
        return this.lblEnchantment;
    }

    public FLabel getLblCreature() {
        return this.lblCreature;
    }

    public FLabel getLblSorcery() {
        return this.lblSorcery;
    }

    public FLabel getLblInstant() {
        return this.lblInstant;
    }

    public FLabel getLblPlaneswalker() {
        return this.lblPlaneswalker;
    }

    public FLabel getLblLand() {
        return this.lblLand;
    }

    public FLabel getLblCMC0() {
        return this.lblCMC0;
    }

    public FLabel getLblCMC1() {
        return this.lblCMC1;
    }

    public FLabel getLblCMC2() {
        return this.lblCMC2;
    }

    public FLabel getLblCMC3() {
        return this.lblCMC3;
    }

    public FLabel getLblCMC4() {
        return this.lblCMC4;
    }

    public FLabel getLblCMC5() {
        return this.lblCMC5;
    }

    public FLabel getLblCMC6() {
        return this.lblCMC6;
    }

    public FLabel getLblTotal() {
        return this.lblTotal;
    }

    public FLabel getLblTMC() {
        return this.lblTMC;
    }

    public FLabel getLblAMC() {
        return this.lblAMC;
    }

    private static FLabel buildLabel(FSkin.SkinImage icon, boolean zebra) {
        FLabel lbl = new FLabel.Builder().text("0 (0%)").icon(icon).iconScaleAuto(false).fontSize(11).build();
        if (zebra) {
            lbl.setOpaque(true);
            lbl.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        }
        return lbl;
    }

    private static FLabel buildLabel(SItemManagerUtil.StatTypes statType, boolean zebra) {
        int imageSize = Math.round(18.0f * GuiBase.getInterface().getScreenScale());
        return VStatistics.buildLabel(FSkin.getImage(statType.skinProp, imageSize, imageSize), zebra);
    }
}

