/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.views;

import forge.deck.DeckBase;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CProbabilities;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VProbabilities implements IVDoc<CProbabilities>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblDrawOrder", new Object[0]));
    private final FLabel lblReshuffle = new FLabel.Builder().hoverable(true).text(Localizer.getInstance().getMessage("lblClickHereToReshuffle", new Object[0])).tooltip(Localizer.getInstance().getMessage("lblSeeANewSampleShuffle", new Object[0])).fontSize(16).build();
    private final FLabel lblSampleHand = new FLabel.Builder().fontStyle(1).fontSize(12).text(Localizer.getInstance().getMessage("lblSampleHand", new Object[0])).opaque(true).build();
    private final FLabel lblRemainingDraws = new FLabel.Builder().fontStyle(1).fontSize(12).text(Localizer.getInstance().getMessage("lblRemainingDraws", new Object[0])).opaque(true).build();
    private final JPanel pnlContent = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
    private final FScrollPane scroller = new FScrollPane(this.pnlContent, false);
    private final JPanel pnlHand = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
    private final JPanel pnlLibrary = new JPanel(new MigLayout("insets 0, gap 0, wrap"));

    private VProbabilities() {
        this.pnlContent.setOpaque(false);
        this.pnlHand.setOpaque(false);
        this.pnlLibrary.setOpaque(false);
        this.scroller.getViewport().setBorder(null);
        this.lblSampleHand.setBorder(new FSkin.MatteSkinBorder(1, 0, 1, 0, FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        this.lblSampleHand.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.lblRemainingDraws.setBorder(new FSkin.MatteSkinBorder(1, 0, 1, 0, FSkin.getColor(FSkin.Colors.CLR_BORDERS)));
        this.lblRemainingDraws.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.pnlContent.add((Component)this.lblReshuffle, "w 96%!, h 29px!, gap 2% 0 5px 5px");
        this.pnlContent.add((Component)this.lblSampleHand, "w 96%!, h 25px!, gap 2% 0 0 0");
        this.pnlContent.add((Component)this.pnlHand, "w 96%!, gap 2% 0 0 5px");
        this.pnlContent.add((Component)this.lblRemainingDraws, "w 96%!, h 25px!, gap 2% 0 0 0");
        this.pnlContent.add((Component)this.pnlLibrary, "w 96%!, gap 2% 0 5px 0");
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.EDITOR_PROBABILITIES;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CProbabilities getLayoutControl() {
        return CProbabilities.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void populate() {
        this.parentCell.getBody().setLayout(new MigLayout("insets 0, gap 0"));
        this.parentCell.getBody().add((Component)this.scroller, "w 96%!, h 96%!, gap 2% 0 2% 0");
    }

    public FLabel getLblReshuffle() {
        return this.lblReshuffle;
    }

    public void rebuildLabels(List<String> shuffledVals) {
        this.pnlHand.removeAll();
        this.pnlLibrary.removeAll();
        String constraints = "w 96%, h 25px!, gap 2% 0 0 0";
        for (int i = 0; i < shuffledVals.size(); ++i) {
            JLabel lbl = i % 2 == 1 ? VProbabilities.buildLabel(true) : VProbabilities.buildLabel(false);
            lbl.setText(shuffledVals.get(i));
            if (i < 7) {
                this.pnlHand.add((Component)lbl, "w 96%, h 25px!, gap 2% 0 0 0");
                continue;
            }
            this.pnlLibrary.add((Component)lbl, "w 96%, h 25px!, gap 2% 0 0 0");
        }
        this.pnlHand.validate();
        this.pnlLibrary.validate();
    }

    private static <T extends InventoryItem, TModel extends DeckBase> JLabel buildLabel(boolean zebra) {
        final FLabel lbl = new FLabel.Builder().text("--").fontAlign(0).fontSize(13).build();
        lbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ACEditorBase<? extends InventoryItem, ? extends DeckBase> ed = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
                List<? extends InventoryItem> cards = ed.getDeckManager().getPool().toFlatList();
                String name1 = lbl.getText();
                for (PaperCard paperCard : cards) {
                    String name2 = paperCard.getName();
                    if (name2.length() > name1.length() || !name2.equals(name1.substring(0, name2.length()))) continue;
                    CDeckEditorUI.SINGLETON_INSTANCE.setCard(paperCard);
                    break;
                }
            }
        });
        if (zebra) {
            lbl.setOpaque(true);
            lbl.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        }
        return lbl;
    }
}

