/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.views;

import com.google.common.collect.Lists;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.IVDoc;
import forge.screens.deckeditor.controllers.CEditorLog;
import forge.screens.match.GameLogPanel;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VEditorLog implements IVDoc<CEditorLog>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    final Localizer localizer = Localizer.getInstance();
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblEditorLog", new Object[0]));
    private final GameLogPanel gameLog;
    private final JPanel pnlContent = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
    private final FScrollPane scroller = new FScrollPane(this.pnlContent, false);
    private final List<String> editorLogEntries = Lists.newArrayList();

    private VEditorLog() {
        this.pnlContent.setOpaque(false);
        this.scroller.getViewport().setBorder(null);
        this.gameLog = new GameLogPanel();
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.EDITOR_LOG;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    public void showView() {
        this.tab.setVisible(true);
        this.tab.setOpaque(true);
        this.pnlContent.setOpaque(true);
        this.pnlContent.setVisible(true);
    }

    @Override
    public CEditorLog getLayoutControl() {
        return CEditorLog.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void populate() {
        JPanel parentBody = this.parentCell.getBody();
        parentBody.setLayout(new MigLayout("insets 5, gap 0, wrap, hidemode 3"));
        parentBody.add((Component)this.gameLog, "w 10:100%, h 100%");
    }

    public void resetNewDraft() {
        this.gameLog.reset();
        this.editorLogEntries.clear();
    }

    public void updateConsole() {
        this.gameLog.updateUI();
    }

    public void addLogEntry(String entry) {
        this.gameLog.addLogEntry(entry);
        this.editorLogEntries.add(entry);
    }
}

