/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.deck.Deck;
import forge.item.PaperCard;
import forge.util.ImageUtil;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DeckHtmlSerializer {
    public static void writeDeckHtml(Deck d, File f) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            DeckHtmlSerializer.writeDeckHtml(d, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeDeckHtml(Deck d, BufferedWriter out) {
        boolean cardBorder = false;
        int height = 319;
        int width = 222;
        Configuration cfg = new Configuration();
        try {
            cfg.setClassForTemplateLoading(DeckHtmlSerializer.class, "/");
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            Template temp = cfg.getTemplate("proxy-template.ftl");
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("title", d.getName());
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry card : d.getMain()) {
                for (int i = card.getValue().intValue(); i > 0; --i) {
                    PaperCard r = (PaperCard)card.getKey();
                    String url = "https://downloads.cardforge.org/images/cards/" + ImageUtil.getDownloadUrl(r, "");
                    list.add(url);
                    if (!r.hasBackFace()) continue;
                    String backUrl = "https://downloads.cardforge.org/images/cards/" + ImageUtil.getDownloadUrl(r, "back");
                    list.add(backUrl);
                }
            }
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            for (Map.Entry entry : d.getMain()) {
                map.put(((PaperCard)entry.getKey()).getName(), entry.getValue());
            }
            root.put("urls", list);
            root.put("cardBorder", 0);
            root.put("height", 319);
            root.put("width", 222);
            root.put("cardlistWidth", 211);
            root.put("cardList", map);
            temp.process(root, out);
            out.flush();
        }
        catch (TemplateException | IOException e) {
            System.out.println(e.toString());
        }
    }
}

