/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Supplier;
import forge.StaticData;
import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.item.PaperCard;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CProbabilities;
import forge.screens.deckeditor.controllers.CStatistics;
import forge.screens.deckeditor.menus.DeckFileMenu;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.home.gauntlet.VSubmenuGauntletBuild;
import forge.screens.home.gauntlet.VSubmenuGauntletCommander;
import forge.screens.home.gauntlet.VSubmenuGauntletContests;
import forge.screens.home.gauntlet.VSubmenuGauntletQuick;
import forge.screens.home.sanctioned.VSubmenuConstructed;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.util.storage.IStorage;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DeckController<T extends DeckBase> {
    private T model;
    private boolean saved;
    private boolean modelInStorage;
    private final IStorage<T> rootFolder;
    private IStorage<T> currentFolder;
    private String modelPath;
    private final CDeckEditor<T> view;
    private final Supplier<T> newModelCreator;
    private Boolean isInSyncCacheResult = null;
    private T syncModelCache = null;

    public DeckController(IStorage<T> folder0, CDeckEditor<T> view0, Supplier<T> newModelCreator0) {
        this.rootFolder = folder0;
        this.currentFolder = this.rootFolder;
        this.view = view0;
        this.model = null;
        this.saved = true;
        this.modelInStorage = false;
        this.modelPath = "";
        this.newModelCreator = newModelCreator0;
    }

    public T getModel() {
        return this.model;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public boolean isEmpty() {
        return this.model == null || ((DeckBase)this.model).isEmpty();
    }

    public void loadDeck(Deck deck) {
        this.loadDeck(deck, true);
    }

    public void loadDeck(Deck deck, boolean substituteCurrentDeck) {
        boolean isStored;
        Deck currentDeck;
        if (deck == null) {
            return;
        }
        boolean isInfinite = this.view.getCatalogManager().isInfinite();
        if (isInfinite) {
            currentDeck = this.view.getHumanDeck();
            if (substituteCurrentDeck || currentDeck.isEmpty()) {
                this.newModel();
                isStored = false;
            } else {
                isStored = !this.modelPath.isEmpty();
            }
        } else {
            CardPool catalogClone = new CardPool(this.view.getInitialCatalog());
            deck = this.pickFromCatalog(deck, catalogClone);
            ItemPool catalogPool = this.view.getCatalogManager().getPool();
            catalogPool.clear();
            catalogPool.addAll(catalogClone);
            isStored = false;
        }
        currentDeck = this.view.getHumanDeck();
        for (DeckSection section : EnumSet.allOf(DeckSection.class)) {
            if (!this.view.isSectionImportable(section).booleanValue()) continue;
            CardPool sectionCards = currentDeck.getOrCreate(section);
            if (!isInfinite) {
                sectionCards.clear();
            }
            sectionCards.addAll(deck.getOrCreate(section));
        }
        if (deck.hasName()) {
            currentDeck.setName(deck.getName());
        }
        this.setModel(currentDeck, isStored);
    }

    public Deck getCurrentDeckInEditor() {
        try {
            return ((DeckBase)this.getModel()).getHumanDeck();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private Deck pickFromCatalog(Deck deck, CardPool catalog) {
        CardEdition referenceEdition = StaticData.instance().getEditions().getTheLatestOfAllTheOriginalEditionsOfCardsIn(catalog);
        Date referenceReleaseDate = referenceEdition.getDate();
        Deck result = new Deck();
        for (DeckSection section : EnumSet.allOf(DeckSection.class)) {
            if (!this.view.isSectionImportable(section).booleanValue()) continue;
            CardPool cards = this.pickSectionFromCatalog(catalog, deck.getOrCreate(section), referenceReleaseDate);
            result.putSection(section, cards);
        }
        return result;
    }

    private CardPool pickSectionFromCatalog(CardPool catalog, CardPool sourceSection, Date referenceReleaseDate) {
        Map<String, Integer> countByName = this.groupByName(sourceSection);
        HashMap<String, PaperCard> basicLandsByName = this.getBasicLandsByName(sourceSection);
        CardPool targetSection = new CardPool();
        this.pickFromCatalog(countByName, catalog, targetSection);
        this.importBasicLands(countByName, basicLandsByName, referenceReleaseDate, targetSection);
        return targetSection;
    }

    private Map<String, Integer> groupByName(CardPool section) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : section) {
            PaperCard importedCard = (PaperCard)entry.getKey();
            Integer previousCount = result.getOrDefault(importedCard.getName(), 0);
            int countToAdd = entry.getValue();
            result.put(importedCard.getName(), countToAdd + previousCount);
        }
        return result;
    }

    private void pickFromCatalog(Map<String, Integer> countByName, CardPool catalog, CardPool targetSection) {
        CardPool catalogClone = new CardPool(catalog);
        for (Map.Entry entry : catalogClone) {
            PaperCard availableCard = (PaperCard)entry.getKey();
            if (availableCard.getRules().getType().isBasicLand()) continue;
            Integer availableCount = entry.getValue();
            int toAddByName = countByName.getOrDefault(availableCard.getName(), 0);
            int toAdd = Math.min(availableCount, toAddByName);
            if (toAdd <= 0) continue;
            targetSection.add(availableCard, toAdd);
            countByName.put(availableCard.getName(), toAddByName - toAdd);
            catalog.remove(availableCard, toAdd);
        }
    }

    private void importBasicLands(Map<String, Integer> countByName, Map<String, PaperCard> basicLandsByName, Date referenceReleaseDate, CardPool targetSection) {
        for (String cardName : countByName.keySet()) {
            PaperCard card = basicLandsByName.getOrDefault(cardName, null);
            if (card == null) continue;
            int countToAdd = countByName.get(cardName);
            card = StaticData.instance().getAlternativeCardPrint(card, referenceReleaseDate);
            if (card == null) continue;
            targetSection.add(card.getName(), card.getEdition(), countToAdd);
        }
    }

    private HashMap<String, PaperCard> getBasicLandsByName(CardPool sourceSection) {
        HashMap<String, PaperCard> result = new HashMap<String, PaperCard>();
        for (Map.Entry entry : sourceSection) {
            PaperCard card = (PaperCard)entry.getKey();
            if (!card.getRules().getType().isBasicLand() || result.containsKey(card.getName())) continue;
            result.put(card.getName(), card);
        }
        return result;
    }

    public void setModel(T document) {
        this.setModel(document, false);
    }

    private void setModel(T document, boolean isStored) {
        this.model = document;
        this.onModelChanged(isStored);
    }

    private void onModelChanged(boolean isStored) {
        this.modelInStorage = isStored;
        this.view.resetTables();
        CStatistics.SINGLETON_INSTANCE.update();
        CProbabilities.SINGLETON_INSTANCE.update();
        if (isStored) {
            if (this.isModelInSyncWithFolder()) {
                this.setSaved(true);
            } else {
                this.notifyModelChanged();
            }
        } else {
            this.currentFolder = this.rootFolder;
            this.modelPath = "";
            this.setSaved(((DeckBase)this.model).isEmpty());
        }
    }

    private boolean isModelInSyncWithFolder() {
        if (this.syncModelCache != null && this.model == this.syncModelCache) {
            return this.isInSyncCacheResult;
        }
        if (((DeckBase)this.model).getName().isEmpty()) {
            return true;
        }
        DeckBase modelStored = (DeckBase)this.currentFolder.get(((DeckBase)this.model).getName());
        if (modelStored == this.model) {
            return true;
        }
        if (modelStored == null) {
            return false;
        }
        this.syncModelCache = this.model;
        this.isInSyncCacheResult = modelStored.equals(this.model);
        return this.isInSyncCacheResult;
    }

    public ACEditorBase<?, T> getView() {
        return this.view;
    }

    public void notifyModelChanged() {
        if (this.saved) {
            this.setSaved(false);
        }
    }

    private void setSaved(boolean val) {
        this.saved = val;
        this.updateCaptions();
    }

    public void reload() {
        String name = this.getModelName();
        if (name.isEmpty()) {
            this.newModel();
        } else {
            this.load(name);
        }
    }

    public void load(String path, String name) {
        this.currentFolder = StringUtils.isBlank(path) ? this.rootFolder : this.rootFolder.tryGetFolder(path);
        this.modelPath = path;
        this.load(name);
    }

    private void load(String name) {
        DeckBase newModel = (DeckBase)this.currentFolder.get(name);
        if (newModel != null) {
            this.setModel(newModel.copyTo(name), true);
        } else {
            this.setSaved(true);
        }
    }

    public void save() {
        if (this.model == null) {
            return;
        }
        this.currentFolder.add(((DeckBase)this.model).copyTo(((DeckBase)this.model).getName()));
        ((DeckBase)this.model).setDirectory(DeckProxy.getDeckDirectory(this.currentFolder));
        this.modelInStorage = true;
        this.setSaved(true);
        VSubmenuConstructed.SINGLETON_INSTANCE.getLobby().updateDeckPanel();
        VSubmenuGauntletBuild.SINGLETON_INSTANCE.updateDeckPanel();
        VSubmenuGauntletQuick.SINGLETON_INSTANCE.updateDeckPanel();
        VSubmenuGauntletContests.SINGLETON_INSTANCE.updateDeckPanel();
        VSubmenuGauntletCommander.SINGLETON_INSTANCE.updateDeckPanel();
    }

    public void saveAs(String name0) {
        this.model = ((DeckBase)this.model).copyTo(name0);
        this.modelInStorage = false;
        this.save();
        this.view.resetTables();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean fileExists(String deckName) {
        return this.currentFolder.contains(deckName);
    }

    public void refreshModel() {
        if (this.model == null) {
            this.newModel();
        } else {
            this.setModel(this.model, this.modelInStorage);
        }
    }

    public void newModel() {
        this.model = (DeckBase)this.newModelCreator.get();
        this.setSaved(true);
        this.view.resetTables();
    }

    public String getModelName() {
        return this.model != null ? ((DeckBase)this.model).getName() : "";
    }

    public void updateCaptions() {
        String itemManagerCaption;
        Localizer localizer = Localizer.getInstance();
        String tabCaption = localizer.getMessage("lblCurrentDeck2", new Object[0]);
        String title = this.getModelName();
        String string = itemManagerCaption = title.isEmpty() ? "[" + localizer.getMessage("lblUntitled", new Object[0]) + "]" : title;
        if (!this.saved) {
            tabCaption = "*" + tabCaption;
            itemManagerCaption = "*" + itemManagerCaption;
        }
        itemManagerCaption = itemManagerCaption + " - ";
        VCurrentDeck.SINGLETON_INSTANCE.getTabLabel().setText(tabCaption);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().setText(title);
        VCurrentDeck.SINGLETON_INSTANCE.getItemManager().setCaption(itemManagerCaption);
        DeckFileMenu.updateSaveEnabled();
    }
}

