/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.deck.CardPool;
import forge.deck.DeckRecognizer;
import forge.deck.DeckSection;
import forge.item.PaperCard;
import forge.itemmanager.SItemManagerUtil;
import forge.screens.deckeditor.views.VStatisticsImporter;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.AbstractMap;
import java.util.ArrayList;
import javax.swing.JLabel;

public class CStatisticsImporter {
    private int totalCardsInDecklist = 0;
    private final boolean isCommanderEditor;
    private final VStatisticsImporter view;

    public CStatisticsImporter(VStatisticsImporter vStatisticsImporter) {
        this.view = vStatisticsImporter;
        this.isCommanderEditor = this.view.isViewForCommanderEditor();
    }

    public void updateStats(Iterable<DeckRecognizer.Token> cardTokens, boolean includeBannedAndRestricted) {
        int total;
        ArrayList tokenCards = new ArrayList();
        int totalInMain = 0;
        int totalInSide = 0;
        int totalInCommander = 0;
        for (DeckRecognizer.Token token : cardTokens) {
            if (token.getType() != DeckRecognizer.TokenType.LEGAL_CARD && (!includeBannedAndRestricted || token.getType() != DeckRecognizer.TokenType.LIMITED_CARD)) continue;
            tokenCards.add(new AbstractMap.SimpleEntry<PaperCard, Integer>(token.getCard(), token.getQuantity()));
            if (token.getTokenSection() == DeckSection.Main) {
                totalInMain += token.getQuantity();
                continue;
            }
            if (token.getTokenSection() == DeckSection.Sideboard) {
                totalInSide += token.getQuantity();
                continue;
            }
            if (token.getTokenSection() != DeckSection.Commander) continue;
            totalInCommander += token.getQuantity();
        }
        CardPool deck = new CardPool();
        deck.addAll(tokenCards);
        this.totalCardsInDecklist = total = deck.countAll();
        if (total == 0) {
            total = 1;
        }
        this.setLabelValue(this.view.getLblCreature(), deck, CardRulesPredicates.Presets.IS_CREATURE, total);
        this.setLabelValue(this.view.getLblLand(), deck, CardRulesPredicates.Presets.IS_LAND, total);
        this.setLabelValue(this.view.getLblEnchantment(), deck, CardRulesPredicates.Presets.IS_ENCHANTMENT, total);
        this.setLabelValue(this.view.getLblArtifact(), deck, CardRulesPredicates.Presets.IS_ARTIFACT, total);
        this.setLabelValue(this.view.getLblInstant(), deck, CardRulesPredicates.Presets.IS_INSTANT, total);
        this.setLabelValue(this.view.getLblSorcery(), deck, CardRulesPredicates.Presets.IS_SORCERY, total);
        this.setLabelValue(this.view.getLblPlaneswalker(), deck, CardRulesPredicates.Presets.IS_PLANESWALKER, total);
        this.setLabelValue(this.view.getLblMulti(), deck, CardRulesPredicates.Presets.IS_MULTICOLOR, total);
        this.setLabelValue(this.view.getLblColorless(), deck, CardRulesPredicates.Presets.IS_COLORLESS, total);
        this.setLabelValue(this.view.getLblBlack(), deck, CardRulesPredicates.isMonoColor((byte)4), total);
        this.setLabelValue(this.view.getLblBlue(), deck, CardRulesPredicates.isMonoColor((byte)2), total);
        this.setLabelValue(this.view.getLblGreen(), deck, CardRulesPredicates.isMonoColor((byte)16), total);
        this.setLabelValue(this.view.getLblRed(), deck, CardRulesPredicates.isMonoColor((byte)8), total);
        this.setLabelValue(this.view.getLblWhite(), deck, CardRulesPredicates.isMonoColor((byte)1), total);
        this.setLabelValue(this.view.getLblCMC0(), deck, SItemManagerUtil.StatTypes.CMC_0.predicate, total);
        this.setLabelValue(this.view.getLblCMC1(), deck, SItemManagerUtil.StatTypes.CMC_1.predicate, total);
        this.setLabelValue(this.view.getLblCMC2(), deck, SItemManagerUtil.StatTypes.CMC_2.predicate, total);
        this.setLabelValue(this.view.getLblCMC3(), deck, SItemManagerUtil.StatTypes.CMC_3.predicate, total);
        this.setLabelValue(this.view.getLblCMC4(), deck, SItemManagerUtil.StatTypes.CMC_4.predicate, total);
        this.setLabelValue(this.view.getLblCMC5(), deck, SItemManagerUtil.StatTypes.CMC_5.predicate, total);
        this.setLabelValue(this.view.getLblCMC6(), deck, SItemManagerUtil.StatTypes.CMC_6.predicate, total);
        this.view.getLblTotalMain().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalMain", new Object[0]).toUpperCase(), totalInMain));
        this.view.getLblTotalSide().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalSide", new Object[0]).toUpperCase(), totalInSide));
        if (this.isCommanderEditor) {
            this.view.getLblTotalCommander().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalCommander", new Object[0]).toUpperCase(), totalInCommander));
        } else {
            this.view.getLblTotal().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalCards", new Object[0]).toUpperCase(), deck.countAll()));
        }
    }

    private void setLabelValue(JLabel label, ItemPool<PaperCard> deck, Predicate<CardRules> predicate, int total) {
        int tmp = deck.countAll(Predicates.compose(predicate, PaperCard::getRules));
        label.setText(tmp + " (" + CStatisticsImporter.calculatePercentage(tmp, total) + "%)");
    }

    public static int calculatePercentage(int x0, int y0) {
        return (int)Math.round((double)(x0 * 100) / (double)y0);
    }

    public int getTotalCardsInDecklist() {
        return this.totalCardsInDecklist;
    }
}

