/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.deck.DeckBase;
import forge.gui.framework.ICDoc;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.SItemManagerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.views.VStatistics;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.Map;
import javax.swing.JLabel;

public enum CStatistics implements ICDoc
{
    SINGLETON_INSTANCE;


    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        this.analyze();
    }

    private void setLabelValue(JLabel label, ItemPool<PaperCard> deck, Predicate<CardRules> predicate, int total) {
        int tmp = deck.countAll(Predicates.compose(predicate, PaperCard::getRules));
        label.setText(tmp + " (" + CStatistics.calculatePercentage(tmp, total) + "%)");
    }

    private void setLabelValue(JLabel label, String str, int value, int total) {
        String labelText = String.format("%s%d (%d%%)", str, value, CStatistics.calculatePercentage(value, total));
        label.setText(labelText);
    }

    private <T extends InventoryItem, TModel extends DeckBase> void analyze() {
        ACEditorBase<? extends InventoryItem, ? extends DeckBase> ed = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
        if (ed == null) {
            return;
        }
        ItemPool<PaperCard> deck = ItemPool.createFrom(ed.getDeckManager().getPool(), PaperCard.class);
        int total = deck.countAll();
        int[] shardCount = CStatistics.calculateShards(deck);
        if (total == 0) {
            total = 1;
        }
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCreature(), deck, CardRulesPredicates.Presets.IS_CREATURE, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblLand(), deck, CardRulesPredicates.Presets.IS_LAND, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblEnchantment(), deck, CardRulesPredicates.Presets.IS_ENCHANTMENT, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblArtifact(), deck, CardRulesPredicates.Presets.IS_ARTIFACT, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblInstant(), deck, CardRulesPredicates.Presets.IS_INSTANT, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblSorcery(), deck, CardRulesPredicates.Presets.IS_SORCERY, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblPlaneswalker(), deck, CardRulesPredicates.Presets.IS_PLANESWALKER, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblMulti(), deck, CardRulesPredicates.Presets.IS_MULTICOLOR, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblColorless(), deck, CardRulesPredicates.Presets.IS_COLORLESS, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblBlack(), deck, CardRulesPredicates.isMonoColor((byte)4), total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblBlue(), deck, CardRulesPredicates.isMonoColor((byte)2), total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblGreen(), deck, CardRulesPredicates.isMonoColor((byte)16), total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblRed(), deck, CardRulesPredicates.isMonoColor((byte)8), total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblWhite(), deck, CardRulesPredicates.isMonoColor((byte)1), total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC0(), deck, SItemManagerUtil.StatTypes.CMC_0.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC1(), deck, SItemManagerUtil.StatTypes.CMC_1.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC2(), deck, SItemManagerUtil.StatTypes.CMC_2.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC3(), deck, SItemManagerUtil.StatTypes.CMC_3.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC4(), deck, SItemManagerUtil.StatTypes.CMC_4.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC5(), deck, SItemManagerUtil.StatTypes.CMC_5.predicate, total);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblCMC6(), deck, SItemManagerUtil.StatTypes.CMC_6.predicate, total);
        int totShards = CStatistics.calculateTotalShards(shardCount);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblWhiteShard(), "Shards:", shardCount[0], totShards);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblBlueShard(), "Shards:", shardCount[1], totShards);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblBlackShard(), "Shards:", shardCount[2], totShards);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblRedShard(), "Shards:", shardCount[3], totShards);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblGreenShard(), "Shards:", shardCount[4], totShards);
        this.setLabelValue((JLabel)VStatistics.SINGLETON_INSTANCE.getLblColorlessShard(), "Shards:", shardCount[5], totShards);
        int tmc = 0;
        for (Map.Entry<PaperCard, Integer> entry : deck) {
            tmc += entry.getKey().getRules().getManaCost().getCMC() * entry.getValue();
        }
        double amc = (double)Math.round((double)tmc / (double)total * 100.0) / 100.0;
        VStatistics.SINGLETON_INSTANCE.getLblTotal().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalCards", new Object[0]).toUpperCase(), deck.countAll()));
        VStatistics.SINGLETON_INSTANCE.getLblTMC().setText(String.format("%s: %d", Localizer.getInstance().getMessage("lblTotalManaCost", new Object[0]).toUpperCase(), tmc));
        VStatistics.SINGLETON_INSTANCE.getLblAMC().setText(String.format("%s: %.2f", Localizer.getInstance().getMessage("lblAverageManaCost", new Object[0]).toUpperCase(), amc));
    }

    public static int calculatePercentage(int x0, int y0) {
        return (int)Math.round((double)(x0 * 100) / (double)y0);
    }

    public static int[] calculateShards(ItemPool<PaperCard> deck) {
        int[] counts = new int[6];
        for (PaperCard c : deck.toFlatList()) {
            int[] cShards = c.getRules().getManaCost().getColorShardCounts();
            for (int i = 0; i < 6; ++i) {
                int n = i;
                counts[n] = counts[n] + cShards[i];
            }
        }
        return counts;
    }

    public static int calculateTotalShards(int[] counts) {
        int total = 0;
        for (int count : counts) {
            total += count;
        }
        return total;
    }
}

