/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.deck.DeckBase;
import forge.gui.framework.ICDoc;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.views.VProbabilities;
import forge.util.ItemPool;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public enum CProbabilities implements ICDoc
{
    SINGLETON_INSTANCE;


    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VProbabilities.SINGLETON_INSTANCE.getLblReshuffle().setCommand(this::update);
    }

    @Override
    public void update() {
        VProbabilities.SINGLETON_INSTANCE.rebuildLabels(this.analyze());
    }

    private <T extends InventoryItem, TModel extends DeckBase> List<String> analyze() {
        ACEditorBase<? extends InventoryItem, ? extends DeckBase> ed = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
        if (ed == null) {
            return new ArrayList<String>();
        }
        ItemPool<PaperCard> deck = ItemPool.createFrom(ed.getDeckManager().getPool(), PaperCard.class);
        ArrayList<String> cardProbabilities = new ArrayList<String>();
        List<PaperCard> shuffled = deck.toFlatList();
        Collections.shuffle(shuffled, MyRandom.getRandom());
        HashMap<PaperCard, Integer> cardTotals = new HashMap<PaperCard, Integer>();
        for (PaperCard c : shuffled) {
            if (cardTotals.containsKey(c)) {
                cardTotals.put(c, (Integer)cardTotals.get(c) + 1);
                continue;
            }
            cardTotals.put(c, 1);
        }
        Iterator<PaperCard> itr = shuffled.iterator();
        while (itr.hasNext()) {
            PaperCard tmp = itr.next();
            cardTotals.put(tmp, (Integer)cardTotals.get(tmp) - 1);
            cardProbabilities.add(tmp.getName());
            itr.remove();
        }
        return cardProbabilities;
    }
}

