/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.Singletons;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.IBoosterDraft;
import forge.gamemodes.limited.WinstonDraft;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CEditorLimited;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.home.sanctioned.CSubmenuWinston;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FOptionPane;
import forge.util.ItemPool;
import forge.util.MyRandom;
import java.util.Map;

public class CEditorWinstonProcess
extends ACEditorBase<PaperCard, DeckGroup> {
    private IBoosterDraft boosterDraft;
    private String ccAddLabel = "Add card";
    private String ccAdd4Label = "Add card";
    private Runnable ccAddCommand = null;
    private Runnable ccAdd4Command = null;
    private String ccTakeLabel = "Take pile";
    private String ccPassLabel = "Pass pile";
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private boolean saved = false;

    public CEditorWinstonProcess(CDetailPicture cDetailPicture0) {
        super(FScreen.DRAFTING_PROCESS, cDetailPicture0, GameType.Draft);
        CardManager catalogManager = new CardManager(cDetailPicture0, false, false, true);
        CardManager deckManager = new CardManager(cDetailPicture0, false, false, true);
        catalogManager.setHideViewOptions(1, true);
        deckManager.setCaption("Draft Picks");
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        this.getBtnAddBasicLands().setCommand(() -> CEditorLimited.addBasicLands(this));
    }

    public final void showGui(IBoosterDraft inBoosterDraft) {
        this.boosterDraft = inBoosterDraft;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems("Draft", null);
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
    }

    private void showChoices(ItemPool<PaperCard> list) {
        int packNumber = ((BoosterDraft)this.boosterDraft).getCurrentBoosterIndex() + 1;
        StringBuilder sb = new StringBuilder();
        sb.append("Remaining: ");
        sb.append(((WinstonDraft)this.boosterDraft).getDeckSize());
        sb.append("    AI Cards: ");
        sb.append(((WinstonDraft)this.boosterDraft).getAIDraftSize());
        sb.append("    Pile");
        sb.append(" ");
        sb.append(packNumber);
        sb.append(" - Cards");
        this.getCatalogManager().setCaption(sb.toString());
        this.getCatalogManager().setPool(list);
        this.getDeckManager().refresh();
    }

    private Deck getPlayersDeck() {
        Deck deck = new Deck();
        deck.getOrCreate(DeckSection.Sideboard).addAll(this.getDeckManager().getPool());
        String landSet = IBoosterDraft.LAND_SET_CODE[0].getCode();
        boolean isZendikarSet = landSet.equals("ZEN");
        boolean zendikarSetMode = MyRandom.getRandom().nextBoolean();
        int landsCount = 10;
        for (String landName : MagicColor.Constant.BASIC_LANDS) {
            int maxArtIndex;
            int numArt = FModel.getMagicDb().getCommonCards().getArtCount(landName, landSet);
            int minArtIndex = isZendikarSet ? (zendikarSetMode ? 1 : 5) : 1;
            int n = maxArtIndex = isZendikarSet ? minArtIndex + 3 : numArt;
            if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_RANDOM_ART_IN_POOLS)) {
                for (int i = minArtIndex; i <= maxArtIndex; ++i) {
                    deck.get(DeckSection.Sideboard).add(landName, landSet, i, numArt > 1 ? 10 : 30);
                }
                continue;
            }
            deck.get(DeckSection.Sideboard).add(landName, landSet, 30);
        }
        return deck;
    }

    private void saveDraft() {
        String s2 = FOptionPane.showInputDialog("Save this draft as:", "Save Draft", FOptionPane.QUESTION_ICON);
        if (s2 == null || s2.isEmpty()) {
            this.saveDraft();
            return;
        }
        for (DeckGroup d : FModel.getDecks().getWinston()) {
            if (!s2.equalsIgnoreCase(d.getName())) continue;
            if (FOptionPane.showConfirmDialog("There is already a deck named '" + s2 + "'. Overwrite?", "Overwrite Deck?", false)) break;
            this.saveDraft();
            return;
        }
        this.saved = true;
        Deck[] computer = this.boosterDraft.getDecks();
        DeckGroup finishedDraft = new DeckGroup(s2);
        finishedDraft.setHumanDeck((Deck)this.getPlayersDeck().copyTo(s2));
        finishedDraft.addAiDecks(computer);
        FModel.getDecks().getWinston().add(finishedDraft);
        CSubmenuWinston.SINGLETON_INSTANCE.update();
        FScreen.DRAFTING_PROCESS.close();
        Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_DRAFT);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorLimited(FModel.getDecks().getWinston(), FScreen.DECK_EDITOR_DRAFT, this.getCDetailPicture()));
        CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().load(null, s2);
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    public DeckController<DeckGroup> getDeckController() {
        return null;
    }

    @Override
    public void resetTables() {
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.DRAFT_PACK);
        this.getDeckManager().setup(ItemManagerConfig.DRAFT_POOL);
        this.ccAddLabel = this.getBtnAdd().getText();
        if (this.getDeckManager().getPool() == null) {
            this.getDeckManager().setPool((Iterable)null);
            this.showChoices(this.boosterDraft.nextChoice());
        } else {
            this.showChoices(this.getCatalogManager().getPool());
        }
        this.getBtnRemove().setVisible(false);
        this.getBtnRemove4().setVisible(false);
        this.getBtnAdd().setText(this.ccTakeLabel);
        this.getBtnAdd4().setText(this.ccPassLabel);
        this.ccAddCommand = this.getBtnAdd().getCommand();
        this.ccAdd4Command = this.getBtnAdd4().getCommand();
        this.getBtnAdd().setCommand(this::takePile);
        this.getBtnAdd4().setCommand(this::passPile);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        if (isClosing && !this.saved) {
            String userPrompt = "This will end the current draft and you will not be able to resume.\n\nLeave anyway?";
            return FOptionPane.showConfirmDialog(userPrompt, "Leave Draft?", "Leave", "Cancel", false);
        }
        return true;
    }

    @Override
    public void resetUIChanges() {
        this.getBtnAdd().setText(this.ccAddLabel);
        this.getBtnAdd4().setText(this.ccAdd4Label);
        this.getBtnAdd().setCommand(this.ccAddCommand);
        this.getBtnAdd4().setCommand(this.ccAdd4Command);
        this.getBtnRemove().setVisible(true);
        this.getBtnRemove4().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(true);
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        this.getCatalogManager().setAllowMultipleSelections(true);
    }

    private void takePile() {
        CardPool newPool;
        CardPool pool = ((WinstonDraft)this.boosterDraft).takeActivePile(true);
        this.getDeckManager().getPool().addAll(pool);
        if (this.boosterDraft.hasNextChoice() && (newPool = this.boosterDraft.nextChoice()) != null) {
            this.showChoices(newPool);
            return;
        }
        this.saveDraft();
    }

    private void passPile() {
        CardPool newPool;
        CardPool pool = ((WinstonDraft)this.boosterDraft).passActivePile(true);
        if (pool != null) {
            this.getDeckManager().getPool().addAll(pool);
        }
        if ((newPool = this.boosterDraft.nextChoice()) != null) {
            this.showChoices(newPool);
        }
    }
}

