/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CEditorConstructed;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.match.controllers.CDetailPicture;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.util.storage.IStorage;
import java.util.Map;

public final class CEditorVariant
extends CDeckEditor<Deck> {
    private final DeckController<Deck> controller;
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private final Predicate<PaperCard> cardPoolCondition;

    public CEditorVariant(IStorage<Deck> folder, Predicate<PaperCard> poolCondition, DeckSection deckSection0, FScreen screen0, CDetailPicture cDetailPicture0) {
        super(screen0, cDetailPicture0, GameType.Constructed);
        this.cardPoolCondition = poolCondition;
        this.sectionMode = deckSection0;
        CardManager catalogManager = new CardManager(cDetailPicture0, true, false, false);
        CardManager deckManager = new CardManager(cDetailPicture0, false, false, false);
        deckManager.setAlwaysNonUnique(true);
        Localizer localizer = Localizer.getInstance();
        catalogManager.setCaption(localizer.getMessage("lblCatalog", new Object[0]));
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        Supplier<Deck> newCreator = Deck::new;
        this.controller = new DeckController<Deck>(folder, this, newCreator);
        this.getBtnAddBasicLands().setCommand(() -> CEditorConstructed.addBasicLands(this));
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            return ACEditorBase.CardLimit.Default;
        }
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        ItemPool itemsToAdd = this.getAllowedAdditions(items);
        if (itemsToAdd.isEmpty()) {
            return;
        }
        this.getDeckManager().addItems(itemsToAdd);
        this.getCatalogManager().selectItemEntrys(itemsToAdd);
        this.controller.notifyModelChanged();
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        this.getDeckManager().removeItems(items);
        this.getCatalogManager().selectItemEntrys(items);
        this.controller.notifyModelChanged();
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems(this.localizer.getMessage("lblAdd", new Object[0]), this.localizer.getMessage("lbltodeck", new Object[0]));
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems(this.localizer.getMessage("lblRemove", new Object[0]), this.localizer.getMessage("lblfromdeck", new Object[0]));
    }

    @Override
    public void resetTables() {
        Iterable<PaperCard> allNT = FModel.getMagicDb().getVariantCards().getAllCards();
        allNT = Iterables.filter(allNT, this.cardPoolCondition);
        this.getCatalogManager().setPool(ItemPool.createFrom(allNT, PaperCard.class), true);
        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(this.sectionMode));
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return true;
    }

    @Override
    public DeckController<Deck> getDeckController() {
        return this.controller;
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
        this.getDeckManager().setup(ItemManagerConfig.DECK_EDITOR);
        this.resetUI();
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.controller.refreshModel();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        return SEditorIO.confirmSaveChanges(this.getScreen(), isClosing);
    }

    @Override
    public void resetUIChanges() {
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
    }
}

