/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.deck.DeckBase;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperToken;
import forge.itemmanager.TokenManager;
import forge.model.FModel;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.deckeditor.views.VProbabilities;
import forge.screens.home.quest.CSubmenuQuestDecks;
import forge.screens.match.controllers.CDetailPicture;
import forge.util.Localizer;
import java.util.List;
import java.util.Map;

public class CEditorTokenViewer
extends ACEditorBase<PaperToken, DeckBase> {
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private DragCell probsParent = null;
    private List<PaperToken> fullCatalogCards;
    private String CCTabLabel = "";
    private String CCAddLabel = "";
    private String CDTabLabel = "";
    private String CDRemLabel = "";
    private String prevRem4Label = null;
    private String prevRem4Tooltip = null;
    private Runnable prevRem4Cmd = null;

    public CEditorTokenViewer(CDetailPicture cDetailPicture0) {
        super(FScreen.TOKEN_VIEWER, cDetailPicture0, GameType.Quest);
        FModel.getMagicDb().getAllTokens().preloadTokens();
        this.fullCatalogCards = FModel.getMagicDb().getAllTokens().getAllTokens();
        TokenManager catalogManager = new TokenManager(cDetailPicture0, false);
        TokenManager deckManager = new TokenManager(cDetailPicture0, false);
        catalogManager.setCaption(Localizer.getInstance().getMessage("lblAllTokens", new Object[0]));
        catalogManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperToken, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperToken, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
    }

    @Override
    public void resetTables() {
    }

    @Override
    public DeckController<DeckBase> getDeckController() {
        return null;
    }

    @Override
    public void update() {
        this.resetUI();
        this.CCTabLabel = VCardCatalog.SINGLETON_INSTANCE.getTabLabel().getText();
        VCardCatalog.SINGLETON_INSTANCE.getTabLabel().setText(Localizer.getInstance().getMessage("lblAllTokens", new Object[0]));
        this.getBtnAdd().setVisible(false);
        this.getBtnAdd4().setVisible(false);
        this.getBtnRemove().setVisible(false);
        this.getBtnAddBasicLands().setVisible(false);
        VProbabilities.SINGLETON_INSTANCE.getTabLabel().setVisible(false);
        this.prevRem4Label = this.getBtnRemove4().getText();
        this.prevRem4Tooltip = this.getBtnRemove4().getToolTipText();
        this.prevRem4Cmd = this.getBtnRemove4().getCommand();
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(false);
        this.getCatalogManager().setPool(this.fullCatalogCards);
        this.getDeckManager().setPool((Iterable)null);
        this.getBtnRemove4().setVisible(false);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.probsParent = this.removeTab(VProbabilities.SINGLETON_INSTANCE);
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        FModel.getQuest().save();
        return true;
    }

    @Override
    public void resetUIChanges() {
        CSubmenuQuestDecks.SINGLETON_INSTANCE.update();
        this.getCatalogManager().getPnlButtons().add(this.getBtnAdd4());
        this.getBtnRemove4().setText(this.prevRem4Label);
        this.getBtnRemove4().setToolTipText(this.prevRem4Tooltip);
        this.getBtnRemove4().setCommand(this.prevRem4Cmd);
        VCardCatalog.SINGLETON_INSTANCE.getTabLabel().setText(this.CCTabLabel);
        VCurrentDeck.SINGLETON_INSTANCE.getTabLabel().setText(this.CDTabLabel);
        this.getBtnAdd().setText(this.CCAddLabel);
        this.getBtnRemove().setText(this.CDRemLabel);
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        if (this.probsParent != null) {
            this.probsParent.addDoc(VProbabilities.SINGLETON_INSTANCE);
        }
    }
}

