/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gamemodes.quest.QuestController;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.views.ItemTableColumn;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CEditorLimited;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.home.quest.CSubmenuQuestDecks;
import forge.screens.match.controllers.CDetailPicture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CEditorQuestLimited
extends CDeckEditor<DeckGroup> {
    private final QuestController questData;
    private final DeckController<DeckGroup> controller;
    private final List<DeckSection> allSections = new ArrayList<DeckSection>();
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private Map<PaperCard, Integer> decksUsingMyCards;
    private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnDeckCompare = new Function<Map.Entry<InventoryItem, Integer>, Comparable<?>>(){

        @Override
        public Comparable<?> apply(Map.Entry<InventoryItem, Integer> from) {
            Integer iValue = (Integer)CEditorQuestLimited.this.decksUsingMyCards.get(from.getKey());
            return iValue == null ? Integer.valueOf(0) : iValue;
        }
    };
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDeckGet = new Function<Map.Entry<? extends InventoryItem, Integer>, Object>(){

        @Override
        public Object apply(Map.Entry<? extends InventoryItem, Integer> from) {
            Integer iValue = (Integer)CEditorQuestLimited.this.decksUsingMyCards.get(from.getKey());
            return iValue == null ? "" : iValue.toString();
        }
    };

    public CEditorQuestLimited(QuestController questData0, CDetailPicture cDetailPicture0) {
        super(FScreen.DECK_EDITOR_QUEST_TOURNAMENT, cDetailPicture0, GameType.QuestDraft);
        this.allSections.add(DeckSection.Main);
        this.allSections.add(DeckSection.Sideboard);
        this.questData = questData0;
        CardManager catalogManager = new CardManager(cDetailPicture0, false, true, false);
        CardManager deckManager = new CardManager(cDetailPicture0, false, true, false);
        catalogManager.setCaption("Sideboard");
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        Supplier<DeckGroup> newCreator = DeckGroup::new;
        this.controller = new DeckController<DeckGroup>(questData0.getDraftDecks(), this, newCreator);
        this.controller.getView().getDeckManager().setup(ItemManagerConfig.DRAFT_POOL);
        this.controller.setModel(questData0.getDraftDecks().get("Tournament Deck"));
        this.getBtnAddBasicLands().setCommand(() -> CEditorLimited.addBasicLands(this));
    }

    private Map<PaperCard, Integer> countDecksForEachCard() {
        HashMap<PaperCard, Integer> result = new HashMap<PaperCard, Integer>();
        for (Deck deck : this.questData.getMyDecks()) {
            for (Map.Entry e : deck.getMain()) {
                PaperCard card;
                Integer amount = (Integer)result.get(card = (PaperCard)e.getKey());
                result.put(card, amount == null ? 1 : 1 + amount);
            }
        }
        return result;
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            return ACEditorBase.CardLimit.Default;
        }
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        this.getDeckManager().addItems(items);
        this.getCatalogManager().removeItems(items);
        this.getDeckController().notifyModelChanged();
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        this.getCatalogManager().addItems(items);
        this.getDeckManager().removeItems(items);
        this.getDeckController().notifyModelChanged();
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems("Move", "to deck");
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems("Move", "to sideboard");
    }

    @Override
    public void resetTables() {
        this.getCatalogManager().setPool(this.getHumanDeck().getOrCreate(DeckSection.Sideboard));
        this.getDeckManager().setPool(this.getHumanDeck().getMain());
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return section != DeckSection.Sideboard && this.allSections.contains((Object)section);
    }

    @Override
    public DeckController<DeckGroup> getDeckController() {
        return this.controller;
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(this.getScreen() == FScreen.DECK_EDITOR_DRAFT ? ItemManagerConfig.DRAFT_POOL : ItemManagerConfig.SEALED_POOL);
        this.getDeckManager().setup(ItemManagerConfig.DECK_EDITOR);
        this.decksUsingMyCards = this.countDecksForEachCard();
        HashMap<ColumnDef, ItemTableColumn> colOverridesCatalog = new HashMap<ColumnDef, ItemTableColumn>();
        HashMap<ColumnDef, ItemTableColumn> colOverridesDeck = new HashMap<ColumnDef, ItemTableColumn>();
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck, ColumnDef.DECKS, this.fnDeckCompare, this.fnDeckGet);
        this.getCatalogManager().setup(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog);
        this.getDeckManager().setup(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck);
        this.resetUI();
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSave().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().setEnabled(false);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        if (this.controller.getModel() == null) {
            throw new RuntimeException("Expected deck group but found none!");
        }
        this.controller.refreshModel();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        if (SEditorIO.confirmSaveChanges(FScreen.DECK_EDITOR_QUEST_TOURNAMENT, isClosing)) {
            FModel.getQuest().save();
            return true;
        }
        FModel.getQuest().save();
        return false;
    }

    @Override
    public void resetUIChanges() {
        CSubmenuQuestDecks.SINGLETON_INSTANCE.update();
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
    }
}

