/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.IBoosterDraft;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VBrawlDecks;
import forge.screens.deckeditor.views.VCommanderDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.deckeditor.views.VOathbreakerDecks;
import forge.screens.deckeditor.views.VTinyLeadersDecks;
import forge.screens.home.quest.CSubmenuQuestDraft;
import forge.screens.home.quest.VSubmenuQuestDraft;
import forge.screens.match.controllers.CDetailPicture;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.Map;

public class CEditorQuestDraftingProcess
extends ACEditorBase<PaperCard, DeckGroup> {
    private CSubmenuQuestDraft draftQuest;
    private IBoosterDraft boosterDraft;
    private String ccAddLabel = Localizer.getInstance().getMessage("lblAddcard", new Object[0]);
    private DragCell constructedDecksParent = null;
    private DragCell commanderDecksParent = null;
    private DragCell oathbreakerDecksParent = null;
    private DragCell brawlDecksParent = null;
    private DragCell tinyLeadersDecksParent = null;
    private DragCell deckGenParent = null;
    private boolean saved = false;

    public void setDraftQuest(CSubmenuQuestDraft draftQuest0) {
        this.draftQuest = draftQuest0;
    }

    public CEditorQuestDraftingProcess(CDetailPicture cDetailPicture0) {
        super(FScreen.DRAFTING_PROCESS, cDetailPicture0, GameType.QuestDraft);
        CardManager catalogManager = new CardManager(cDetailPicture0, false, false, true);
        CardManager deckManager = new CardManager(cDetailPicture0, false, false, true);
        catalogManager.setHideViewOptions(1, true);
        deckManager.setCaption(Localizer.getInstance().getMessage("lblDraftPicks", new Object[0]));
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.getBtnAddBasicLands().setVisible(false);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
    }

    public final void showGui(IBoosterDraft inBoosterDraft) {
        this.boosterDraft = inBoosterDraft;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        PaperCard card = items.iterator().next().getKey();
        this.getDeckManager().addItem(card, 1);
        this.boosterDraft.setChoice(card);
        boolean nextChoice = this.boosterDraft.hasNextChoice();
        CardPool pool = null;
        if (nextChoice) {
            pool = this.boosterDraft.nextChoice();
            boolean bl = nextChoice = !pool.isEmpty();
        }
        if (nextChoice) {
            this.showChoices(pool);
        } else {
            this.saveDraft();
        }
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems(Localizer.getInstance().getMessage("lblDraft", new Object[0]), null);
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
    }

    private void showChoices(ItemPool<PaperCard> list) {
        int packNumber = ((BoosterDraft)this.boosterDraft).getCurrentBoosterIndex() + 1;
        this.getCatalogManager().setCaption(Localizer.getInstance().getMessage("lblPackNCards", String.valueOf(packNumber)));
        this.getCatalogManager().setPool(list);
    }

    public Deck getPlayersDeck() {
        Deck deck = new Deck();
        deck.getOrCreate(DeckSection.Sideboard).addAll(this.getDeckManager().getPool());
        return deck;
    }

    private void saveDraft() {
        this.saved = true;
        Deck[] computer = this.boosterDraft.getDecks();
        DeckGroup finishedDraft = new DeckGroup("Tournament Deck");
        finishedDraft.setHumanDeck((Deck)this.getPlayersDeck().copyTo("Tournament Deck"));
        finishedDraft.addAiDecks(computer);
        CSubmenuQuestDraft.SINGLETON_INSTANCE.update();
        FScreen.DRAFTING_PROCESS.close();
        this.draftQuest.setCompletedDraft(finishedDraft);
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    public DeckController<DeckGroup> getDeckController() {
        return null;
    }

    @Override
    public void resetTables() {
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.DRAFT_PACK);
        this.getDeckManager().setup(ItemManagerConfig.DRAFT_POOL);
        this.ccAddLabel = this.getBtnAdd().getText();
        if (this.getDeckManager().getPool() == null) {
            this.showChoices(this.boosterDraft.nextChoice());
            this.getDeckManager().setPool((Iterable)null);
        } else {
            this.showChoices(this.getCatalogManager().getPool());
        }
        this.getBtnAdd().setVisible(false);
        this.getBtnAdd4().setVisible(false);
        this.getBtnRemove().setVisible(false);
        this.getBtnRemove4().setVisible(false);
        this.getCbxSection().setVisible(false);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(false);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.constructedDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.commanderDecksParent = this.removeTab(VCommanderDecks.SINGLETON_INSTANCE);
        this.oathbreakerDecksParent = this.removeTab(VOathbreakerDecks.SINGLETON_INSTANCE);
        this.brawlDecksParent = this.removeTab(VBrawlDecks.SINGLETON_INSTANCE);
        this.tinyLeadersDecksParent = this.removeTab(VTinyLeadersDecks.SINGLETON_INSTANCE);
        this.getCatalogManager().setAllowMultipleSelections(false);
        this.getCatalogManager().refresh();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        if (isClosing && !this.saved) {
            if (this.draftQuest.cancelDraft()) {
                CSubmenuQuestDraft.SINGLETON_INSTANCE.update();
                VSubmenuQuestDraft.SINGLETON_INSTANCE.populate();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void resetUIChanges() {
        this.getBtnAdd().setText(this.ccAddLabel);
        this.getBtnAdd4().setVisible(true);
        this.getBtnRemove().setVisible(true);
        this.getBtnRemove4().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(true);
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.constructedDecksParent != null) {
            this.constructedDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        if (this.commanderDecksParent != null) {
            this.commanderDecksParent.addDoc(VCommanderDecks.SINGLETON_INSTANCE);
        }
        if (this.oathbreakerDecksParent != null) {
            this.oathbreakerDecksParent.addDoc(VOathbreakerDecks.SINGLETON_INSTANCE);
        }
        if (this.brawlDecksParent != null) {
            this.brawlDecksParent.addDoc(VBrawlDecks.SINGLETON_INSTANCE);
        }
        if (this.tinyLeadersDecksParent != null) {
            this.tinyLeadersDecksParent.addDoc(VTinyLeadersDecks.SINGLETON_INSTANCE);
        }
        this.getCatalogManager().setAllowMultipleSelections(true);
    }
}

