/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.deck.DeckBase;
import forge.game.GameType;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestSpellShop;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.SpellShopManager;
import forge.itemmanager.views.ItemTableColumn;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.deckeditor.views.VProbabilities;
import forge.screens.home.quest.CSubmenuQuestDecks;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.util.ItemPool;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public final class CEditorQuestCardShop
extends ACEditorBase<InventoryItem, DeckBase> {
    private final FLabel creditsLabel = new FLabel.Builder().icon(FSkin.getIcon(FSkinProp.ICO_QUEST_COINSTACK)).fontSize(15).build();
    private final FLabel sellPercentageLabel = new FLabel.Builder().text("0").fontSize(11).build();
    private final FLabel fullCatalogToggle = new FLabel.Builder().text("See full catalog").fontSize(14).hoverable(true).cmdClick(this::toggleFullCatalog).build();
    private final QuestController questData;
    private ItemPool<InventoryItem> cardsForSale;
    private final ItemPool<InventoryItem> fullCatalogCards = ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(), InventoryItem.class);
    private boolean showingFullCatalog = false;
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private DragCell probsParent = null;
    private String CCTabLabel = "";
    private String CCAddLabel = "";
    private String CDTabLabel = "";
    private String CDRemLabel = "";
    private String prevRem4Label = null;
    private String prevRem4Tooltip = null;
    private Runnable prevRem4Cmd = null;

    public CEditorQuestCardShop(QuestController qd, CDetailPicture cDetailPicture0) {
        super(FScreen.QUEST_CARD_SHOP, cDetailPicture0, GameType.Quest);
        this.questData = qd;
        SpellShopManager catalogManager = new SpellShopManager(cDetailPicture0, false);
        SpellShopManager deckManager = new SpellShopManager(cDetailPicture0, false);
        catalogManager.setCaption("Spell Shop");
        deckManager.setCaption("Quest Inventory");
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
    }

    private void toggleFullCatalog() {
        boolean bl = this.showingFullCatalog = !this.showingFullCatalog;
        if (this.showingFullCatalog) {
            this.getCatalogManager().setPool(this.fullCatalogCards, true);
            this.getBtnAdd().setEnabled(false);
            this.getBtnRemove().setEnabled(false);
            this.getBtnRemove4().setEnabled(false);
            this.fullCatalogToggle.setText("Return to spell shop");
        } else {
            this.getCatalogManager().setPool(this.cardsForSale);
            this.getBtnAdd().setEnabled(true);
            this.getBtnRemove().setEnabled(true);
            this.getBtnRemove4().setEnabled(true);
            this.fullCatalogToggle.setText("See full catalog");
        }
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<InventoryItem, Integer>> items, boolean toAlternate) {
        if (this.showingFullCatalog || toAlternate) {
            return;
        }
        QuestSpellShop.buy(items, this.getCatalogManager(), this.getDeckManager(), true);
        this.updateCreditsLabel();
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<InventoryItem, Integer>> items, boolean toAlternate) {
        if (this.showingFullCatalog || toAlternate) {
            return;
        }
        QuestSpellShop.sell(items, this.getCatalogManager(), this.getDeckManager(), true);
        this.updateCreditsLabel();
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        if (!this.showingFullCatalog) {
            cmb.addMoveItems("Buy", null);
        }
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        if (!this.showingFullCatalog) {
            cmb.addMoveItems("Sell", null);
        }
    }

    private void updateCreditsLabel() {
        this.creditsLabel.setText("Credits: " + QuestUtil.formatCredits(this.questData.getAssets().getCredits()));
    }

    @Override
    public void resetTables() {
    }

    @Override
    public DeckController<DeckBase> getDeckController() {
        return null;
    }

    @Override
    public void update() {
        HashMap<ColumnDef, ItemTableColumn> colOverridesCatalog = new HashMap<ColumnDef, ItemTableColumn>();
        HashMap<ColumnDef, ItemTableColumn> colOverridesDeck = new HashMap<ColumnDef, ItemTableColumn>();
        ItemTableColumn.addColOverride(ItemManagerConfig.SPELL_SHOP, colOverridesCatalog, ColumnDef.PRICE, QuestSpellShop.fnPriceCompare, QuestSpellShop.fnPriceGet);
        ItemTableColumn.addColOverride(ItemManagerConfig.SPELL_SHOP, colOverridesCatalog, ColumnDef.OWNED, this.questData.getCards().getFnOwnedCompare(), this.questData.getCards().getFnOwnedGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverridesDeck, ColumnDef.PRICE, QuestSpellShop.fnPriceCompare, QuestSpellShop.fnPriceSellGet);
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverridesDeck, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverridesDeck, ColumnDef.DECKS, QuestSpellShop.fnDeckCompare, QuestSpellShop.fnDeckGet);
        this.getCatalogManager().setup(ItemManagerConfig.SPELL_SHOP, colOverridesCatalog);
        this.getDeckManager().setup(ItemManagerConfig.QUEST_INVENTORY, colOverridesDeck);
        this.resetUI();
        this.CCTabLabel = VCardCatalog.SINGLETON_INSTANCE.getTabLabel().getText();
        VCardCatalog.SINGLETON_INSTANCE.getTabLabel().setText("Cards for sale");
        this.CCAddLabel = this.getBtnAdd().getText();
        this.getBtnAdd().setText("Buy Card");
        this.CDTabLabel = VCurrentDeck.SINGLETON_INSTANCE.getTabLabel().getText();
        VCurrentDeck.SINGLETON_INSTANCE.getTabLabel().setText("Your Cards");
        this.CDRemLabel = this.getBtnRemove().getText();
        this.getBtnRemove().setText("Sell Card");
        this.getBtnAddBasicLands().setVisible(false);
        VProbabilities.SINGLETON_INSTANCE.getTabLabel().setVisible(false);
        this.prevRem4Label = this.getBtnRemove4().getText();
        this.prevRem4Tooltip = this.getBtnRemove4().getToolTipText();
        this.prevRem4Cmd = this.getBtnRemove4().getCommand();
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(false);
        QuestSpellShop.updateDecksForEachCard();
        double multiplier = QuestSpellShop.updateMultiplier();
        this.cardsForSale = this.questData.getCards().getShopList();
        ItemPool<InventoryItem> ownedItems = new ItemPool<InventoryItem>(InventoryItem.class);
        ownedItems.addAllOfType(this.questData.getCards().getCardpool().getView());
        this.getCatalogManager().setPool(this.cardsForSale);
        this.getDeckManager().setPool(ownedItems);
        this.getBtnRemove4().setText("Sell all extras");
        this.getBtnRemove4().setToolTipText("Sell unneeded extra copies of all cards");
        this.getBtnRemove4().setCommand(() -> {
            QuestSpellShop.sellExtras(this.getCatalogManager(), this.getDeckManager());
            this.updateCreditsLabel();
        });
        this.getDeckManager().getPnlButtons().add((Component)this.creditsLabel, "gap 5px");
        this.updateCreditsLabel();
        double multiPercent = multiplier * 100.0;
        DecimalFormat formatter = new DecimalFormat("#0.00");
        String maxSellingPrice = "";
        int maxSellPrice = this.questData.getCards().getSellPriceLimit();
        if (maxSellPrice < Integer.MAX_VALUE) {
            maxSellingPrice = String.format("Maximum selling price is %d credits.", maxSellPrice);
        }
        this.getCatalogManager().getPnlButtons().remove(this.getBtnAdd4());
        this.getCatalogManager().getPnlButtons().add(this.fullCatalogToggle, "w 25%, h 30!", 0);
        this.getCatalogManager().getPnlButtons().add(this.sellPercentageLabel);
        this.sellPercentageLabel.setText("<html>Selling cards at " + formatter.format(multiPercent) + "% of their value.<br>" + maxSellingPrice + "</html>");
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.probsParent = this.removeTab(VProbabilities.SINGLETON_INSTANCE);
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        FModel.getQuest().save();
        return true;
    }

    @Override
    public void resetUIChanges() {
        if (this.showingFullCatalog) {
            this.toggleFullCatalog();
        }
        CSubmenuQuestDecks.SINGLETON_INSTANCE.update();
        this.getCatalogManager().getPnlButtons().remove(this.sellPercentageLabel);
        this.getCatalogManager().getPnlButtons().remove(this.fullCatalogToggle);
        this.getCatalogManager().getPnlButtons().add(this.getBtnAdd4());
        this.getDeckManager().getPnlButtons().remove(this.creditsLabel);
        this.getBtnRemove4().setText(this.prevRem4Label);
        this.getBtnRemove4().setToolTipText(this.prevRem4Tooltip);
        this.getBtnRemove4().setCommand(this.prevRem4Cmd);
        VCardCatalog.SINGLETON_INSTANCE.getTabLabel().setText(this.CCTabLabel);
        VCurrentDeck.SINGLETON_INSTANCE.getTabLabel().setText(this.CDTabLabel);
        this.getBtnAdd().setText(this.CCAddLabel);
        this.getBtnRemove().setText(this.CDRemLabel);
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        if (this.probsParent != null) {
            this.probsParent.addDoc(VProbabilities.SINGLETON_INSTANCE);
        }
    }
}

