/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.mana.ManaCost;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gui.GuiUtils;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.views.ItemTableColumn;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.AddBasicLandsDialog;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CEditorConstructed;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.home.quest.CSubmenuQuestDecks;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FComboBox;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public final class CEditorQuest
extends CDeckEditor<Deck> {
    private final QuestController questData;
    private final DeckController<Deck> controller;
    private final List<DeckSection> allSections = new ArrayList<DeckSection>();
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private Map<PaperCard, Integer> decksUsingMyCards;
    private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnDeckCompare = new Function<Map.Entry<InventoryItem, Integer>, Comparable<?>>(){

        @Override
        public Comparable<?> apply(Map.Entry<InventoryItem, Integer> from) {
            Integer iValue = (Integer)CEditorQuest.this.decksUsingMyCards.get(from.getKey());
            return iValue == null ? Integer.valueOf(0) : iValue;
        }
    };
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDeckGet = new Function<Map.Entry<? extends InventoryItem, Integer>, Object>(){

        @Override
        public Object apply(Map.Entry<? extends InventoryItem, Integer> from) {
            Integer iValue = (Integer)CEditorQuest.this.decksUsingMyCards.get(from.getKey());
            return iValue == null ? "" : iValue.toString();
        }
    };

    public CEditorQuest(QuestController questData0, CDetailPicture cDetailPicture0) {
        super(FScreen.DECK_EDITOR_QUEST, cDetailPicture0, GameType.Quest);
        this.allSections.add(DeckSection.Main);
        this.allSections.add(DeckSection.Sideboard);
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                break;
            }
            case Commander: {
                this.allSections.add(DeckSection.Commander);
            }
        }
        this.questData = questData0;
        CardManager catalogManager = new CardManager(cDetailPicture0, false, true, false);
        CardManager deckManager = new CardManager(cDetailPicture0, false, true, false);
        catalogManager.setCaption("Quest Inventory");
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        Supplier<Deck> newCreator = Deck::new;
        this.controller = new DeckController<Deck>(questData0.getMyDecks(), this, newCreator);
        this.getBtnAddBasicLands().setCommand(() -> {
            Deck deck = this.getDeckController().getModel();
            if (deck == null) {
                return;
            }
            AddBasicLandsDialog dialog = new AddBasicLandsDialog(deck, this.questData.getDefaultLandSet());
            CardPool landsToAdd = dialog.show();
            if (landsToAdd != null) {
                this.onAddItems(landsToAdd, false);
            }
        });
    }

    private Map<PaperCard, Integer> countDecksForEachCard() {
        HashMap<PaperCard, Integer> result = new HashMap<PaperCard, Integer>();
        for (Deck deck : this.questData.getMyDecks()) {
            for (Map.Entry e : deck.getMain()) {
                PaperCard card;
                Integer amount = (Integer)result.get(card = (PaperCard)e.getKey());
                result.put(card, amount == null ? 1 : 1 + amount);
            }
        }
        return result;
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            if (FModel.getQuest().getDeckConstructionRules() == DeckConstructionRules.Commander) {
                return ACEditorBase.CardLimit.Singleton;
            }
            return ACEditorBase.CardLimit.Default;
        }
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onAddItems(this, items, toAlternate);
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onRemoveItems(this, items, toAlternate);
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildAddContextMenu(cmb, this.sectionMode, GameType.Quest);
        this.AddRatingItem(cmb, 1);
        this.AddRatingItem(cmb, 2);
        this.AddRatingItem(cmb, 3);
        this.AddRatingItem(cmb, 4);
        this.AddRatingItem(cmb, 5);
        this.AddRatingItem(cmb, 0);
    }

    public void AddRatingItem(ACEditorBase.EditorContextMenuBuilder cmb, int n) {
        if (n == 1) {
            cmb.getMenu().addSeparator();
        }
        String s2 = n == 0 ? "Remove custom rating" : "Rate this card as " + n + " stars";
        GuiUtils.addMenuItem(cmb.getMenu(), s2, KeyStroke.getKeyStroke(48 + n, 0), () -> this.SetRatingStars(n, cmb));
    }

    public void SetRatingStars(int n, ACEditorBase.EditorContextMenuBuilder cmb) {
        ItemPool selected = cmb.getItemManager().getSelectedItemPool();
        for (Map.Entry entry : selected) {
            this.questData.SetRating(((PaperCard)entry.getKey()).getName(), ((PaperCard)entry.getKey()).getEdition(), n);
        }
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildRemoveContextMenu(cmb, this.sectionMode, false);
        this.AddRatingItem(cmb, 1);
        this.AddRatingItem(cmb, 2);
        this.AddRatingItem(cmb, 3);
        this.AddRatingItem(cmb, 4);
        this.AddRatingItem(cmb, 5);
        this.AddRatingItem(cmb, 0);
    }

    @Override
    public void resetTables() {
        this.sectionMode = DeckSection.Main;
        this.getCatalogManager().setPool(this.getRemainingCardPool());
        this.getDeckManager().setPool(this.getDeck().getMain());
    }

    private CardPool getRemainingCardPool() {
        CardPool cardpool = this.getInitialCatalog();
        cardpool.removeAll(this.getDeck().getMain());
        cardpool.removeAll(this.getDeck().getOrCreate(DeckSection.Sideboard));
        switch (FModel.getQuest().getDeckConstructionRules()) {
            case Default: {
                break;
            }
            case Commander: {
                cardpool.removeAll(this.getDeck().getOrCreate(DeckSection.Commander));
                if (this.getDeck().getOrCreate(DeckSection.Commander).toFlatList().size() <= 0) break;
                MatchCommanderColorIdentity identityPredicate = new MatchCommanderColorIdentity(this.getDeckColorIdentity());
                CardPool filteredPool = cardpool.getFilteredPool(identityPredicate);
                return filteredPool;
            }
        }
        return cardpool;
    }

    public ColorSet getDeckColorIdentity() {
        List commanders = this.getDeck().getOrCreate(DeckSection.Commander).toFlatList();
        ArrayList<String> colors = new ArrayList<String>();
        if (commanders.size() == 0) {
            colors.add("c");
            return ColorSet.fromNames(colors);
        }
        for (PaperCard pc : commanders) {
            if (!colors.contains("w") && pc.getRules().getColorIdentity().hasWhite()) {
                colors.add("w");
            }
            if (!colors.contains("u") && pc.getRules().getColorIdentity().hasBlue()) {
                colors.add("u");
            }
            if (!colors.contains("b") && pc.getRules().getColorIdentity().hasBlack()) {
                colors.add("b");
            }
            if (!colors.contains("r") && pc.getRules().getColorIdentity().hasRed()) {
                colors.add("r");
            }
            if (colors.contains("g") || !pc.getRules().getColorIdentity().hasGreen()) continue;
            colors.add("g");
        }
        colors.add("c");
        return ColorSet.fromNames(colors);
    }

    private Deck getDeck() {
        return this.controller.getModel();
    }

    private ItemPool<PaperCard> getCommanderCardPool() {
        Predicate<PaperCard> commanderPredicate = Predicates.compose(CardRulesPredicates.Presets.CAN_BE_COMMANDER, PaperCard::getRules);
        return this.getRemainingCardPool().getFilteredPool(commanderPredicate);
    }

    @Override
    protected CardPool getInitialCatalog() {
        return new CardPool(this.questData.getCards().getCardpool());
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return this.allSections.contains((Object)section);
    }

    @Override
    public DeckController<Deck> getDeckController() {
        return this.controller;
    }

    public void setEditorMode(DeckSection sectionMode) {
        if (sectionMode == null) {
            sectionMode = DeckSection.Main;
        }
        HashMap<ColumnDef, ItemTableColumn> colOverridesCatalog = new HashMap<ColumnDef, ItemTableColumn>();
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        switch (sectionMode) {
            case Main: {
                this.getCatalogManager().setup(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog);
                this.getCatalogManager().setPool(this.getRemainingCardPool());
                this.getDeckManager().setPool(this.controller.getModel().getMain());
                break;
            }
            case Sideboard: {
                this.getCatalogManager().setup(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog);
                this.getCatalogManager().setPool(this.getRemainingCardPool());
                this.getDeckManager().setPool(this.getDeck().getOrCreate(DeckSection.Sideboard));
                break;
            }
            case Commander: {
                this.getCatalogManager().setup(ItemManagerConfig.COMMANDER_POOL);
                this.getCatalogManager().setPool(this.getCommanderCardPool());
                this.getDeckManager().setPool(this.getDeck().getOrCreate(DeckSection.Commander));
            }
        }
        this.sectionMode = sectionMode;
        this.controller.updateCaptions();
    }

    @Override
    public void update() {
        this.decksUsingMyCards = this.countDecksForEachCard();
        HashMap<ColumnDef, ItemTableColumn> colOverridesCatalog = new HashMap<ColumnDef, ItemTableColumn>();
        HashMap<ColumnDef, ItemTableColumn> colOverridesDeck = new HashMap<ColumnDef, ItemTableColumn>();
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck, ColumnDef.NEW, this.questData.getCards().getFnNewCompare(), this.questData.getCards().getFnNewGet());
        ItemTableColumn.addColOverride(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck, ColumnDef.DECKS, this.fnDeckCompare, this.fnDeckGet);
        this.getCatalogManager().setup(ItemManagerConfig.QUEST_EDITOR_POOL, colOverridesCatalog);
        this.getDeckManager().setup(ItemManagerConfig.QUEST_DECK_EDITOR, colOverridesDeck);
        this.resetUI();
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSave().setVisible(true);
        this.getCbxSection().removeAllItems();
        for (DeckSection section : this.allSections) {
            this.getCbxSection().addItem(section);
        }
        this.getCbxSection().addActionListener(actionEvent -> {
            FComboBox cb = (FComboBox)actionEvent.getSource();
            DeckSection ds = (DeckSection)((Object)((Object)cb.getSelectedItem()));
            this.setEditorMode(ds);
        });
        this.getCbxSection().setVisible(true);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        if (this.controller.getModel() == null) {
            this.getDeckController().setModel(new Deck());
        } else {
            this.controller.refreshModel();
        }
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        if (SEditorIO.confirmSaveChanges(FScreen.DECK_EDITOR_QUEST, isClosing)) {
            FModel.getQuest().save();
            return true;
        }
        return false;
    }

    @Override
    public void resetUIChanges() {
        CSubmenuQuestDecks.SINGLETON_INSTANCE.update();
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
    }

    public static class MatchCommanderColorIdentity
    implements Predicate<PaperCard> {
        private final ColorSet allowedColor;

        public MatchCommanderColorIdentity(ColorSet color) {
            this.allowedColor = color;
        }

        @Override
        public boolean apply(PaperCard subject) {
            CardRules cr = subject.getRules();
            ManaCost mc = cr.getManaCost();
            return this.allowedColor.containsAllColorsFrom(cr.getColorIdentity().getColor());
        }
    }
}

