/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Supplier;
import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import forge.screens.deckeditor.AddBasicLandsDialog;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VBrawlDecks;
import forge.screens.deckeditor.views.VCommanderDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.deckeditor.views.VOathbreakerDecks;
import forge.screens.deckeditor.views.VTinyLeadersDecks;
import forge.screens.home.sanctioned.CSubmenuDraft;
import forge.screens.home.sanctioned.CSubmenuSealed;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FComboBox;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CEditorLimited
extends CDeckEditor<DeckGroup> {
    private final DeckController<DeckGroup> controller;
    private DragCell constructedDecksParent = null;
    private DragCell commanderDecksParent = null;
    private DragCell oathbreakerDecksParent = null;
    private DragCell brawlDecksParent = null;
    private DragCell tinyLeadersDecksParent = null;
    private DragCell deckGenParent = null;
    private final List<DeckSection> allSections = new ArrayList<DeckSection>();

    public CEditorLimited(IStorage<DeckGroup> deckMap0, FScreen screen0, CDetailPicture cDetailPicture0) {
        super(screen0, cDetailPicture0, GameType.Sealed);
        CardManager catalogManager = new CardManager(cDetailPicture0, false, false, FScreen.DECK_EDITOR_DRAFT.equals(screen0));
        CardManager deckManager = new CardManager(cDetailPicture0, false, false, FScreen.DECK_EDITOR_DRAFT.equals(screen0));
        catalogManager.setCaption("Sideboard");
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        Supplier<DeckGroup> newCreator = DeckGroup::new;
        this.controller = new DeckController<DeckGroup>(deckMap0, this, newCreator);
        this.getBtnAddBasicLands().setCommand(() -> CEditorLimited.addBasicLands(this));
        this.allSections.add(DeckSection.Main);
        this.allSections.add(DeckSection.Conspiracy);
        this.allSections.add(DeckSection.Attractions);
        this.getCbxSection().removeAllItems();
        for (DeckSection section : this.allSections) {
            this.getCbxSection().addItem(section);
        }
        this.getCbxSection().addActionListener(actionEvent -> {
            FComboBox cb = (FComboBox)actionEvent.getSource();
            DeckSection ds = (DeckSection)((Object)((Object)cb.getSelectedItem()));
            this.setEditorMode(ds);
        });
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        this.getDeckManager().addItems(items);
        this.getCatalogManager().removeItems(items);
        this.getDeckController().notifyModelChanged();
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        this.getCatalogManager().addItems(items);
        this.getDeckManager().removeItems(items);
        this.getDeckController().notifyModelChanged();
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems("Move", "to deck");
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems("Move", "to sideboard");
    }

    @Override
    public void resetTables() {
        this.getCatalogManager().setPool(this.getHumanDeck().getOrCreate(DeckSection.Sideboard));
        this.getDeckManager().setPool(this.getHumanDeck().getMain());
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return section != DeckSection.Sideboard && this.allSections.contains((Object)section);
    }

    @Override
    public DeckController<DeckGroup> getDeckController() {
        return this.controller;
    }

    public static void addBasicLands(ACEditorBase<PaperCard, DeckGroup> editor) {
        Deck deck = editor.getHumanDeck();
        if (deck == null) {
            return;
        }
        HashSet<CardEdition> availableEditionCodes = new HashSet<CardEdition>();
        for (PaperCard p : deck.getAllCardsInASinglePool().toFlatList()) {
            availableEditionCodes.add(FModel.getMagicDb().getEditions().get(p.getEdition()));
        }
        CardEdition defaultLandSet = CardEdition.Predicates.getRandomSetWithAllBasicLands(availableEditionCodes);
        AddBasicLandsDialog dialog = new AddBasicLandsDialog(deck, defaultLandSet);
        CardPool landsToAdd = dialog.show();
        if (landsToAdd != null) {
            editor.onAddItems(landsToAdd, false);
        }
    }

    public void setEditorMode(DeckSection sectionMode) {
        switch (sectionMode) {
            case Conspiracy: {
                this.getCatalogManager().setup(ItemManagerConfig.DRAFT_CONSPIRACY);
                this.getDeckManager().setPool(this.getHumanDeck().getOrCreate(DeckSection.Conspiracy));
                break;
            }
            case Attractions: {
                this.getCatalogManager().setup(ItemManagerConfig.ATTRACTION_POOL);
                this.getDeckManager().setPool(this.getHumanDeck().getOrCreate(DeckSection.Attractions));
                break;
            }
            case Main: {
                this.getCatalogManager().setup(this.getScreen() == FScreen.DECK_EDITOR_DRAFT ? ItemManagerConfig.DRAFT_POOL : ItemManagerConfig.SEALED_POOL);
                this.getDeckManager().setPool(this.getHumanDeck().getOrCreate(DeckSection.Main));
                break;
            }
        }
        this.sectionMode = sectionMode;
        this.controller.updateCaptions();
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(this.getScreen() == FScreen.DECK_EDITOR_DRAFT ? ItemManagerConfig.DRAFT_POOL : ItemManagerConfig.SEALED_POOL);
        this.getDeckManager().setup(ItemManagerConfig.DECK_EDITOR);
        this.resetUI();
        VCurrentDeck.SINGLETON_INSTANCE.getBtnPrintProxies().setVisible(false);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().setEnabled(false);
        this.getCbxSection().setVisible(true);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.constructedDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.commanderDecksParent = this.removeTab(VCommanderDecks.SINGLETON_INSTANCE);
        this.oathbreakerDecksParent = this.removeTab(VOathbreakerDecks.SINGLETON_INSTANCE);
        this.brawlDecksParent = this.removeTab(VBrawlDecks.SINGLETON_INSTANCE);
        this.tinyLeadersDecksParent = this.removeTab(VTinyLeadersDecks.SINGLETON_INSTANCE);
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        return SEditorIO.confirmSaveChanges(this.getScreen(), isClosing);
    }

    @Override
    public void resetUIChanges() {
        CSubmenuDraft.SINGLETON_INSTANCE.update();
        CSubmenuSealed.SINGLETON_INSTANCE.update();
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.constructedDecksParent != null) {
            this.constructedDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        if (this.commanderDecksParent != null) {
            this.commanderDecksParent.addDoc(VCommanderDecks.SINGLETON_INSTANCE);
        }
        if (this.oathbreakerDecksParent != null) {
            this.oathbreakerDecksParent.addDoc(VOathbreakerDecks.SINGLETON_INSTANCE);
        }
        if (this.brawlDecksParent != null) {
            this.brawlDecksParent.addDoc(VBrawlDecks.SINGLETON_INSTANCE);
        }
        if (this.tinyLeadersDecksParent != null) {
            this.tinyLeadersDecksParent.addDoc(VTinyLeadersDecks.SINGLETON_INSTANCE);
        }
    }
}

