/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.Singletons;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.IBoosterDraft;
import forge.gamemodes.limited.IDraftLog;
import forge.gamemodes.limited.LimitedPlayer;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CEditorLimited;
import forge.screens.deckeditor.controllers.CEditorLog;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VBrawlDecks;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.deckeditor.views.VCommanderDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.deckeditor.views.VEditorLog;
import forge.screens.deckeditor.views.VOathbreakerDecks;
import forge.screens.deckeditor.views.VTinyLeadersDecks;
import forge.screens.home.sanctioned.CSubmenuDraft;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FOptionPane;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.HashSet;
import java.util.Map;

public class CEditorDraftingProcess
extends ACEditorBase<PaperCard, DeckGroup>
implements IDraftLog {
    private IBoosterDraft boosterDraft;
    private String ccAddLabel = Localizer.getInstance().getMessage("lblAddcard", new Object[0]);
    private DragCell constructedDecksParent = null;
    private DragCell commanderDecksParent = null;
    private DragCell oathbreakerDecksParent = null;
    private DragCell brawlDecksParent = null;
    private DragCell tinyLeadersDecksParent = null;
    private DragCell deckGenParent = null;
    private DragCell draftLogParent = null;
    private boolean saved = false;
    private final Localizer localizer = Localizer.getInstance();

    public CEditorDraftingProcess(CDetailPicture cDetailPicture0) {
        super(FScreen.DRAFTING_PROCESS, cDetailPicture0, GameType.Draft);
        CardManager catalogManager = new CardManager(cDetailPicture0, false, false, true);
        CardManager deckManager = new CardManager(cDetailPicture0, false, false, true);
        catalogManager.setHideViewOptions(1, true);
        deckManager.setCaption(this.localizer.getMessage("lblDraftPicks", new Object[0]));
        catalogManager.setAlwaysNonUnique(true);
        deckManager.setAlwaysNonUnique(true);
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
    }

    public final void showGui(IBoosterDraft inBoosterDraft) {
        this.boosterDraft = inBoosterDraft;
        this.boosterDraft.setLogEntry(this);
        VEditorLog.SINGLETON_INSTANCE.resetNewDraft();
        this.addLogEntry("Drafting process started.");
    }

    @Override
    public void addLogEntry(String message) {
        CEditorLog.SINGLETON_INSTANCE.addLogEntry(message);
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        if (toAlternate) {
            return;
        }
        PaperCard card = items.iterator().next().getKey();
        if (this.boosterDraft.getHumanPlayer().shouldSkipThisPick()) {
            System.out.println(card + " not drafted because we're skipping this pick");
            this.showPackToDraft();
            return;
        }
        if (this.boosterDraft.getHumanPlayer().hasArchdemonCurse()) {
            card = this.boosterDraft.getHumanPlayer().pickFromArchdemonCurse(this.boosterDraft.getHumanPlayer().nextChoice());
        }
        this.getDeckManager().addItem(card, 1);
        this.boosterDraft.setChoice(card);
        this.showPackToDraft();
    }

    protected void showPackToDraft() {
        boolean nextChoice = this.boosterDraft.hasNextChoice();
        CardPool pool = null;
        if (nextChoice) {
            pool = this.boosterDraft.nextChoice();
            boolean bl = nextChoice = pool != null && !pool.isEmpty();
        }
        if (nextChoice) {
            this.showChoices(pool);
        } else {
            this.boosterDraft.postDraftActions();
            this.saveDraft();
        }
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        cmb.addMoveItems(this.localizer.getMessage("lblDraft", new Object[0]), null);
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
    }

    private void showChoices(ItemPool<PaperCard> list) {
        int packNumber = ((BoosterDraft)this.boosterDraft).getCurrentBoosterIndex() + 1;
        this.getCatalogManager().setCaption(this.localizer.getMessage("lblPackNCards", String.valueOf(packNumber)));
        int count = list.countAll();
        if (this.boosterDraft.getHumanPlayer().hasArchdemonCurse()) {
            this.getCatalogManager().setPool(this.generateFakePaperCards(count));
        } else {
            this.getCatalogManager().setPool(list);
        }
    }

    private ItemPool<PaperCard> generateFakePaperCards(int count) {
        ItemPool<PaperCard> pool = new ItemPool<PaperCard>(PaperCard.class);
        for (int i = 0; i < count; ++i) {
            pool.add(PaperCard.FAKE_CARD);
        }
        return pool;
    }

    private Deck getPlayersDeck() {
        Deck deck = new Deck();
        deck.getOrCreate(DeckSection.Sideboard).addAll(this.getDeckManager().getPool());
        return deck;
    }

    private void saveDraft() {
        String s2;
        HashSet<String> names = new HashSet<String>();
        for (DeckGroup d : FModel.getDecks().getDraft()) {
            names.add(d.getName());
        }
        do {
            if ((s2 = FOptionPane.showInputDialog(this.localizer.getMessage("lblSaveDraftAs", new Object[0]) + ":", this.localizer.getMessage("lblSaveDraft", new Object[0]), FOptionPane.QUESTION_ICON)) == null && FOptionPane.showConfirmDialog(this.localizer.getMessage("lblQuitWithoutSaving", new Object[0]) + "?", this.localizer.getMessage("lblQuitDraft", new Object[0]) + "?", false)) {
                FScreen.DRAFTING_PROCESS.close();
                return;
            }
            if (!names.contains(s2) || FOptionPane.showConfirmDialog(this.localizer.getMessage("lblAlreadyDeckName", new Object[0]) + s2 + this.localizer.getMessage("lblOverwriteConfirm", new Object[0]), this.localizer.getMessage("lblOverwriteDeck", new Object[0]), false)) continue;
            s2 = "";
        } while (s2 == null || s2.isEmpty());
        Deck[] computer = this.boosterDraft.getDecks();
        LimitedPlayer[] players = this.boosterDraft.getOpposingPlayers();
        for (int i = 0; i < computer.length; ++i) {
            Deck deck = computer[i];
            LimitedPlayer player = players[i];
            deck.setDraftNotes(player.getSerializedDraftNotes());
        }
        DeckGroup finishedDraft = new DeckGroup(s2);
        LimitedPlayer player = this.boosterDraft.getHumanPlayer();
        Deck humanDeck = (Deck)this.getPlayersDeck().copyTo(s2);
        for (PaperCard card : player.getRemovedFromCardPool()) {
            humanDeck.get(DeckSection.Sideboard).remove(card);
        }
        humanDeck.setDraftNotes(player.getSerializedDraftNotes());
        finishedDraft.setHumanDeck(humanDeck);
        finishedDraft.addAiDecks(computer);
        FModel.getDecks().getDraft().add(finishedDraft);
        this.saved = true;
        CSubmenuDraft.SINGLETON_INSTANCE.update();
        FScreen.DRAFTING_PROCESS.close();
        Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_DRAFT);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorLimited(FModel.getDecks().getDraft(), FScreen.DECK_EDITOR_DRAFT, this.getCDetailPicture()));
        CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().load(null, s2);
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.None;
    }

    @Override
    public DeckController<DeckGroup> getDeckController() {
        return null;
    }

    @Override
    public void resetTables() {
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.DRAFT_PACK);
        this.getDeckManager().setup(ItemManagerConfig.DRAFT_POOL);
        if (VEditorLog.SINGLETON_INSTANCE.getParentCell() == null) {
            VCardCatalog.SINGLETON_INSTANCE.getParentCell().addDoc(VEditorLog.SINGLETON_INSTANCE);
            VEditorLog.SINGLETON_INSTANCE.showView();
        }
        this.ccAddLabel = this.getBtnAdd().getText();
        if (this.getDeckManager().getPool() == null) {
            this.showChoices(this.boosterDraft.nextChoice());
            this.getDeckManager().setPool((Iterable)null);
        } else {
            this.showChoices(this.getCatalogManager().getPool());
        }
        this.getBtnAdd().setVisible(false);
        this.getBtnAdd4().setVisible(false);
        this.getBtnRemove().setVisible(false);
        this.getBtnRemove4().setVisible(false);
        this.getCbxSection().setVisible(false);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(false);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.constructedDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.commanderDecksParent = this.removeTab(VCommanderDecks.SINGLETON_INSTANCE);
        this.oathbreakerDecksParent = this.removeTab(VOathbreakerDecks.SINGLETON_INSTANCE);
        this.brawlDecksParent = this.removeTab(VBrawlDecks.SINGLETON_INSTANCE);
        this.tinyLeadersDecksParent = this.removeTab(VTinyLeadersDecks.SINGLETON_INSTANCE);
        this.getCatalogManager().setAllowMultipleSelections(false);
        this.getCatalogManager().refresh();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        if (isClosing && !this.saved && this.boosterDraft.hasNextChoice()) {
            String userPrompt = this.localizer.getMessage("lblEndDraftConfirm", new Object[0]);
            return FOptionPane.showConfirmDialog(userPrompt, this.localizer.getMessage("lblLeaveDraft", new Object[0]), this.localizer.getMessage("lblLeave", new Object[0]), this.localizer.getMessage("lblCancel", new Object[0]), false);
        }
        return true;
    }

    @Override
    public void resetUIChanges() {
        this.getBtnAdd().setText(this.ccAddLabel);
        this.getBtnAdd4().setVisible(true);
        this.getBtnRemove().setVisible(true);
        this.getBtnRemove4().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(true);
        VEditorLog.SINGLETON_INSTANCE.getParentCell().setVisible(true);
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.constructedDecksParent != null) {
            this.constructedDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
        if (this.commanderDecksParent != null) {
            this.commanderDecksParent.addDoc(VCommanderDecks.SINGLETON_INSTANCE);
        }
        if (this.oathbreakerDecksParent != null) {
            this.oathbreakerDecksParent.addDoc(VOathbreakerDecks.SINGLETON_INSTANCE);
        }
        if (this.brawlDecksParent != null) {
            this.brawlDecksParent.addDoc(VBrawlDecks.SINGLETON_INSTANCE);
        }
        if (this.tinyLeadersDecksParent != null) {
            this.tinyLeadersDecksParent.addDoc(VTinyLeadersDecks.SINGLETON_INSTANCE);
        }
        if (this.draftLogParent != null) {
            this.draftLogParent.addDoc(VEditorLog.SINGLETON_INSTANCE);
        }
        this.getCatalogManager().setAllowMultipleSelections(true);
    }
}

