/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Supplier;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.AddBasicLandsDialog;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FComboBox;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CEditorConstructed
extends CDeckEditor<Deck> {
    private DeckController<Deck> controller;
    private final List<DeckSection> allSections = new ArrayList<DeckSection>();
    private ItemPool<PaperCard> normalPool;
    private ItemPool<PaperCard> avatarPool;
    private ItemPool<PaperCard> planePool;
    private ItemPool<PaperCard> schemePool;
    private ItemPool<PaperCard> conspiracyPool;
    private ItemPool<PaperCard> commanderPool;
    private ItemPool<PaperCard> dungeonPool;
    private ItemPool<PaperCard> attractionPool;
    CardManager catalogManager;
    CardManager deckManager;

    public CEditorConstructed(CDetailPicture cDetailPicture0) {
        this(cDetailPicture0, GameType.Constructed);
    }

    public CEditorConstructed(CDetailPicture cDetailPicture0, GameType gameType0) {
        super(FScreen.DECK_EDITOR_CONSTRUCTED, cDetailPicture0, gameType0);
        boolean wantUnique = false;
        this.allSections.add(DeckSection.Main);
        this.allSections.add(DeckSection.Sideboard);
        switch (this.gameType) {
            case Constructed: {
                this.allSections.add(DeckSection.Avatar);
                this.allSections.add(DeckSection.Schemes);
                this.allSections.add(DeckSection.Planes);
                this.allSections.add(DeckSection.Conspiracy);
                this.allSections.add(DeckSection.Dungeon);
                this.normalPool = FModel.getAllCardsNoAlt();
                this.avatarPool = FModel.getAvatarPool();
                this.planePool = FModel.getPlanechaseCards();
                this.schemePool = FModel.getArchenemyCards();
                this.conspiracyPool = FModel.getConspiracyPool();
                this.dungeonPool = FModel.getDungeonPool();
                break;
            }
            case Commander: {
                this.allSections.add(DeckSection.Commander);
                this.commanderPool = FModel.getCommanderPool();
                this.normalPool = FModel.getAllCardsNoAlt();
                wantUnique = true;
                break;
            }
            case TinyLeaders: {
                this.allSections.add(DeckSection.Commander);
                this.commanderPool = FModel.getTinyLeadersCommander();
                this.normalPool = FModel.getAllCardsNoAlt();
                wantUnique = true;
                break;
            }
            case Oathbreaker: {
                this.allSections.add(DeckSection.Commander);
                this.commanderPool = FModel.getOathbreakerCommander();
                this.normalPool = FModel.getAllCardsNoAlt();
                wantUnique = true;
                break;
            }
            case Brawl: {
                this.allSections.add(DeckSection.Commander);
                this.commanderPool = FModel.getBrawlCommander();
                this.normalPool = ItemPool.createFrom(((GameFormat)FModel.getFormats().get("Brawl")).getAllCards(), PaperCard.class);
                wantUnique = true;
                break;
            }
        }
        this.allSections.add(DeckSection.Attractions);
        this.attractionPool = FModel.getAttractionPool();
        this.catalogManager = new CardManager(this.getCDetailPicture(), wantUnique, false, false);
        this.deckManager = new CardManager(this.getCDetailPicture(), false, false, false);
        this.deckManager.setAlwaysNonUnique(true);
        Localizer localizer = Localizer.getInstance();
        this.catalogManager.setCaption(localizer.getMessage("lblCatalog", new Object[0]));
        this.setCatalogManager(this.catalogManager);
        this.setDeckManager(this.deckManager);
        Supplier<Deck> newCreator = Deck::new;
        switch (this.gameType) {
            case Constructed: {
                this.controller = new DeckController<Deck>(FModel.getDecks().getConstructed(), this, newCreator);
                break;
            }
            case Commander: {
                this.controller = new DeckController<Deck>(FModel.getDecks().getCommander(), this, newCreator);
                break;
            }
            case Oathbreaker: {
                this.controller = new DeckController<Deck>(FModel.getDecks().getOathbreaker(), this, newCreator);
                break;
            }
            case Brawl: {
                this.controller = new DeckController<Deck>(FModel.getDecks().getBrawl(), this, newCreator);
                break;
            }
            case TinyLeaders: {
                this.controller = new DeckController<Deck>(FModel.getDecks().getTinyLeaders(), this, newCreator);
                break;
            }
        }
        this.getBtnAddBasicLands().setCommand(() -> CEditorConstructed.addBasicLands(this));
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        if (this.sectionMode == DeckSection.Avatar) {
            return ACEditorBase.CardLimit.Singleton;
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            switch (this.gameType) {
                case Constructed: {
                    return ACEditorBase.CardLimit.Default;
                }
                case Commander: 
                case TinyLeaders: 
                case Oathbreaker: 
                case Brawl: {
                    return ACEditorBase.CardLimit.Singleton;
                }
            }
        }
        return ACEditorBase.CardLimit.None;
    }

    public static void onAddItems(ACEditorBase<PaperCard, Deck> editor, Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        ItemPool<PaperCard> itemsToAdd;
        DeckController<Deck> controller;
        block14: {
            block13: {
                DeckSection sectionMode = editor.sectionMode;
                controller = editor.getDeckController();
                block0 : switch (sectionMode) {
                    case Commander: {
                        int count = editor.getDeckManager().getItemCount();
                        if (count <= 0) break;
                        PaperCard newCard = (PaperCard)items.iterator().next().getKey();
                        if (editor.gameType == GameType.Oathbreaker) {
                            for (Map.Entry<PaperCard, Integer> entry : editor.getDeckManager().getPool()) {
                                if (entry.getKey().getRules().canBeOathbreaker() != newCard.getRules().canBeOathbreaker()) continue;
                                editor.getDeckManager().removeItem(entry.getKey(), entry.getValue());
                                break block0;
                            }
                            break;
                        }
                        if (count == 1 && newCard.getRules().canBePartnerCommander()) {
                            PaperCard commander = editor.getDeckManager().getPool().toFlatList().get(0);
                            if (commander.getRules().canBePartnerCommanders(newCard.getRules())) break;
                            editor.getDeckManager().removeAllItems();
                            break;
                        }
                        editor.getDeckManager().removeAllItems();
                        break;
                    }
                    case Avatar: {
                        editor.getDeckManager().removeAllItems();
                        break;
                    }
                }
                itemsToAdd = editor.getAllowedAdditions(items);
                if (itemsToAdd.isEmpty()) {
                    return;
                }
                if (!toAlternate) break block13;
                switch (sectionMode) {
                    case Main: {
                        controller.getModel().getOrCreate(DeckSection.Sideboard).addAll(itemsToAdd);
                        break block14;
                    }
                    default: {
                        return;
                    }
                }
            }
            editor.getDeckManager().addItems(itemsToAdd);
        }
        if (editor.getCatalogManager().isInfinite()) {
            editor.getCatalogManager().selectItemEntrys(itemsToAdd);
        } else {
            editor.getCatalogManager().removeItems(items);
        }
        controller.notifyModelChanged();
    }

    public static void onRemoveItems(ACEditorBase<PaperCard, Deck> editor, Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        DeckSection sectionMode = editor.sectionMode;
        DeckController<Deck> controller = editor.getDeckController();
        if (toAlternate) {
            switch (sectionMode) {
                case Main: {
                    controller.getModel().getOrCreate(DeckSection.Sideboard).addAll(items);
                    break;
                }
                case Sideboard: {
                    controller.getModel().get(DeckSection.Main).addAll(items);
                    break;
                }
            }
        } else if (!editor.getCatalogManager().isInfinite()) {
            editor.getCatalogManager().addItems(items);
        }
        editor.getDeckManager().removeItems(items);
        controller.notifyModelChanged();
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onAddItems(this, items, toAlternate);
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onRemoveItems(this, items, toAlternate);
    }

    public static void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb, DeckSection sectionMode, GameType gameType) {
        Localizer localizer = Localizer.getInstance();
        switch (sectionMode) {
            case Main: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltodeck", new Object[0]));
                cmb.addMoveAlternateItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltosideboard", new Object[0]));
                break;
            }
            case Sideboard: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltosideboard", new Object[0]));
                break;
            }
            case Commander: {
                if (gameType == GameType.Oathbreaker) {
                    PaperCard pc = (PaperCard)cmb.getItemManager().getSelectedItem();
                    if (pc != null && pc.getRules().canBeSignatureSpell()) {
                        cmb.addMoveItems(localizer.getMessage("lblSetEdition", new Object[0]), localizer.getMessage("lblassignaturespell", new Object[0]));
                        break;
                    }
                    cmb.addMoveItems(localizer.getMessage("lblSetEdition", new Object[0]), localizer.getMessage("lblasoathbreaker", new Object[0]));
                    break;
                }
                cmb.addMoveItems(localizer.getMessage("lblSetEdition", new Object[0]), localizer.getMessage("lblascommander", new Object[0]));
                break;
            }
            case Avatar: {
                cmb.addMoveItems(localizer.getMessage("lblSetEdition", new Object[0]), localizer.getMessage("lblasavatar", new Object[0]));
                break;
            }
            case Schemes: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltoschemedeck", new Object[0]));
                break;
            }
            case Planes: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltoplanardeck", new Object[0]));
                break;
            }
            case Conspiracy: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltoconspiracydeck", new Object[0]));
                break;
            }
            case Dungeon: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltodungeondeck", new Object[0]));
                break;
            }
            case Attractions: {
                cmb.addMoveItems(localizer.getMessage("lblAdd", new Object[0]), localizer.getMessage("lbltoattractiondeck", new Object[0]));
            }
        }
    }

    public static void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb, DeckSection sectionMode, boolean foilAvailable) {
        Localizer localizer = Localizer.getInstance();
        switch (sectionMode) {
            case Main: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromdeck", new Object[0]));
                cmb.addMoveAlternateItems(localizer.getMessage("lblMove", new Object[0]), localizer.getMessage("lbltosideboard", new Object[0]));
                break;
            }
            case Sideboard: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromsideboard", new Object[0]));
                cmb.addMoveAlternateItems("Move", "to deck");
                break;
            }
            case Commander: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblascommander", new Object[0]));
                break;
            }
            case Avatar: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblasavatar", new Object[0]));
                break;
            }
            case Schemes: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromschemedeck", new Object[0]));
                break;
            }
            case Planes: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromplanardeck", new Object[0]));
                break;
            }
            case Conspiracy: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromconspiracydeck", new Object[0]));
                break;
            }
            case Dungeon: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromdungeondeck", new Object[0]));
                break;
            }
            case Attractions: {
                cmb.addMoveItems(localizer.getMessage("lblRemove", new Object[0]), localizer.getMessage("lblfromattractiondeck", new Object[0]));
            }
        }
        if (foilAvailable) {
            cmb.addMakeFoils();
        }
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildAddContextMenu(cmb, this.sectionMode, this.gameType);
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildRemoveContextMenu(cmb, this.sectionMode, true);
    }

    @Override
    public void resetTables() {
        ItemPool currentPool = this.getCatalogManager().getPool();
        DeckSection selectedSection = (DeckSection)((Object)this.getCbxSection().getSelectedItem());
        if (selectedSection != DeckSection.Main || currentPool == null || !currentPool.equals(this.normalPool)) {
            this.getCbxSection().setSelectedItem((Object)DeckSection.Main);
            this.setEditorMode(DeckSection.Main);
        } else {
            this.getDeckManager().setPool(this.controller.getModel().getMain());
        }
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return this.allSections.contains((Object)section);
    }

    @Override
    public DeckController<Deck> getDeckController() {
        return this.controller;
    }

    public void setEditorMode(DeckSection sectionMode) {
        if (sectionMode == null) {
            return;
        }
        block0 : switch (this.gameType) {
            case Constructed: {
                switch (sectionMode) {
                    case Main: {
                        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                        this.getCatalogManager().setPool(this.normalPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getMain());
                        break;
                    }
                    case Sideboard: {
                        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                        this.getCatalogManager().setPool(this.normalPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Sideboard));
                        break;
                    }
                    case Avatar: {
                        this.getCatalogManager().setup(ItemManagerConfig.AVATAR_POOL);
                        this.getCatalogManager().setPool(this.avatarPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(false);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Avatar));
                        break;
                    }
                    case Planes: {
                        this.getCatalogManager().setup(ItemManagerConfig.PLANAR_POOL);
                        this.getCatalogManager().setPool(this.planePool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Planes));
                        break;
                    }
                    case Schemes: {
                        this.getCatalogManager().setup(ItemManagerConfig.SCHEME_POOL);
                        this.getCatalogManager().setPool(this.schemePool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Schemes));
                        break;
                    }
                    case Commander: {
                        break;
                    }
                    case Conspiracy: {
                        this.getCatalogManager().setup(ItemManagerConfig.CONSPIRACY_DECKS);
                        this.getCatalogManager().setPool(this.conspiracyPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Conspiracy));
                        break;
                    }
                    case Dungeon: {
                        this.getCatalogManager().setup(ItemManagerConfig.DUNGEON_DECKS);
                        this.getCatalogManager().setPool(this.dungeonPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Dungeon));
                        break;
                    }
                    case Attractions: {
                        this.getCatalogManager().setup(ItemManagerConfig.ATTRACTION_POOL);
                        this.getCatalogManager().setPool(this.attractionPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Attractions));
                    }
                }
            }
            case Commander: 
            case TinyLeaders: 
            case Oathbreaker: 
            case Brawl: {
                switch (sectionMode) {
                    case Main: {
                        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                        this.getCatalogManager().setPool(this.normalPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getMain());
                        break block0;
                    }
                    case Sideboard: {
                        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                        this.getCatalogManager().setPool(this.normalPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Sideboard));
                        break block0;
                    }
                    case Commander: {
                        this.getCatalogManager().setup(ItemManagerConfig.COMMANDER_POOL);
                        this.getCatalogManager().setPool(this.commanderPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(false);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Commander));
                        break block0;
                    }
                    case Attractions: {
                        this.getCatalogManager().setup(ItemManagerConfig.ATTRACTION_POOL);
                        this.getCatalogManager().setPool(this.attractionPool, true);
                        this.getCatalogManager().setAllowMultipleSelections(true);
                        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Attractions));
                        break block0;
                    }
                }
            }
        }
        this.sectionMode = sectionMode;
        this.controller.updateCaptions();
    }

    public static void addBasicLands(ACEditorBase<PaperCard, Deck> editor) {
        Deck deck = editor.getDeckController().getModel();
        if (deck == null) {
            return;
        }
        AddBasicLandsDialog dialog = new AddBasicLandsDialog(deck);
        CardPool landsToAdd = dialog.show();
        if (landsToAdd != null) {
            editor.onAddItems(landsToAdd, false);
        }
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
        this.getDeckManager().setup(ItemManagerConfig.DECK_EDITOR);
        this.resetUI();
        this.getCbxSection().removeAllItems();
        for (DeckSection section : this.allSections) {
            this.getCbxSection().addItem(section);
        }
        this.getCbxSection().addActionListener(actionEvent -> {
            FComboBox cb = (FComboBox)actionEvent.getSource();
            DeckSection ds = (DeckSection)((Object)((Object)cb.getSelectedItem()));
            this.setEditorMode(ds);
        });
        this.getCbxSection().setVisible(true);
        this.controller.refreshModel();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        return SEditorIO.confirmSaveChanges(FScreen.DECK_EDITOR_CONSTRUCTED, false);
    }

    @Override
    public void resetUIChanges() {
    }
}

