/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import forge.card.CardDb;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.model.CardCollections;
import forge.model.FModel;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CEditorConstructed;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VDeckgen;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FComboBox;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CEditorCommander
extends CDeckEditor<Deck> {
    private final DeckController<Deck> controller;
    private DragCell allDecksParent = null;
    private DragCell deckGenParent = null;
    private List<DeckSection> allSections = new ArrayList<DeckSection>();
    private final ItemPool<PaperCard> commanderPool;
    private final ItemPool<PaperCard> normalPool;

    public CEditorCommander(CDetailPicture cDetailPicture, GameType gameType0) {
        super(gameType0 == GameType.TinyLeaders ? FScreen.DECK_EDITOR_TINY_LEADERS : (gameType0 == GameType.Brawl ? FScreen.DECK_EDITOR_BRAWL : (gameType0 == GameType.Oathbreaker ? FScreen.DECK_EDITOR_OATHBREAKER : FScreen.DECK_EDITOR_COMMANDER)), cDetailPicture, gameType0);
        this.allSections.add(DeckSection.Main);
        this.allSections.add(DeckSection.Sideboard);
        this.allSections.add(DeckSection.Commander);
        CardDb commonCards = FModel.getMagicDb().getCommonCards();
        if (this.gameType == GameType.Brawl) {
            GameFormat format = (GameFormat)FModel.getFormats().get("Brawl");
            Predicate<CardRules> commanderFilter = CardRulesPredicates.Presets.CAN_BE_BRAWL_COMMANDER;
            this.commanderPool = ItemPool.createFrom(commonCards.getAllCardsNoAlt(Predicates.and(format.getFilterPrinted(), Predicates.compose(commanderFilter, PaperCard::getRules))), PaperCard.class);
            this.normalPool = ItemPool.createFrom(format.getAllCards(), PaperCard.class);
        } else {
            Predicate<CardRules> commanderFilter = this.gameType == GameType.Oathbreaker ? Predicates.or(CardRulesPredicates.Presets.CAN_BE_OATHBREAKER, CardRulesPredicates.Presets.CAN_BE_SIGNATURE_SPELL) : CardRulesPredicates.Presets.CAN_BE_COMMANDER;
            this.commanderPool = ItemPool.createFrom(commonCards.getAllCardsNoAlt(Predicates.compose(commanderFilter, PaperCard::getRules)), PaperCard.class);
            this.normalPool = ItemPool.createFrom(commonCards.getAllCardsNoAlt(), PaperCard.class);
        }
        CardManager catalogManager = new CardManager(this.getCDetailPicture(), true, false, false);
        CardManager deckManager = new CardManager(this.getCDetailPicture(), false, false, false);
        deckManager.setAlwaysNonUnique(true);
        catalogManager.setCaption("Catalog");
        this.setCatalogManager(catalogManager);
        this.setDeckManager(deckManager);
        Supplier<Deck> newCreator = Deck::new;
        CardCollections decks = FModel.getDecks();
        switch (this.gameType) {
            case TinyLeaders: {
                this.controller = new DeckController<Deck>(decks.getTinyLeaders(), this, newCreator);
                break;
            }
            case Brawl: {
                this.controller = new DeckController<Deck>(decks.getBrawl(), this, newCreator);
                break;
            }
            case Oathbreaker: {
                this.controller = new DeckController<Deck>(decks.getOathbreaker(), this, newCreator);
                break;
            }
            default: {
                this.controller = new DeckController<Deck>(decks.getCommander(), this, newCreator);
            }
        }
        this.getBtnAddBasicLands().setCommand(() -> CEditorConstructed.addBasicLands(this));
    }

    @Override
    protected ACEditorBase.CardLimit getCardLimit() {
        return ACEditorBase.CardLimit.Singleton;
    }

    @Override
    protected void onAddItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onAddItems(this, items, toAlternate);
    }

    @Override
    protected void onRemoveItems(Iterable<Map.Entry<PaperCard, Integer>> items, boolean toAlternate) {
        CEditorConstructed.onRemoveItems(this, items, toAlternate);
    }

    @Override
    protected void buildAddContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildAddContextMenu(cmb, this.sectionMode, this.gameType);
    }

    @Override
    protected void buildRemoveContextMenu(ACEditorBase.EditorContextMenuBuilder cmb) {
        CEditorConstructed.buildRemoveContextMenu(cmb, this.sectionMode, true);
    }

    @Override
    public void resetTables() {
        this.sectionMode = DeckSection.Main;
        this.getCatalogManager().setPool(this.normalPool, true);
        this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Main));
    }

    @Override
    public Boolean isSectionImportable(DeckSection section) {
        return this.allSections.contains((Object)section);
    }

    @Override
    public DeckController<Deck> getDeckController() {
        return this.controller;
    }

    @Override
    public void update() {
        this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
        this.getDeckManager().setup(ItemManagerConfig.DECK_EDITOR);
        this.resetUI();
        this.getBtnRemove4().setVisible(false);
        this.getBtnAdd4().setVisible(false);
        this.getCbxSection().removeAllItems();
        for (DeckSection section : this.allSections) {
            this.getCbxSection().addItem(section);
        }
        this.getCbxSection().addActionListener(actionEvent -> {
            FComboBox cb = (FComboBox)actionEvent.getSource();
            DeckSection ds = (DeckSection)((Object)((Object)cb.getSelectedItem()));
            this.setEditorMode(ds);
        });
        this.getCbxSection().setVisible(true);
        this.deckGenParent = this.removeTab(VDeckgen.SINGLETON_INSTANCE);
        this.allDecksParent = this.removeTab(VAllDecks.SINGLETON_INSTANCE);
        this.controller.refreshModel();
    }

    @Override
    public boolean canSwitchAway(boolean isClosing) {
        return SEditorIO.confirmSaveChanges(FScreen.DECK_EDITOR_COMMANDER, isClosing);
    }

    @Override
    public void resetUIChanges() {
        if (this.deckGenParent != null) {
            this.deckGenParent.addDoc(VDeckgen.SINGLETON_INSTANCE);
        }
        if (this.allDecksParent != null) {
            this.allDecksParent.addDoc(VAllDecks.SINGLETON_INSTANCE);
        }
    }

    public void setEditorMode(DeckSection sectionMode) {
        switch (sectionMode) {
            case Main: {
                this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                this.getCatalogManager().setPool(this.normalPool, true);
                this.getDeckManager().setPool(this.controller.getModel().getMain());
                break;
            }
            case Sideboard: {
                this.getCatalogManager().setup(ItemManagerConfig.CARD_CATALOG);
                this.getCatalogManager().setPool(this.normalPool, true);
                this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Sideboard));
                break;
            }
            case Commander: {
                this.getCatalogManager().setup(ItemManagerConfig.COMMANDER_POOL);
                this.getCatalogManager().setPool(this.commanderPool, true);
                this.getDeckManager().setPool(this.controller.getModel().getOrCreate(DeckSection.Commander));
                break;
            }
        }
        this.sectionMode = sectionMode;
        this.controller.updateCaptions();
    }
}

