/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.Singletons;
import forge.card.CardDb;
import forge.card.CardRulesPredicates;
import forge.card.MagicColor;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGenerator2Color;
import forge.deck.generation.DeckGenerator3Color;
import forge.deck.generation.DeckGenerator5Color;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.DeckGeneratorMonoColor;
import forge.deck.generation.IDeckGenPool;
import forge.gui.framework.ICDoc;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.views.VDeckgen;
import forge.util.Aggregates;

public enum CDeckgen implements ICDoc
{
    SINGLETON_INSTANCE;


    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VDeckgen.SINGLETON_INSTANCE.getBtnRandCardpool().setCommand(this::newRandomConstructed);
        VDeckgen.SINGLETON_INSTANCE.getBtnRandDeck2().setCommand(() -> this.newGenerateConstructed(2));
        VDeckgen.SINGLETON_INSTANCE.getBtnRandDeck3().setCommand(() -> this.newGenerateConstructed(3));
        VDeckgen.SINGLETON_INSTANCE.getBtnRandDeck5().setCommand(() -> this.newGenerateConstructed(5));
    }

    @Override
    public void update() {
    }

    private <TItem extends InventoryItem, TModel extends DeckBase> void newRandomConstructed() {
        if (!SEditorIO.confirmSaveChanges(Singletons.getControl().getCurrentScreen(), true)) {
            return;
        }
        Deck randomDeck = new Deck();
        Predicate notBasicLand = Predicates.not(Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules));
        Iterable<PaperCard> source = Iterables.filter(FModel.getMagicDb().getCommonCards().getUniqueCards(), notBasicLand);
        randomDeck.getMain().addAllFlat(Aggregates.random(source, 75));
        for (String landName : MagicColor.Constant.BASIC_LANDS) {
            randomDeck.getMain().add(landName, 1);
        }
        randomDeck.getMain().add("Terramorphic Expanse", 1);
        ACEditorBase<? extends InventoryItem, ? extends DeckBase> ed = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
        ed.getDeckController().setModel(randomDeck);
    }

    private <TItem extends InventoryItem, TModel extends DeckBase> void newGenerateConstructed(int colorCount0) {
        if (!SEditorIO.confirmSaveChanges(Singletons.getControl().getCurrentScreen(), true)) {
            return;
        }
        Deck genConstructed = new Deck();
        CardDb cardDb = FModel.getMagicDb().getCommonCards();
        DeckGeneratorBase gen = null;
        switch (colorCount0) {
            case 1: {
                gen = new DeckGeneratorMonoColor((IDeckGenPool)cardDb, DeckFormat.Constructed, null);
                break;
            }
            case 2: {
                gen = new DeckGenerator2Color(cardDb, DeckFormat.Constructed, null, null);
                break;
            }
            case 3: {
                gen = new DeckGenerator3Color(cardDb, DeckFormat.Constructed, null, null, null);
                break;
            }
            case 5: {
                gen = new DeckGenerator5Color(cardDb, DeckFormat.Constructed);
            }
        }
        if (null != gen) {
            gen.setSingleton(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_SINGLETONS));
            gen.setUseArtifacts(!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_ARTIFACTS));
            genConstructed.getMain().addAll(gen.getDeck(60, false));
        }
        ACEditorBase<? extends InventoryItem, ? extends DeckBase> ed = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
        ed.getDeckController().setModel(genConstructed);
    }
}

