/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import forge.Singletons;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.io.DeckSerializer;
import forge.gui.framework.ICDoc;
import forge.localinstance.properties.ForgeConstants;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.DeckImport;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.controllers.DeckHtmlSerializer;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.toolbox.FOptionPane;
import java.awt.Dialog;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public enum CCurrentDeck implements ICDoc
{
    SINGLETON_INSTANCE;

    private static File previousDirectory;
    private final JFileChooser fileChooser = new JFileChooser(ForgeConstants.DECK_BASE_DIR);
    public static final FileFilter HTML_FILTER;

    private CCurrentDeck() {
        FileFilter[] defaultFilters;
        for (FileFilter defFilter : defaultFilters = this.fileChooser.getChoosableFileFilters()) {
            this.fileChooser.removeChoosableFileFilter(defFilter);
        }
        FileFilter DCK_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".dck") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Simple Deck File .dck";
            }
        };
        this.fileChooser.addChoosableFileFilter(DCK_FILTER);
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSave().setCommand(SEditorIO::saveDeck);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSaveAs().setCommand(this::exportDeck);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnPrintProxies().setCommand(this::printProxies);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnOpen().setCommand(this::openDeck);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnNew().setCommand(this::newDeck);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnImport().setCommand(this::importDeck);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().notifyModelChanged();
                }
            }
        });
    }

    private <TModel extends DeckBase> void importDeck() {
        CDeckEditor ed = (CDeckEditor)CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController();
        DeckImport dImport = new DeckImport(ed);
        dImport.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dImport.setVisible(true);
    }

    @Override
    public void update() {
    }

    private void newDeck() {
        if (!SEditorIO.confirmSaveChanges(Singletons.getControl().getCurrentScreen(), true)) {
            return;
        }
        try {
            SwingUtilities.invokeLater(() -> {
                CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().loadDeck(new Deck());
                VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().requestFocusInWindow();
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating new deck. " + ex);
        }
    }

    private void openDeck() {
        if (!SEditorIO.confirmSaveChanges(Singletons.getControl().getCurrentScreen(), true)) {
            return;
        }
        File file = this.getImportFilename();
        if (file != null) {
            try {
                CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().loadDeck(DeckSerializer.fromFile(file));
            }
            catch (Exception ex) {
                throw new RuntimeException("Error importing deck.", ex);
            }
        }
    }

    private File getImportFilename() {
        int returnVal;
        this.fileChooser.setDialogTitle("Import Deck");
        this.fileChooser.setDialogType(0);
        if (previousDirectory != null) {
            this.fileChooser.setCurrentDirectory(previousDirectory);
        }
        if ((returnVal = this.fileChooser.showOpenDialog(null)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            previousDirectory = file.getParentFile();
            return file;
        }
        return null;
    }

    private void exportDeck() {
        DeckController<? extends DeckBase> controller = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController();
        File filename = this.getExportFilename();
        if (filename == null) {
            return;
        }
        String name = filename.getName();
        name = name.substring(0, name.lastIndexOf("."));
        Deck deck = (Deck)controller.getModel().getHumanDeck().copyTo(name);
        try {
            DeckSerializer.writeDeck(deck, filename);
            Deck deserialized = DeckSerializer.fromFile(filename);
            CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().loadDeck(deserialized);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error exporting deck." + ex);
        }
    }

    private void printProxies() {
        File filename = this.getPrintProxiesFilename();
        if (filename == null) {
            return;
        }
        try {
            DeckHtmlSerializer.writeDeckHtml((Deck)CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().getModel(), filename);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error exporting deck." + ex);
        }
    }

    private File getExportFilename() {
        this.fileChooser.setDialogTitle("Export Deck");
        this.fileChooser.setDialogType(1);
        if (previousDirectory != null) {
            this.fileChooser.setCurrentDirectory(previousDirectory);
        }
        if (this.fileChooser.showSaveDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            String check = file.getAbsolutePath();
            previousDirectory = file.getParentFile();
            if (!previousDirectory.exists()) {
                FOptionPane.showErrorDialog("Cannot save deck to " + check);
                return null;
            }
            if (CCurrentDeck.isFileNameInvalid(file)) {
                FOptionPane.showErrorDialog("Cannot save deck to " + check + "\nDeck name may not include any of the characters / \\ : * ? \" < > |");
                return null;
            }
            return check.endsWith(".dck") ? file : new File(check + ".dck");
        }
        return null;
    }

    private File getPrintProxiesFilename() {
        JFileChooser save = new JFileChooser(previousDirectory);
        save.setDialogTitle("Print Proxies");
        save.setDialogType(1);
        save.setFileFilter(HTML_FILTER);
        if (save.showSaveDialog(null) == 0) {
            File file = save.getSelectedFile();
            String check = file.getAbsolutePath();
            previousDirectory = file.getParentFile();
            if (!previousDirectory.exists()) {
                FOptionPane.showErrorDialog("Cannot save proxies to " + check);
                return null;
            }
            if (CCurrentDeck.isFileNameInvalid(file)) {
                FOptionPane.showErrorDialog("Cannot save proxies to " + check + "\nFile name may not include any of the characters / \\ : * ? \" < > |");
                return null;
            }
            return check.endsWith(".html") ? file : new File(check + ".html");
        }
        return null;
    }

    private static boolean isFileNameInvalid(File file) {
        Pattern pattern = Pattern.compile("[/\\\\:*?\\\"<>|]");
        return pattern.matcher(file.getName()).find();
    }

    static {
        HTML_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".html") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Proxy File .html";
            }
        };
    }
}

