/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor.controllers;

import com.google.common.collect.Iterables;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.gui.GuiBase;
import forge.gui.GuiChoose;
import forge.gui.GuiUtils;
import forge.gui.framework.DragCell;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.SRearrangingUtil;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SItemManagerUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menus.IMenuProvider;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.menus.CDeckEditorUIMenus;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.ContextMenuBuilder;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.util.Aggregates;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.view.FView;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class ACEditorBase<TItem extends InventoryItem, TModel extends DeckBase>
implements IMenuProvider {
    public boolean listenersHooked;
    private final FScreen screen;
    private ItemManager<TItem> catalogManager;
    private ItemManager<TItem> deckManager;
    protected DeckSection sectionMode = DeckSection.Main;
    private final CDetailPicture cDetailPicture;
    protected final GameType gameType;
    final Localizer localizer = Localizer.getInstance();
    private final FLabel btnAdd = new FLabel.Builder().fontSize(14).text(this.localizer.getMessage("lblAddcard", new Object[0])).tooltip(this.localizer.getMessage("ttAddcard", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_PLUS)).iconScaleAuto(false).hoverable().build();
    private final FLabel btnAdd4 = new FLabel.Builder().fontSize(14).text(this.localizer.getMessage("lblAdd4ofcard", new Object[0])).tooltip(this.localizer.getMessage("ttAdd4ofcard", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_PLUS)).iconScaleAuto(false).hoverable().build();
    private final FLabel btnRemove = new FLabel.Builder().fontSize(14).text(this.localizer.getMessage("lblRemovecard", new Object[0])).tooltip(this.localizer.getMessage("ttRemovecard", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_MINUS)).iconScaleAuto(false).hoverable().build();
    private final FLabel btnRemove4 = new FLabel.Builder().fontSize(14).text(this.localizer.getMessage("lblRemove4ofcard", new Object[0])).tooltip(this.localizer.getMessage("ttRemove4ofcard", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_MINUS)).iconScaleAuto(false).hoverable().build();
    private final FLabel btnAddBasicLands = new FLabel.Builder().fontSize(14).text(this.localizer.getMessage("lblAddBasicLands", new Object[0])).tooltip(this.localizer.getMessage("ttAddBasicLands", new Object[0])).icon(FSkin.getImage(FSkinProp.IMG_LAND, Math.round(18.0f * GuiBase.getInterface().getScreenScale()), Math.round(18.0f * GuiBase.getInterface().getScreenScale()))).iconScaleAuto(false).hoverable().build();

    protected ACEditorBase(FScreen screen0, CDetailPicture cDetailPicture0, GameType gameType0) {
        this.screen = screen0;
        this.cDetailPicture = cDetailPicture0;
        this.gameType = gameType0;
    }

    public FScreen getScreen() {
        return this.screen;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public DeckSection getSectionMode() {
        return this.sectionMode;
    }

    protected final CDetailPicture getCDetailPicture() {
        return this.cDetailPicture;
    }

    @Override
    public List<JMenu> getMenus() {
        if (this.getDeckController() == null) {
            return null;
        }
        return new CDeckEditorUIMenus().getMenus();
    }

    public final void addItem(TItem item) {
        this.onAddItems(this.createPoolForItem(item, 1), false);
    }

    public final void addItem(TItem item, int qty) {
        this.onAddItems(this.createPoolForItem(item, qty), false);
    }

    public final void removeItem(TItem item) {
        this.onRemoveItems(this.createPoolForItem(item, 1), false);
    }

    public final void removeItem(TItem item, int qty) {
        this.onRemoveItems(this.createPoolForItem(item, qty), false);
    }

    private ItemPool<TItem> createPoolForItem(TItem item, int qty) {
        if (item == null || qty <= 0) {
            return null;
        }
        ItemPool pool = new ItemPool(item.getClass());
        pool.add(item, qty);
        return pool;
    }

    public final void addItems(Iterable<Map.Entry<TItem, Integer>> items, boolean toAlternate) {
        if (items == null || !items.iterator().hasNext()) {
            return;
        }
        this.onAddItems(items, toAlternate);
    }

    public final void removeItems(Iterable<Map.Entry<TItem, Integer>> items, boolean toAlternate) {
        if (items == null || !items.iterator().hasNext()) {
            return;
        }
        this.onRemoveItems(items, toAlternate);
    }

    protected ItemPool<TItem> getAllowedAdditions(Iterable<Map.Entry<TItem, Integer>> itemsToAdd) {
        ItemPool<TItem> additions = new ItemPool<TItem>(this.getCatalogManager().getGenericType());
        CardLimit limit = this.getCardLimit();
        DeckController<TModel> controller = this.getDeckController();
        Deck deck = this.getHumanDeck();
        Iterable cardsByName = null;
        if (deck != null) {
            CardPool allCards = deck.getAllCardsInASinglePool();
            cardsByName = Aggregates.groupSumBy(allCards, pc -> pc.getRules().getNormalizedName());
        }
        for (Map.Entry<TItem, Integer> itemEntry : itemsToAdd) {
            int max;
            InventoryItem item = (InventoryItem)itemEntry.getKey();
            PaperCard card = item instanceof PaperCard ? (PaperCard)item : null;
            int qty = itemEntry.getValue();
            if (deck == null || card == null || limit == CardLimit.None || DeckFormat.canHaveAnyNumberOf(card)) {
                max = Integer.MAX_VALUE;
            } else {
                Map.Entry cardAmountInfo;
                max = limit == CardLimit.Singleton ? 1 : FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
                Integer cardCopies = DeckFormat.canHaveSpecificNumberInDeck(card);
                if (cardCopies != null) {
                    max = cardCopies;
                }
                if ((cardAmountInfo = (Map.Entry)Iterables.find(cardsByName, t2 -> ((String)t2.getKey()).equals(card.getRules().getNormalizedName()), null)) != null) {
                    max -= ((Integer)cardAmountInfo.getValue()).intValue();
                }
            }
            if (qty > max) {
                qty = max;
            }
            if (qty <= 0) continue;
            additions.add(item, qty);
        }
        return additions;
    }

    protected abstract CardLimit getCardLimit();

    protected abstract void onAddItems(Iterable<Map.Entry<TItem, Integer>> var1, boolean var2);

    protected abstract void onRemoveItems(Iterable<Map.Entry<TItem, Integer>> var1, boolean var2);

    protected abstract void buildAddContextMenu(EditorContextMenuBuilder var1);

    protected abstract void buildRemoveContextMenu(EditorContextMenuBuilder var1);

    public abstract void resetTables();

    public abstract DeckController<TModel> getDeckController();

    protected Deck getHumanDeck() {
        try {
            return ((DeckBase)this.getDeckController().getModel()).getHumanDeck();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public abstract boolean canSwitchAway(boolean var1);

    public abstract void update();

    public abstract void resetUIChanges();

    public ItemManager<TItem> getDeckManager() {
        return this.deckManager;
    }

    public void setDeckManager(ItemManager<TItem> itemManager) {
        this.deckManager = itemManager;
        this.btnRemove.setCommand(() -> CDeckEditorUI.SINGLETON_INSTANCE.removeSelectedCards(false, 1));
        this.btnRemove4.setCommand(() -> CDeckEditorUI.SINGLETON_INSTANCE.removeSelectedCards(false, 4));
        itemManager.getPnlButtons().add((Component)this.btnRemove, "w 30%!, h 30px!, gapx 5");
        itemManager.getPnlButtons().add((Component)this.btnRemove4, "w 30%!, h 30px!, gapx 5");
        itemManager.getPnlButtons().add((Component)this.btnAddBasicLands, "w 30%!, h 30px!, gapx 5");
    }

    public ItemManager<TItem> getCatalogManager() {
        return this.catalogManager;
    }

    public void setCatalogManager(ItemManager<TItem> itemManager) {
        this.catalogManager = itemManager;
        this.btnAdd.setCommand(() -> CDeckEditorUI.SINGLETON_INSTANCE.addSelectedCards(false, 1));
        this.btnAdd4.setCommand(() -> CDeckEditorUI.SINGLETON_INSTANCE.addSelectedCards(false, 4));
        itemManager.getPnlButtons().add((Component)this.btnAdd, "w 30%!, h 30px!, h 30px!, gapx 5");
        itemManager.getPnlButtons().add((Component)this.btnAdd4, "w 30%!, h 30px!, h 30px!, gapx 5");
    }

    protected DragCell removeTab(IVDoc<? extends ICDoc> tab) {
        DragCell parent;
        if (tab.getParentCell() == null) {
            parent = null;
        } else {
            parent = tab.getParentCell();
            parent.removeDoc(tab);
            tab.setParentCell(null);
            if (parent.getDocs().size() > 0) {
                parent.setSelected(parent.getDocs().get(0));
            } else {
                SwingUtilities.invokeLater(() -> {
                    SRearrangingUtil.fillGap(parent);
                    FView.SINGLETON_INSTANCE.removeDragCell(parent);
                });
            }
        }
        return parent;
    }

    protected void resetUI() {
        this.getBtnAdd4().setVisible(true);
        this.getBtnRemove4().setVisible(true);
        this.getBtnAddBasicLands().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSave().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnSaveAs().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnNew().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnOpen().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getBtnImport().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().setEnabled(true);
        VCurrentDeck.SINGLETON_INSTANCE.getPnlHeader().setVisible(true);
        VCardCatalog.SINGLETON_INSTANCE.getTabLabel().setText(this.localizer.getMessage("lblCardCatalog", new Object[0]));
        VCurrentDeck.SINGLETON_INSTANCE.getBtnPrintProxies().setVisible(true);
        this.getCbxSection().setVisible(false);
        VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().setVisible(true);
        VCurrentDeck.SINGLETON_INSTANCE.getLblTitle().setText(this.localizer.getMessage("lblTitle", new Object[0]) + ":");
    }

    public FLabel getBtnAdd() {
        return this.btnAdd;
    }

    public FLabel getBtnAdd4() {
        return this.btnAdd4;
    }

    public FLabel getBtnRemove() {
        return this.btnRemove;
    }

    public FLabel getBtnRemove4() {
        return this.btnRemove4;
    }

    public FLabel getBtnAddBasicLands() {
        return this.btnAddBasicLands;
    }

    public FComboBox getCbxSection() {
        return this.deckManager.getCbxSection();
    }

    public ContextMenuBuilder createContextMenuBuilder(boolean isAddContextMenu0) {
        return new EditorContextMenuBuilder(isAddContextMenu0);
    }

    protected class EditorContextMenuBuilder
    implements ContextMenuBuilder {
        private final boolean isAddContextMenu;
        private JPopupMenu menu;

        private EditorContextMenuBuilder(boolean isAddContextMenu0) {
            this.isAddContextMenu = isAddContextMenu0;
        }

        public ItemManager<TItem> getItemManager() {
            return this.isAddContextMenu ? ACEditorBase.this.catalogManager : ACEditorBase.this.deckManager;
        }

        private ItemManager<TItem> getNextItemManager() {
            return this.isAddContextMenu ? ACEditorBase.this.deckManager : ACEditorBase.this.catalogManager;
        }

        public JPopupMenu getMenu() {
            return this.menu;
        }

        @Override
        public void buildContextMenu(JPopupMenu menu) {
            this.menu = menu;
            if (this.isAddContextMenu) {
                ACEditorBase.this.buildAddContextMenu(this);
            } else {
                ACEditorBase.this.buildRemoveContextMenu(this);
            }
            this.menu = null;
            if (menu.getComponentCount() > 0) {
                menu.addSeparator();
            }
            GuiUtils.addMenuItem(menu, ACEditorBase.this.localizer.getMessage("lblJumptoprevioustable", new Object[0]), KeyStroke.getKeyStroke(37, 384), () -> this.getNextItemManager().focus());
            GuiUtils.addMenuItem(menu, ACEditorBase.this.localizer.getMessage("lblJumptopnexttable", new Object[0]), KeyStroke.getKeyStroke(39, 384), () -> this.getNextItemManager().focus());
            GuiUtils.addMenuItem(menu, ACEditorBase.this.localizer.getMessage("lblJumptotextfilter", new Object[0]), KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), () -> this.getItemManager().focusSearch());
        }

        public void addMakeFoils() {
            int max = this.getMaxMoveQuantity();
            if (max == 0) {
                return;
            }
            this.addMakeFoil(1);
            if (max == 1) {
                return;
            }
            int qty = FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
            if (qty > max) {
                qty = max;
            }
            this.addMakeFoil(qty);
            if (max == 2) {
                return;
            }
            this.addMakeFoil(-max);
        }

        private void addMakeFoil(int qty) {
            String label = ACEditorBase.this.localizer.getMessage("lblConvertToFoil", new Object[0]) + " " + SItemManagerUtil.getItemDisplayString(this.getItemManager().getSelectedItems(), qty, false);
            GuiUtils.addMenuItem(this.menu, label, null, () -> {
                Integer quantity = qty;
                if (quantity < 0 && (quantity = GuiChoose.getInteger(ACEditorBase.this.localizer.getMessage("lblChooseavalueforX", new Object[0]), 1, -quantity.intValue(), 20)) == null) {
                    return;
                }
                CardManager cardManager = (CardManager)CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckManager();
                PaperCard existingCard = (PaperCard)cardManager.getSelectedItem();
                PaperCard foiledCard = existingCard.isFoil() ? existingCard.getUnFoiled() : existingCard.getFoiled();
                CDeckEditorUI.SINGLETON_INSTANCE.removeSelectedCards(false, quantity);
                cardManager.addItem(foiledCard, quantity);
                cardManager.setSelectedItem(foiledCard);
            }, true, true);
        }

        private void addItem(String verb, String dest, boolean toAlternate, int qty, int shortcutModifiers) {
            String label = verb + " " + SItemManagerUtil.getItemDisplayString(this.getItemManager().getSelectedItems(), qty, false);
            if (dest != null && !dest.isEmpty()) {
                label = label + " " + dest;
            }
            GuiUtils.addMenuItem(this.menu, label, KeyStroke.getKeyStroke(32, shortcutModifiers), () -> {
                Integer quantity = qty;
                if (quantity < 0 && (quantity = GuiChoose.getInteger(ACEditorBase.this.localizer.getMessage("lblChooseavalueforX", new Object[0]), 1, -quantity.intValue(), 20)) == null) {
                    return;
                }
                if (this.isAddContextMenu) {
                    CDeckEditorUI.SINGLETON_INSTANCE.addSelectedCards(toAlternate, quantity);
                } else {
                    CDeckEditorUI.SINGLETON_INSTANCE.removeSelectedCards(toAlternate, quantity);
                }
            }, true, shortcutModifiers == 0);
        }

        private int getMaxMoveQuantity() {
            ItemPool selectedItemPool = this.getItemManager().getSelectedItemPool();
            if (this.isAddContextMenu) {
                selectedItemPool = ACEditorBase.this.getAllowedAdditions(selectedItemPool);
            }
            if (selectedItemPool.isEmpty()) {
                return 0;
            }
            int max = Integer.MAX_VALUE;
            for (Map.Entry entry : selectedItemPool) {
                if (entry.getValue() >= max) continue;
                max = entry.getValue();
            }
            return max;
        }

        private void addItems(String verb, String dest, boolean toAlternate, int shortcutModifiers1, int shortcutModifiers2, int shortcutModifiers3) {
            int max = this.getMaxMoveQuantity();
            if (max == 0) {
                return;
            }
            this.addItem(verb, dest, toAlternate, 1, shortcutModifiers1);
            if (max == 1) {
                return;
            }
            int qty = FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
            if (qty > max) {
                qty = max;
            }
            this.addItem(verb, dest, toAlternate, qty, shortcutModifiers2);
            if (max == 2) {
                return;
            }
            this.addItem(verb, dest, toAlternate, -max, shortcutModifiers3);
        }

        public void addMoveItems(String verb, String dest) {
            this.addItems(verb, dest, false, 0, 64, 512);
        }

        public void addMoveAlternateItems(String verb, String dest) {
            if (this.menu.getComponentCount() > 0) {
                this.menu.addSeparator();
            }
            this.addItems(verb, dest, true, 128, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), 0x200 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    public static enum CardLimit {
        Singleton,
        Default,
        None;

    }
}

