/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor;

import com.google.common.collect.ImmutableList;
import forge.Singletons;
import forge.deck.DeckBase;
import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.gui.framework.FScreen;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CAllDecks;
import forge.screens.deckeditor.controllers.CBrawlDecks;
import forge.screens.deckeditor.controllers.CCommanderDecks;
import forge.screens.deckeditor.controllers.COathbreakerDecks;
import forge.screens.deckeditor.controllers.CTinyLeadersDecks;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VBrawlDecks;
import forge.screens.deckeditor.views.VCommanderDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VOathbreakerDecks;
import forge.screens.deckeditor.views.VTinyLeadersDecks;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import org.apache.commons.lang3.StringUtils;

public class SEditorIO {
    private static final ImmutableList<String> confirmSaveOptions = ImmutableList.of(Localizer.getInstance().getMessage("lblSave", new Object[0]), Localizer.getInstance().getMessage("lblDontSave", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]));

    public static boolean saveDeck() {
        DeckController<? extends DeckBase> controller = CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController();
        String name = VCurrentDeck.SINGLETON_INSTANCE.getTxfTitle().getText();
        String deckStr = DeckProxy.getDeckString(controller.getModelPath(), name);
        boolean performSave = false;
        if (name == null || name.isEmpty()) {
            FOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPleaseTitleBoxNameYourDeck", new Object[0]), Localizer.getInstance().getMessage("lblSaveErrorWarning", new Object[0]), FOptionPane.ERROR_ICON);
            return false;
        }
        if (controller.fileExists(name)) {
            performSave = !StringUtils.equals(name, controller.getModelName()) ? FOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblAlreadyDeckName", new Object[0]) + name + Localizer.getInstance().getMessage("lblOverwriteConfirm", new Object[0]), Localizer.getInstance().getMessage("lblOverwriteDeck", new Object[0])) : !controller.isSaved();
        } else if (FOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblThisWillCreateNewDeckNameIs", name), Localizer.getInstance().getMessage("lblCreateDeckConfirm", new Object[0]))) {
            performSave = true;
        }
        if (performSave) {
            controller.saveAs(name);
            switch (CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getGameType()) {
                case Brawl: {
                    CBrawlDecks.SINGLETON_INSTANCE.refresh();
                    VBrawlDecks.SINGLETON_INSTANCE.getLstDecks().setSelectedString(deckStr);
                    break;
                }
                case Commander: {
                    CCommanderDecks.SINGLETON_INSTANCE.refresh();
                    VCommanderDecks.SINGLETON_INSTANCE.getLstDecks().setSelectedString(deckStr);
                    break;
                }
                case TinyLeaders: {
                    CTinyLeadersDecks.SINGLETON_INSTANCE.refresh();
                    VTinyLeadersDecks.SINGLETON_INSTANCE.getLstDecks().setSelectedString(deckStr);
                    break;
                }
                case Oathbreaker: {
                    COathbreakerDecks.SINGLETON_INSTANCE.refresh();
                    VOathbreakerDecks.SINGLETON_INSTANCE.getLstDecks().setSelectedString(deckStr);
                    break;
                }
                default: {
                    CAllDecks.SINGLETON_INSTANCE.refresh();
                    VAllDecks.SINGLETON_INSTANCE.getLstDecks().setSelectedString(deckStr);
                }
            }
            if (Singletons.getControl().getCurrentScreen() == FScreen.DECK_EDITOR_QUEST) {
                FModel.getQuest().setCurrentDeck(name);
            }
        }
        if (Singletons.getControl().getCurrentScreen() == FScreen.DECK_EDITOR_CONSTRUCTED) {
            DeckPreferences.setCurrentDeck(deckStr);
        }
        return performSave;
    }

    public static boolean confirmSaveChanges(FScreen screen, boolean isClosing) {
        if (CDeckEditorUI.SINGLETON_INSTANCE.hasChanges()) {
            if (!Singletons.getControl().ensureScreenActive(screen)) {
                return false;
            }
            int choice = FOptionPane.showOptionDialog(Localizer.getInstance().getMessage("lblSaveChangesCurrentDeck", new Object[0]), Localizer.getInstance().getMessage("lblSaveChangesConfirm", new Object[0]), FOptionPane.QUESTION_ICON, confirmSaveOptions);
            if (choice == -1 || choice == 2) {
                return false;
            }
            if (choice == 0 && !SEditorIO.saveDeck()) {
                return false;
            }
            if (!isClosing) {
                CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().reload();
            }
        }
        return true;
    }
}

