/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor;

import forge.ImageCache;
import forge.Singletons;
import forge.StaticData;
import forge.card.CardEdition;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckImportController;
import forge.deck.DeckRecognizer;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gui.CardPicturePanel;
import forge.item.PaperCard;
import forge.screens.deckeditor.GameFormatComboListener;
import forge.screens.deckeditor.GameFormatDropdownRenderer;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CStatisticsImporter;
import forge.screens.deckeditor.views.VStatisticsImporter;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FHtmlViewer;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class DeckImport<TModel extends DeckBase>
extends FDialog {
    private static final long serialVersionUID = -5837776824284093004L;
    private final FTextArea txtInput = new FTextArea();
    public static final String OK_CARD_IMPORT_COLOUR = "#89DC9F;";
    public static final String WARN_MSG_COLOUR = "#FEC700;";
    public static final String KO_CARD_NO_IMPORT_COLOUR = "#FF977A;";
    public static final String OK_IMPORT_CLASS = "ok_import";
    public static final String WARN_MSG_CLASS = "warn_msg";
    public static final String KO_NOIMPORT_CLASS = "ko_noimport";
    public static final String COMMENT_CLASS = "comment";
    public static final String DECKNAME_CLASS = "deckname";
    public static final String SECTION_CLASS = "section";
    public static final String CARDTYPE_CLASS = "cardtype";
    public static final String CMC_CLASS = "cmc";
    public static final String RARITY_CLASS = "rarity";
    private static final String STYLESHEET = String.format("<style>body, h1, h2, h3, a {font-weight: normal; line-height: 1.8px;  font-family: Arial; font-size: 10px;} tr, td { padding: 0px 1px; margin: 0px !important; } h3 {font-size: 13px; margin: 2px 0; padding: 0px 5px; font-weight: bold;} ul {margin: 5px; padding: 2px; font-size: 8px; } ul li {font-size: 10px;} code {font-size: 9px;} div {margin: 0; text-align: justify; padding: 1px 0 1px 8px; line-height: 1.8px;} a:hover { text-decoration: none !important;} a:link { text-decoration: none !important;} a { text-decoration: none !important;} a:active { text-decoration: none !important;} table {margin: 5px 0;} .bullet {color: #FEC700;} .%s {color: %s !important; font-weight: bold;} .%s {color: %s !important; font-weight: bold;} .%s {color: %s !important; font-weight: bold;} .%s {font-style: italic} .%s {background-color: #332200; color: #ffffff; } .%s {font-weight: bold; background-color: #DDDDDD; color: #000000;} .%s {font-weight: bold; background-color: #FFCC66; color: #000000;} .%s {font-weight: bold; background-color: #CCCCCC; color: #000000;} .%s {font-weight: bold; background-color: #F1B27E; color: #000000;}</style>", "ok_import", "#89DC9F;", "warn_msg", "#FEC700;", "ko_noimport", "#FF977A;", "comment", "deckname", "section", "cardtype", "cmc", "rarity");
    private static final String COLOUR_CODED_TAGS = String.format("<ul><li> <span class=\"%s\">%s</span></li><li> <span class=\"%s\">%s</span></li><li> <span class=\"%s\">%s</span></li></ul>", "ok_import", Localizer.getInstance().getMessage("lblGuideImportCard", new Object[0]), "warn_msg", Localizer.getInstance().getMessage("lblGuideWarnMessage", new Object[0]), "ko_noimport", Localizer.getInstance().getMessage("lblGuideNoImportCard", new Object[0]));
    private static final String TIPS_LIST = String.format("<p>%s</p> <p>%s</p> <p>%s</p> <p>%s</p> <p>%s</p> <p>%s</p> <p>%s</p>", Localizer.getInstance().getMessage("lblGuideTipsCount", String.format("<span class=\"bullet\">(A) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleCount", new Object[0])), String.format("<code>%s</code>", "\"4 Giant Growth\""), String.format("<code>%s</code>", "\"4x Giant Growth\"")), Localizer.getInstance().getMessage("lblGuideTipsSet", String.format("<span class=\"bullet\">(B) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleSet", new Object[0]))), Localizer.getInstance().getMessage("lblGuideTipsFoil", String.format("<span class=\"bullet\">(C) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleFoil", new Object[0])), String.format("<code>%s</code>", "Forest+"), "<code>(F)</code>"), Localizer.getInstance().getMessage("lblGuideTipsPlaceholder", String.format("<span class=\"bullet\">(D) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitlePlaceholder", new Object[0])), "<code>Lands, Creatures, Artifacts</code>", "<code>Common, Uncommon, Rare, Mythic, Special</code>", "<code>CMC0, CC1</code>", "<code>Black, White|Green, Red Blue, Multicolor, Colorless</code>"), Localizer.getInstance().getMessage("lblGuideTipsDeckSection", String.format("<span class=\"bullet\">(E) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleDeckSections", new Object[0])), "<code>Main, Sideboard, Commander</code>", "<code>Main</code>"), Localizer.getInstance().getMessage("lblGuideTipsDeckName", String.format("<span class=\"bullet\">(F) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleDeckName", new Object[0]))), Localizer.getInstance().getMessage("lblGuideTipsDeckFormats", String.format("<span class=\"bullet\">(G) %s</span>", Localizer.getInstance().getMessage("lblGuideTipsTitleDeckFormat", new Object[0]))));
    private static final String EXAMPLES_LIST = String.format("<p><code class=\"bullet\">%s</code>: %s</p><p><code class=\"bullet\">%s</code>: %s</p><p><code class=\"bullet\">%s</code>: %s</p><p><code class=\"bullet\">%s</code>: %s</p><p><code class=\"bullet\">%s</code>: %s</p>", Localizer.getInstance().getMessage("lblExample1", new Object[0]), Localizer.getInstance().getMessage("nlExample1", new Object[0]), Localizer.getInstance().getMessage("lblExample2", new Object[0]), Localizer.getInstance().getMessage("nlExample2", new Object[0]), Localizer.getInstance().getMessage("lblExample3", new Object[0]), Localizer.getInstance().getMessage("nlExample3", new Object[0]), Localizer.getInstance().getMessage("lblExample4", new Object[0]), Localizer.getInstance().getMessage("nlExample4", new Object[0]), Localizer.getInstance().getMessage("lblExample5", new Object[0]), Localizer.getInstance().getMessage("nlExample5", new Object[0]));
    private static final String HTML_WELCOME_TEXT = String.format("<head>" + STYLESHEET + "</head><body><h3>%s</h3><div>%s</div> <h3>%s</h3><div>%s</div> <br> <h3>%s</h3><div>%s</div> <br></body>", Localizer.getInstance().getMessage("nlGuideTitle", new Object[0]), Localizer.getInstance().getMessage("nlGuideQuickInstructions", COLOUR_CODED_TAGS), Localizer.getInstance().getMessage("nlGuideTipsTitle", new Object[0]), Localizer.getInstance().getMessage("nlGuideTipsText", TIPS_LIST), Localizer.getInstance().getMessage("nlGuideExamplesTitle", new Object[0]), EXAMPLES_LIST);
    private static final int PADDING_TOKEN_MSG_LENGTH = 45;
    private final FHtmlViewer htmlOutput = new FHtmlViewer();
    private final FScrollPane scrollInput = new FScrollPane(this.txtInput, false);
    private final FScrollPane scrollOutput = new FScrollPane(this.htmlOutput, false);
    private final CardPicturePanel cardImagePreview = new CardPicturePanel();
    private final FLabel cardPreviewLabel = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblCardPreview", new Object[0])).fontSize(14).tooltip("").build();
    private final FButton cmdCancelButton = new FButton(Localizer.getInstance().getMessage("lblCancel", new Object[0]));
    private final FButton cmdAcceptButton;
    private final FCheckBox createNewDeckCheckbox = new FCheckBox(Localizer.getInstance().getMessage("lblNewDeckCheckbox", new Object[0]), false);
    private final FCheckBox dateTimeCheck = new FCheckBox(Localizer.getInstance().getMessage("lblUseOnlySetsReleasedBefore", new Object[0]), false);
    private final FComboBox<String> monthDropdown = new FComboBox();
    private final FComboBox<Integer> yearDropdown = new FComboBox();
    private final FLabel cardArtPrefsLabel = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblPreferredArt", new Object[0])).fontSize(14).tooltip(Localizer.getInstance().getMessage("nlPreferredArt", new Object[0])).build();
    private FComboBox<String> cardArtPrefsComboBox;
    private final FCheckBox cardArtPrefHasFilterCheckBox = new FCheckBox(Localizer.getInstance().getMessage("lblPrefArtExpansionOnly", new Object[0]), false);
    private final FCheckBox smartCardArtCheckBox = new FCheckBox(Localizer.getInstance().getMessage("lblUseSmartCardArt", new Object[0]), false);
    private final FCheckBox includeBnRCheck = new FCheckBox(Localizer.getInstance().getMessage("lblIgnoreBnR", new Object[0]), false);
    private final FCheckBox formatSelectionCheck = new FCheckBox(Localizer.getInstance().getMessage("lblUseFormatFilter", new Object[0]), false);
    private final FComboBox<GameFormat> formatDropdown = new FComboBox();
    private final DeckImportController controller;
    private final CDeckEditor<TModel> host;
    private final String IMPORT_CARDS_CMD_LABEL = Localizer.getInstance().getMessage("lblImportCardsCmd", new Object[0]);
    private final String CREATE_NEW_DECK_CMD_LABEL = Localizer.getInstance().getMessage("lblCreateNewCmd", new Object[0]);
    private final String SMART_CARDART_TT_NO_DECK = Localizer.getInstance().getMessage("ttUseSmartCardArtNoDeck", new Object[0]);
    private final String SMART_CARDART_TT_WITH_DECK = Localizer.getInstance().getMessage("ttUseSmartCardArtWithDeck", new Object[0]);
    private final String currentGameType;
    private final VStatisticsImporter statsView;
    private final CStatisticsImporter cStatsView;

    public DeckImport(CDeckEditor<TModel> g2) {
        this.host = g2;
        boolean currentDeckIsNotEmpty = !g2.getDeckController().isEmpty();
        GameType currentGameType = g2.getGameType();
        this.controller = new DeckImportController(this.dateTimeCheck, this.monthDropdown, this.yearDropdown, currentDeckIsNotEmpty);
        this.controller.setGameFormat(currentGameType);
        if (currentDeckIsNotEmpty) {
            this.controller.setCurrentDeckInEditor(this.host.getDeckController().getCurrentDeckInEditor());
        }
        ArrayList<DeckSection> supportedSections = new ArrayList<DeckSection>();
        for (DeckSection section : EnumSet.allOf(DeckSection.class)) {
            if (!this.host.isSectionImportable(section).booleanValue()) continue;
            supportedSections.add(section);
        }
        this.currentGameType = currentGameType.name();
        this.controller.setAllowedSections(supportedSections);
        String cmdBtnLabel = currentDeckIsNotEmpty ? this.IMPORT_CARDS_CMD_LABEL : this.CREATE_NEW_DECK_CMD_LABEL;
        this.cmdAcceptButton = new FButton(cmdBtnLabel);
        this.statsView = new VStatisticsImporter(this.controller.currentGameFormatAllowsCommander());
        this.cStatsView = new CStatisticsImporter(this.statsView);
        this.initUIComponents(g2, currentDeckIsNotEmpty);
    }

    private void initUIComponents(CDeckEditor<TModel> g2, boolean currentDeckIsNotEmpty) {
        int wWidth = (int)((double)Singletons.getView().getFrame().getSize().width * 0.95);
        int wHeight = (int)((double)Singletons.getView().getFrame().getSize().height * 0.9);
        this.setPreferredSize(new Dimension(wWidth, wHeight));
        this.setSize(wWidth, wHeight);
        this.setTitle(Localizer.getInstance().getMessage("lblDeckImporterPanelTitle", this.currentGameType));
        this.txtInput.setFocusable(true);
        this.txtInput.setEditable(true);
        this.showInstructions();
        FSkin.SkinColor foreColor = FSkin.getColor(FSkin.Colors.CLR_TEXT);
        this.scrollInput.setBorder(new FSkin.TitledSkinBorder(BorderFactory.createEtchedBorder(), Localizer.getInstance().getMessage("lblCardListTitle", new Object[0]), foreColor));
        this.scrollInput.setViewportBorder(BorderFactory.createLoweredBevelBorder());
        this.txtInput.getDocument().addDocumentListener(new OnChangeTextUpdate());
        this.scrollOutput.setBorder(new FSkin.TitledSkinBorder(BorderFactory.createEtchedBorder(), Localizer.getInstance().getMessage("lblDecklistTitle", new Object[0]), foreColor));
        this.scrollOutput.setViewportBorder(BorderFactory.createLoweredBevelBorder());
        this.htmlOutput.addHyperlinkListener(this::activateCardPreview);
        FPanel statsPanel = new FPanel(new BorderLayout());
        statsPanel.add((Component)this.statsView.getMainPanel(), "Center");
        statsPanel.setOpaque(false);
        this.cardImagePreview.setOpaque(false);
        this.cardImagePreview.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.cardImagePreview.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT).getColor());
        this.resetCardImagePreviewPanel();
        FPanel cardPreview = new FPanel(new MigLayout("fill"));
        cardPreview.add((Component)this.cardPreviewLabel, "cell 0 0, align left, w 100%");
        cardPreview.add((Component)this.cardImagePreview, "cell 0 1, w 70%, h 60%, growy, pushy, ax c");
        final JPanel closedOptsPanel = new JPanel(new MigLayout("insets 10, gap 5, left, w 100%"));
        closedOptsPanel.setVisible(true);
        closedOptsPanel.setOpaque(false);
        TitledBorder showOptsBorder = new TitledBorder(BorderFactory.createEtchedBorder(), String.format("\u25b6 %s", Localizer.getInstance().getMessage("lblExtraOptions", new Object[0])));
        showOptsBorder.setTitleColor(foreColor.getColor());
        closedOptsPanel.setBorder(showOptsBorder);
        closedOptsPanel.add((Component)new JSeparator(0), "w 100%, hidemode 2");
        final JPanel optionsPanel = new JPanel(new MigLayout("insets 10, gap 5, left, h 150!"));
        TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(), String.format("\u25bc %s", Localizer.getInstance().getMessage("lblHideOptions", new Object[0])));
        border.setTitleColor(foreColor.getColor());
        optionsPanel.setBorder(border);
        optionsPanel.setVisible(false);
        optionsPanel.setOpaque(false);
        closedOptsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                optionsPanel.setVisible(true);
                closedOptsPanel.setVisible(false);
            }
        });
        optionsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                optionsPanel.setVisible(false);
                closedOptsPanel.setVisible(true);
            }
        });
        String optPanelsConstrains = "w 130!, h 135!, left, insets 0";
        this.monthDropdown.setEnabled(false);
        this.yearDropdown.setEnabled(false);
        this.dateTimeCheck.setToolTipText(Localizer.getInstance().getMessage("ttUseOnlySetsReleasedBefore", new Object[0]));
        FSkin.SkinnedLabel dateFilterInfoLabel = new FSkin.SkinnedLabel(Localizer.getInstance().getMessage("nlUseOnlySetsReleasedBefore", new Object[0]));
        dateFilterInfoLabel.setFont(FSkin.getItalicFont());
        dateFilterInfoLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        JPanel dateFilterPanel = new JPanel(new MigLayout(optPanelsConstrains));
        dateFilterPanel.setOpaque(false);
        dateFilterPanel.add((Component)this.dateTimeCheck, "cell 0 0, w 90%!, ax left");
        dateFilterPanel.add(this.monthDropdown, "cell 0 1, w 10%, ax left, split 2, pad 0 2 0 0");
        dateFilterPanel.add(this.yearDropdown, "cell 0 1, w 8%, ax left, split 2");
        dateFilterPanel.add((Component)dateFilterInfoLabel, "cell 0 2, w 80%!, h 22px!, ax left, wrap");
        this.dateTimeCheck.addActionListener(e -> {
            boolean isSel = this.dateTimeCheck.isSelected();
            this.monthDropdown.setEnabled(isSel);
            this.yearDropdown.setEnabled(isSel);
            this.parseAndDisplay();
        });
        ActionListener reparseAction = e -> this.parseAndDisplay();
        this.yearDropdown.addActionListener(reparseAction);
        this.monthDropdown.addActionListener(reparseAction);
        optionsPanel.add((Component)dateFilterPanel, "cell 0 0, w 90%, left");
        String latestOpt = Localizer.getInstance().getMessage("latestArtOpt", new Object[0]);
        String originalOpt = Localizer.getInstance().getMessage("originalArtOpt", new Object[0]);
        String[] choices = new String[]{latestOpt, originalOpt};
        this.cardArtPrefsComboBox = new FComboBox<String>(choices);
        String selectedItem = StaticData.instance().cardArtPreferenceIsLatest() ? latestOpt : originalOpt;
        this.cardArtPrefsComboBox.setSelectedItem((Object)selectedItem);
        this.cardArtPrefsComboBox.setToolTipText(Localizer.getInstance().getMessage("nlPreferredArt", new Object[0]));
        FSkin.SkinnedLabel formatArtInfoLabel = new FSkin.SkinnedLabel(Localizer.getInstance().getMessage("nlCardArtPreferenceWithFormat", new Object[0]));
        formatArtInfoLabel.setFont(FSkin.getItalicFont());
        formatArtInfoLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        FSkin.SkinnedLabel artPrefInfoLabel = new FSkin.SkinnedLabel(Localizer.getInstance().getMessage("nlPreferredArt", new Object[0]));
        artPrefInfoLabel.setFont(FSkin.getItalicFont());
        artPrefInfoLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.smartCardArtCheckBox.setToolTipText(currentDeckIsNotEmpty ? this.SMART_CARDART_TT_WITH_DECK : this.SMART_CARDART_TT_NO_DECK);
        this.smartCardArtCheckBox.setSelected(StaticData.instance().isEnabledCardArtSmartSelection());
        this.cardArtPrefHasFilterCheckBox.setSelected(StaticData.instance().isCoreExpansionOnlyFilterSet());
        this.cardArtPrefHasFilterCheckBox.setToolTipText(Localizer.getInstance().getMessage("nlPrefArtExpansionOnly", new Object[0]));
        JPanel cardArtPanel = new JPanel(new MigLayout(optPanelsConstrains));
        cardArtPanel.setOpaque(false);
        if (this.controller.hasNoDefaultGameFormat()) {
            cardArtPanel.add((Component)this.cardArtPrefsLabel, "cell 0 0, w 25%, left, split 2");
            cardArtPanel.add(this.cardArtPrefsComboBox, "cell 0 0, w 10%, left, split 2");
            cardArtPanel.add((Component)formatArtInfoLabel, "cell 0 1, w 85%, center");
            cardArtPanel.add((Component)this.cardArtPrefHasFilterCheckBox, "cell 0 2, w 15%, left, gaptop 5");
            cardArtPanel.add((Component)this.smartCardArtCheckBox, "cell 0 3, w 15%, left, gaptop 5");
            cardArtPanel.add((Component)artPrefInfoLabel, "cell 0 4, w 90%, left");
        } else {
            cardArtPanel.add((Component)this.cardArtPrefsLabel, "cell 0 0, w 25%, left, split 2");
            cardArtPanel.add(this.cardArtPrefsComboBox, "cell 0 0, w 10%, left, split 2");
            cardArtPanel.add((Component)this.cardArtPrefHasFilterCheckBox, "cell 0 1, w 15%, left, gaptop 5");
            cardArtPanel.add((Component)this.smartCardArtCheckBox, "cell 0 2, w 15%, left, gaptop 5");
            cardArtPanel.add((Component)artPrefInfoLabel, "cell 0 3, w 90%, left");
        }
        ItemListener updateCardArtPreference = e -> {
            String artPreference = this.cardArtPrefsComboBox.getSelectedItem();
            if (artPreference == null) {
                artPreference = latestOpt;
            }
            boolean latestArt = artPreference.equalsIgnoreCase(latestOpt);
            boolean coreExpFilter = this.cardArtPrefHasFilterCheckBox.isSelected();
            this.controller.setCardArtPreference(latestArt, coreExpFilter);
            this.parseAndDisplay();
        };
        this.cardArtPrefsComboBox.addItemListener(updateCardArtPreference);
        this.cardArtPrefHasFilterCheckBox.addItemListener(updateCardArtPreference);
        this.smartCardArtCheckBox.addActionListener(e -> {
            boolean enableSmartCardArt = this.smartCardArtCheckBox.isSelected();
            this.controller.setSmartCardArtOptimisation(enableSmartCardArt);
            this.parseAndDisplay();
        });
        optionsPanel.add((Component)cardArtPanel, "cell 1 0, w 100%, left");
        this.formatDropdown.setEnabled(false);
        this.includeBnRCheck.setToolTipText(Localizer.getInstance().getMessage("ttIgnoreBnR", new Object[0]));
        FSkin.SkinnedLabel bnrInfoLabel = new FSkin.SkinnedLabel(Localizer.getInstance().getMessage("nlIgnoreBnR", new Object[0]));
        bnrInfoLabel.setFont(FSkin.getItalicFont());
        bnrInfoLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        JPanel blockFilterPanel = new JPanel(new MigLayout(optPanelsConstrains));
        blockFilterPanel.setOpaque(false);
        if (this.controller.hasNoDefaultGameFormat()) {
            this.controller.fillFormatDropdown(this.formatDropdown);
            this.formatDropdown.setRenderer(new GameFormatDropdownRenderer());
            this.formatDropdown.setSelectedIndex(0);
            this.formatDropdown.addActionListener(new GameFormatComboListener(this.formatDropdown));
            blockFilterPanel.add((Component)this.formatSelectionCheck, "cell 0 0, w 55%, ax left");
            blockFilterPanel.add(this.formatDropdown, "cell 0 1, w 15%, ax left");
            blockFilterPanel.add((Component)this.includeBnRCheck, "cell 0 2, w 45%, ax left, gaptop 5");
            blockFilterPanel.add((Component)bnrInfoLabel, "cell 0 3, left, w 90%");
        } else {
            blockFilterPanel.add((Component)this.includeBnRCheck, "cell 0 0, w 45%, ax left");
            blockFilterPanel.add((Component)bnrInfoLabel, "cell 0 1, left, w 90%");
        }
        optionsPanel.add((Component)blockFilterPanel, "cell 2 0, w 100%, left");
        if (this.controller.hasNoDefaultGameFormat()) {
            ActionListener updateFormatSelectionCheck = e -> {
                boolean isSel = this.formatSelectionCheck.isSelected();
                this.formatDropdown.setEnabled(isSel);
                if (!isSel) {
                    this.controller.setCurrentGameFormat(null);
                } else {
                    GameFormat gameFormat = this.formatDropdown.getSelectedItem();
                    this.controller.setCurrentGameFormat(gameFormat);
                }
                this.parseAndDisplay();
            };
            this.formatSelectionCheck.addActionListener(updateFormatSelectionCheck);
            this.formatDropdown.addActionListener(updateFormatSelectionCheck);
        }
        this.includeBnRCheck.addActionListener(e -> {
            boolean includeBnR = this.includeBnRCheck.isSelected();
            this.controller.importBannedAndRestrictedCards(includeBnR);
            this.parseAndDisplay();
        });
        JPanel cmdPanel = new JPanel(new MigLayout("insets 10, gap 5, right, h 40!"));
        cmdPanel.setOpaque(false);
        this.cmdAcceptButton.setEnabled(false);
        if (currentDeckIsNotEmpty) {
            cmdPanel.add((Component)this.createNewDeckCheckbox, "align l, split 3");
            cmdPanel.add((Component)this.cmdAcceptButton, "w 150!, align r, h 26!, split 3");
            cmdPanel.add((Component)this.cmdCancelButton, "w 150!, align r, h 26!, split 3");
        } else {
            cmdPanel.add((Component)this.cmdAcceptButton, "w 150!, align r, h 26!, split 2");
            cmdPanel.add((Component)this.cmdCancelButton, "w 150!, align r, h 26!, split 2");
        }
        this.cmdCancelButton.addActionListener(e -> this.processWindowEvent(new WindowEvent(this, 201)));
        this.cmdAcceptButton.addActionListener(e -> {
            String currentDeckName = g2.getDeckController().getModelName();
            Deck deck = this.controller.accept(currentDeckName);
            if (deck == null) {
                return;
            }
            if (!deck.hasName()) {
                if (currentDeckName.isEmpty()) {
                    deck.setName(Localizer.getInstance().getMessage("lblNewDeckName", new Object[0]));
                } else {
                    deck.setName(currentDeckName);
                }
            }
            this.host.getDeckController().loadDeck(deck, this.controller.getCreateNewDeck());
            this.processWindowEvent(new WindowEvent(this, 201));
        });
        if (currentDeckIsNotEmpty) {
            this.createNewDeckCheckbox.setSelected(false);
            this.createNewDeckCheckbox.addActionListener(e -> {
                boolean createNewDeck = this.createNewDeckCheckbox.isSelected();
                this.controller.setCreateNewDeck(createNewDeck);
                String cmdAcceptLabel = createNewDeck ? this.CREATE_NEW_DECK_CMD_LABEL : this.IMPORT_CARDS_CMD_LABEL;
                this.cmdAcceptButton.setText(cmdAcceptLabel);
                String smartCardArtChboxTooltip = createNewDeck ? this.SMART_CARDART_TT_NO_DECK : this.SMART_CARDART_TT_WITH_DECK;
                this.smartCardArtCheckBox.setToolTipText(smartCardArtChboxTooltip);
                this.parseAndDisplay();
            });
        }
        this.add((Component)this.scrollInput, "cell 0 0, w 40%, growy, pushy, spany 2");
        this.add((Component)this.scrollOutput, "cell 1 0, w 60%, growy, pushy, spany 2");
        this.add((Component)statsPanel, "cell 2 0, w 480:510:550, growy, pushy, ax c");
        this.add((Component)cardPreview, "cell 2 1, w 480:510:550, h 65%, growy, pushy, ax c");
        this.add((Component)closedOptsPanel, "cell 0 2, left, w 100%, h 25!, spanx 3, hidemode 3");
        this.add((Component)optionsPanel, "cell 0 2, left, w 100%, spanx 3, hidemode 3");
        this.add((Component)cmdPanel, "cell 0 3, w 100%, spanx 3");
    }

    private void activateCardPreview(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED || e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String keyString = e.getDescription();
            DeckRecognizer.Token.TokenKey tokenKey = DeckRecognizer.Token.TokenKey.fromString(keyString);
            if (tokenKey == null) {
                return;
            }
            PaperCard card = StaticData.instance().fetchCard(tokenKey.cardName, tokenKey.setCode, tokenKey.collectorNumber);
            if (card != null) {
                DeckRecognizer.Token mockToken = this.createMockTokenFromTokenKey(card, tokenKey);
                this.setupCardImagePreviewPanel(card, mockToken);
            }
        }
    }

    private DeckRecognizer.Token createMockTokenFromTokenKey(PaperCard card, DeckRecognizer.Token.TokenKey tokenKey) {
        DeckRecognizer.Token mockToken;
        switch (tokenKey.tokenType) {
            case CARD_FROM_INVALID_SET: {
                mockToken = DeckRecognizer.Token.CardInInvalidSet(card, 0, true);
                break;
            }
            case CARD_FROM_NOT_ALLOWED_SET: {
                mockToken = DeckRecognizer.Token.NotAllowedCard(card, 0, true);
                break;
            }
            case LIMITED_CARD: {
                mockToken = DeckRecognizer.Token.LimitedCard(card, 0, tokenKey.deckSection, tokenKey.limitedType, true);
                break;
            }
            case LEGAL_CARD: {
                mockToken = DeckRecognizer.Token.LegalCard(card, 0, tokenKey.deckSection, true);
                break;
            }
            default: {
                mockToken = null;
            }
        }
        return mockToken;
    }

    private void setupCardImagePreviewPanel(PaperCard card, DeckRecognizer.Token token) {
        CardEdition edition;
        StaticData data = StaticData.instance();
        StringBuilder statusLbl = new StringBuilder();
        if (token != null && token.isCardToken()) {
            String cssClass = this.getTokenCSSClass(token.getType());
            if (token.getType() == DeckRecognizer.TokenType.LIMITED_CARD) {
                cssClass = WARN_MSG_CLASS;
            }
            String statusMsg = String.format("<span class=\"%s\" style=\"font-size: 9px;\">%s</span>", cssClass, this.getTokenStatusMessage(token));
            statusLbl.append(statusMsg);
        }
        String editionName = (edition = data.getCardEdition(card.getEdition())) != null ? String.format("%s ", edition.getName()) : "";
        StringBuilder editionLbl = new StringBuilder("<span style=\"font-size: 9px;\">");
        editionLbl.append(String.format("<b>%s</b>: \"%s\" (<code>%s</code>) - Collector Nr. %s", Localizer.getInstance().getMessage("lblSet", new Object[0]), editionName, card.getEdition(), card.getCollectorNumber()));
        if (token.getType() == DeckRecognizer.TokenType.LEGAL_CARD || token.getType() == DeckRecognizer.TokenType.LIMITED_CARD && this.controller.importBannedAndRestrictedCards()) {
            editionLbl.append(String.format(" - <b class=\"%s\">%s: %s</b>", new Object[]{OK_IMPORT_CLASS, Localizer.getInstance().getMessage("lblDeckSection", new Object[0]), token.getTokenSection()}));
        }
        editionLbl.append("</span>");
        this.cardImagePreview.setItem(card);
        if (token.getType() == DeckRecognizer.TokenType.LEGAL_CARD || token.getType() == DeckRecognizer.TokenType.LIMITED_CARD && this.controller.importBannedAndRestrictedCards()) {
            this.cardImagePreview.showAsEnabled();
        } else {
            this.cardImagePreview.showAsDisabled();
        }
        this.cardPreviewLabel.setText(String.format("<html>%s %s<br>%s</html>", STYLESHEET, editionLbl, statusLbl));
        String tooltip = String.format("%s [%s] #%s", card.getName(), card.getEdition(), card.getCollectorNumber());
        this.cardImagePreview.setToolTipText(tooltip);
    }

    private void resetCardImagePreviewPanel() {
        this.cardPreviewLabel.setText(Localizer.getInstance().getMessage("lblCardPreview", new Object[0]));
        this.cardImagePreview.setItem(ImageCache.getDefaultImage());
        this.cardImagePreview.showAsEnabled();
    }

    private void parseAndDisplay() {
        List<DeckRecognizer.Token> tokens = this.controller.parseInput(this.txtInput.getText());
        if (this.controller.isSmartCardArtEnabled()) {
            tokens = this.controller.optimiseCardArtInTokens();
        }
        this.displayTokens(tokens);
        this.updateSummaries(tokens);
    }

    private void displayTokens(List<DeckRecognizer.Token> tokens) {
        if (tokens.isEmpty() || this.hasOnlyComment(tokens)) {
            this.showInstructions();
            this.resetCardImagePreviewPanel();
        } else {
            StringBuilder sbOut = new StringBuilder();
            sbOut.append(String.format("<head>%s</head>", STYLESHEET));
            sbOut.append(String.format("<body><h3>%s</h3>", Localizer.getInstance().getMessage("lblCurrentDecklist", new Object[0])));
            sbOut.append("<table>");
            for (DeckRecognizer.Token t2 : tokens) {
                sbOut.append(this.toHTML(t2));
            }
            sbOut.append("</table>");
            this.htmlOutput.setText(FSkin.encodeSymbols(sbOut.toString(), false));
        }
    }

    private void showInstructions() {
        this.htmlOutput.setText(FSkin.encodeSymbols(HTML_WELCOME_TEXT, false));
    }

    private boolean hasOnlyComment(List<DeckRecognizer.Token> tokens) {
        for (DeckRecognizer.Token token : tokens) {
            if (token.getType() == DeckRecognizer.TokenType.COMMENT || token.getType() == DeckRecognizer.TokenType.UNKNOWN_TEXT) continue;
            return false;
        }
        return true;
    }

    private void updateSummaries(List<DeckRecognizer.Token> tokens) {
        this.cStatsView.updateStats(tokens, this.controller.importBannedAndRestrictedCards());
        this.cmdAcceptButton.setEnabled(this.cStatsView.getTotalCardsInDecklist() > 0);
        Object displayedCardInPanel = this.cardImagePreview.getDisplayed();
        if (!(displayedCardInPanel instanceof PaperCard)) {
            this.resetCardImagePreviewPanel();
        } else {
            PaperCard cardDisplayed = (PaperCard)displayedCardInPanel;
            PaperCard cardFromDecklist = this.controller.getCardFromDecklist(cardDisplayed);
            if (cardFromDecklist == null) {
                cardFromDecklist = this.controller.getCardFromDecklistByName(cardDisplayed.getName());
                if (cardFromDecklist == null) {
                    this.resetCardImagePreviewPanel();
                } else {
                    DeckRecognizer.Token cardToken = this.controller.getTokenFromCardInDecklist(cardFromDecklist);
                    this.setupCardImagePreviewPanel(cardFromDecklist, cardToken);
                }
            } else {
                DeckRecognizer.Token cardToken = this.controller.getTokenFromCardInDecklist(cardFromDecklist);
                this.setupCardImagePreviewPanel(cardFromDecklist, cardToken);
            }
        }
    }

    private String toHTML(DeckRecognizer.Token token) {
        if (token == null) {
            return "";
        }
        String tokenMsg = this.getTokenMessage(token);
        if (tokenMsg == null) {
            return "";
        }
        String tokenStatus = this.getTokenStatusMessage(token);
        String cssClass = this.getTokenCSSClass(token.getType());
        if (tokenStatus.length() == 0) {
            tokenMsg = DeckImport.padEndWithHTMLSpaces(tokenMsg, 100);
        } else {
            tokenMsg = DeckImport.padEndWithHTMLSpaces(tokenMsg, 45);
            tokenStatus = DeckImport.padEndWithHTMLSpaces(tokenStatus, 45);
        }
        if (token.isCardToken()) {
            tokenMsg = String.format("<a class=\"%s\" href=\"%s\">%s</a>", cssClass, token.getKey().toString(), tokenMsg);
        }
        if (tokenStatus == null) {
            String tokenTag = String.format("<td colspan=\"2\" class=\"%s\">%s</td>", cssClass, tokenMsg);
            return String.format("<tr>%s</tr>", tokenTag);
        }
        String tokenTag = "<td class=\"%s\">%s</td>";
        String tokenMsgTag = String.format(tokenTag, cssClass, tokenMsg);
        if (token.getType() == DeckRecognizer.TokenType.LIMITED_CARD) {
            cssClass = WARN_MSG_CLASS;
        }
        String tokenStatusTag = String.format(tokenTag, cssClass, tokenStatus);
        return String.format("<tr>%s %s</tr>", tokenMsgTag, tokenStatusTag);
    }

    private static String padEndWithHTMLSpaces(String targetMsg, int limit) {
        StringBuilder spacer = new StringBuilder();
        for (int i = targetMsg.length(); i < limit; ++i) {
            spacer.append("&nbsp;");
        }
        return String.format("%s%s", targetMsg, spacer);
    }

    private String getTokenMessage(DeckRecognizer.Token token) {
        switch (token.getType()) {
            case CARD_FROM_INVALID_SET: 
            case CARD_FROM_NOT_ALLOWED_SET: 
            case LIMITED_CARD: 
            case LEGAL_CARD: {
                return String.format("%s x %s %s", token.getQuantity(), token.getText(), this.getTokenFoilLabel(token));
            }
            case UNKNOWN_CARD: 
            case UNSUPPORTED_CARD: {
                return token.getQuantity() > 0 ? String.format("%s x %s", token.getQuantity(), token.getText()) : token.getText();
            }
            case UNSUPPORTED_DECK_SECTION: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblWarningMsgPrefix", new Object[0]), Localizer.getInstance().getMessage("lblWarnDeckSectionNotAllowedInEditor", token.getText(), this.currentGameType));
            }
            case WARNING_MESSAGE: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblWarningMsgPrefix", new Object[0]), token.getText());
            }
            case DECK_SECTION_NAME: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblDeckSection", new Object[0]), token.getText());
            }
            case CARD_RARITY: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblRarity", new Object[0]), token.getText());
            }
            case CARD_TYPE: 
            case CARD_CMC: 
            case MANA_COLOUR: 
            case COMMENT: {
                return token.getText();
            }
            case DECK_NAME: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblDeckName", new Object[0]), token.getText());
            }
        }
        return null;
    }

    private String getTokenStatusMessage(DeckRecognizer.Token token) {
        if (token == null) {
            return "";
        }
        switch (token.getType()) {
            case LIMITED_CARD: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblWarningMsgPrefix", new Object[0]), Localizer.getInstance().getMessage("lblWarnLimitedCard", StringUtils.capitalize(token.getLimitedCardType().name()), this.getGameFormatLabel()));
            }
            case CARD_FROM_NOT_ALLOWED_SET: {
                return Localizer.getInstance().getMessage("lblErrNotAllowedCard", this.getGameFormatLabel());
            }
            case CARD_FROM_INVALID_SET: {
                return Localizer.getInstance().getMessage("lblErrCardEditionDate", new Object[0]);
            }
            case UNSUPPORTED_CARD: {
                return Localizer.getInstance().getMessage("lblErrUnsupportedCard", this.currentGameType);
            }
            case UNKNOWN_CARD: {
                return String.format("%s: %s", Localizer.getInstance().getMessage("lblWarningMsgPrefix", new Object[0]), Localizer.getInstance().getMessage("lblWarnUnknownCardMsg", new Object[0]));
            }
        }
        return "";
    }

    private String getTokenCSSClass(DeckRecognizer.TokenType tokenType) {
        switch (tokenType) {
            case LEGAL_CARD: {
                return OK_IMPORT_CLASS;
            }
            case LIMITED_CARD: {
                return this.controller.importBannedAndRestrictedCards() ? OK_IMPORT_CLASS : WARN_MSG_CLASS;
            }
            case CARD_FROM_INVALID_SET: 
            case CARD_FROM_NOT_ALLOWED_SET: 
            case UNSUPPORTED_CARD: {
                return KO_NOIMPORT_CLASS;
            }
            case UNKNOWN_CARD: 
            case UNSUPPORTED_DECK_SECTION: 
            case WARNING_MESSAGE: {
                return WARN_MSG_CLASS;
            }
            case COMMENT: {
                return COMMENT_CLASS;
            }
            case DECK_NAME: {
                return DECKNAME_CLASS;
            }
            case DECK_SECTION_NAME: {
                return SECTION_CLASS;
            }
            case CARD_TYPE: {
                return CARDTYPE_CLASS;
            }
            case CARD_RARITY: {
                return RARITY_CLASS;
            }
            case CARD_CMC: 
            case MANA_COLOUR: {
                return CMC_CLASS;
            }
        }
        return "";
    }

    private String getTokenFoilLabel(DeckRecognizer.Token token) {
        if (!token.isCardToken()) {
            return "";
        }
        String foilMarker = "- (Foil)";
        return token.getCard().isFoil() ? "- (Foil)" : "";
    }

    private String getGameFormatLabel() {
        return String.format("\"%s\"", this.controller.getCurrentGameFormatName());
    }

    protected class OnChangeTextUpdate
    implements DocumentListener {
        protected OnChangeTextUpdate() {
        }

        private void onChange() {
            DeckImport.this.parseAndDisplay();
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            this.onChange();
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            this.onChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

