/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor;

import forge.Singletons;
import forge.deck.DeckBase;
import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CEditorConstructed;
import forge.screens.deckeditor.controllers.CEditorQuestCardShop;
import forge.screens.deckeditor.controllers.CProbabilities;
import forge.screens.deckeditor.controllers.CStatistics;
import forge.screens.deckeditor.controllers.DeckController;
import forge.screens.deckeditor.views.VAllDecks;
import forge.screens.deckeditor.views.VBrawlDecks;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.deckeditor.views.VCommanderDecks;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.deckeditor.views.VEditorLog;
import forge.screens.deckeditor.views.VOathbreakerDecks;
import forge.screens.deckeditor.views.VTinyLeadersDecks;
import forge.screens.match.controllers.CDetailPicture;
import forge.util.ItemPool;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public enum CDeckEditorUI implements ICDoc
{
    SINGLETON_INSTANCE;

    private final HashMap<FScreen, ACEditorBase<? extends InventoryItem, ? extends DeckBase>> screenChildControllers = new HashMap();
    private ACEditorBase<? extends InventoryItem, ? extends DeckBase> childController;
    private final CDetailPicture cDetailPicture = new CDetailPicture();
    private final VAllDecks vAllDecks = VAllDecks.SINGLETON_INSTANCE;
    private final VCommanderDecks vCommanderDecks;
    private final VOathbreakerDecks vOathbreakerDecks;
    private final VBrawlDecks vBrawlDecks;
    private final VTinyLeadersDecks vTinyLeadersDecks;
    private final VEditorLog vEditorLog;

    private CDeckEditorUI() {
        this.vAllDecks.setCDetailPicture(this.cDetailPicture);
        this.vCommanderDecks = VCommanderDecks.SINGLETON_INSTANCE;
        this.vCommanderDecks.setCDetailPicture(this.cDetailPicture);
        this.vOathbreakerDecks = VOathbreakerDecks.SINGLETON_INSTANCE;
        this.vOathbreakerDecks.setCDetailPicture(this.cDetailPicture);
        this.vBrawlDecks = VBrawlDecks.SINGLETON_INSTANCE;
        this.vBrawlDecks.setCDetailPicture(this.cDetailPicture);
        this.vTinyLeadersDecks = VTinyLeadersDecks.SINGLETON_INSTANCE;
        this.vTinyLeadersDecks.setCDetailPicture(this.cDetailPicture);
        this.vEditorLog = VEditorLog.SINGLETON_INSTANCE;
    }

    public CDetailPicture getCDetailPicture() {
        return this.cDetailPicture;
    }

    public void setCard(InventoryItem item) {
        this.cDetailPicture.showItem(item);
    }

    public boolean hasChanges() {
        if (this.childController == null) {
            return false;
        }
        DeckController<? extends DeckBase> deckController = this.childController.getDeckController();
        if (deckController == null) {
            return false;
        }
        return !deckController.isSaved();
    }

    public boolean canSwitchAway(boolean isClosing) {
        if (this.childController != null) {
            if (!this.childController.canSwitchAway(isClosing)) {
                return false;
            }
            this.childController.resetUIChanges();
            if (isClosing) {
                this.screenChildControllers.remove(this.childController.getScreen());
                this.childController = null;
            }
        }
        return true;
    }

    public ACEditorBase<? extends InventoryItem, ? extends DeckBase> getCurrentEditorController() {
        return this.childController;
    }

    public void setEditorController(ACEditorBase<? extends InventoryItem, ? extends DeckBase> childController0) {
        FScreen screen = childController0.getScreen();
        this.screenChildControllers.put(screen, childController0);
        if (screen == Singletons.getControl().getCurrentScreen()) {
            this.setCurrentEditorController(childController0);
        }
    }

    public <T extends InventoryItem> void incrementDeckQuantity(T item, int delta) {
        if (item == null || delta == 0) {
            return;
        }
        if (delta > 0) {
            int qty = Math.min(delta, this.childController.getCatalogManager().getItemCount(item));
            if (qty == 0) {
                return;
            }
            this.childController.addItem(item, qty);
        } else {
            int qty = Math.min(-delta, this.childController.getDeckManager().getItemCount(item));
            if (qty == 0) {
                return;
            }
            this.childController.removeItem(item, qty);
        }
        CStatistics.SINGLETON_INSTANCE.update();
        CProbabilities.SINGLETON_INSTANCE.update();
    }

    private <T extends InventoryItem> void moveSelectedItems(ItemManager<T> itemManager, _MoveAction moveAction, int maxQty) {
        if (maxQty == 0) {
            return;
        }
        ItemPool<InventoryItem> items = new ItemPool<InventoryItem>(itemManager.getGenericType());
        for (InventoryItem item : itemManager.getSelectedItems()) {
            int qty = Math.min(maxQty, itemManager.getItemCount(item));
            if (qty <= 0) continue;
            items.add(item, qty);
        }
        if (items.isEmpty()) {
            return;
        }
        moveAction.move(items);
        if (!(this.childController instanceof CEditorQuestCardShop)) {
            CStatistics.SINGLETON_INSTANCE.update();
            CProbabilities.SINGLETON_INSTANCE.update();
        }
    }

    public void addSelectedCards(final boolean toAlternate, int number) {
        this.moveSelectedItems(this.childController.getCatalogManager(), new _MoveAction(){

            @Override
            public <T extends InventoryItem> void move(Iterable<Map.Entry<T, Integer>> items) {
                CDeckEditorUI.this.childController.addItems(items, toAlternate);
            }
        }, number);
    }

    public void removeSelectedCards(final boolean toAlternate, int number) {
        this.moveSelectedItems(this.childController.getDeckManager(), new _MoveAction(){

            @Override
            public <T extends InventoryItem> void move(Iterable<Map.Entry<T, Integer>> items) {
                CDeckEditorUI.this.childController.removeItems(items, toAlternate);
            }
        }, number);
    }

    private void setCurrentEditorController(ACEditorBase<? extends InventoryItem, ? extends DeckBase> childController0) {
        this.childController = childController0;
        Singletons.getControl().getForgeMenu().setProvider(childController0);
        if (this.childController == null) {
            return;
        }
        final ItemManager<? extends InventoryItem> catView = this.childController.getCatalogManager();
        final ItemManager<? extends InventoryItem> deckView = this.childController.getDeckManager();
        VCardCatalog.SINGLETON_INSTANCE.setItemManager(catView);
        VCurrentDeck.SINGLETON_INSTANCE.setItemManager(deckView);
        if (!this.childController.listenersHooked) {
            catView.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (!catView.isIncrementalSearchActive() && 32 == e.getKeyCode()) {
                        CDeckEditorUI.this.addSelectedCards(e.isControlDown() || e.isMetaDown(), e.isShiftDown() ? 4 : 1);
                    } else if ((37 == e.getKeyCode() || 39 == e.getKeyCode()) && (e.isControlDown() || e.isMetaDown())) {
                        deckView.focus();
                        e.consume();
                    }
                }
            });
            deckView.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (!catView.isIncrementalSearchActive() && 32 == e.getKeyCode()) {
                        CDeckEditorUI.this.removeSelectedCards(e.isControlDown() || e.isMetaDown(), e.isShiftDown() ? 4 : 1);
                    } else if (37 == e.getKeyCode() || 39 == e.getKeyCode()) {
                        if (e.isControlDown() || e.isMetaDown()) {
                            catView.focus();
                            e.consume();
                        }
                    } else if (70 == e.getKeyCode() && (e.isControlDown() || e.isMetaDown())) {
                        deckView.focusSearch();
                    }
                }
            });
            catView.setItemActivateCommand(() -> this.addSelectedCards(false, 1));
            deckView.setItemActivateCommand(() -> this.removeSelectedCards(false, 1));
            catView.setContextMenuBuilder(this.childController.createContextMenuBuilder(true));
            deckView.setContextMenuBuilder(this.childController.createContextMenuBuilder(false));
            catView.addSelectionListener(e -> this.setCard((InventoryItem)catView.getSelectedItem()));
            deckView.addSelectionListener(e -> this.setCard((InventoryItem)deckView.getSelectedItem()));
            catView.setAllowMultipleSelections(true);
            deckView.setAllowMultipleSelections(true);
            this.childController.listenersHooked = true;
        }
        this.childController.update();
        catView.applyFilters();
        SwingUtilities.invokeLater(catView::focus);
    }

    @Override
    public void register() {
        EDocID.CARD_PICTURE.setDoc(this.cDetailPicture.getCPicture().getView());
        EDocID.CARD_DETAIL.setDoc(this.cDetailPicture.getCDetail().getView());
        EDocID.EDITOR_LOG.setDoc(this.vEditorLog);
    }

    @Override
    public void initialize() {
        FScreen screen = Singletons.getControl().getCurrentScreen();
        ACEditorBase<? extends InventoryItem, ? extends DeckBase> screenChildController = this.screenChildControllers.get(screen);
        if (screenChildController != null) {
            this.setCurrentEditorController(screenChildController);
        } else if (screen == FScreen.DECK_EDITOR_CONSTRUCTED) {
            DeckProxy deck;
            this.setEditorController(new CEditorConstructed(this.cDetailPicture));
            String currentDeckStr = DeckPreferences.getCurrentDeck();
            if (currentDeckStr != null && (deck = (DeckProxy)this.vAllDecks.getLstDecks().stringToItem(currentDeckStr)) != null) {
                this.vAllDecks.getLstDecks().setSelectedItem(deck);
                this.getCurrentEditorController().getDeckController().load(deck.getPath(), deck.getName());
            }
        }
    }

    @Override
    public void update() {
    }

    private static interface _MoveAction {
        public <T extends InventoryItem> void move(Iterable<Map.Entry<T, Integer>> var1);
    }
}

