/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.deckeditor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.ImageCache;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.gui.GuiBase;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FComboBox;
import forge.toolbox.FComboBoxPanel;
import forge.toolbox.FHtmlViewer;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JOptionPane;

public class AddBasicLandsDialog {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 400;
    private static final int ADD_BTN_SIZE = 22;
    private static final int LAND_PANEL_PADDING = 3;
    private final FComboBoxPanel<CardEdition> cbLandSet = new FComboBoxPanel<CardEdition>(Localizer.getInstance().getMessage("lblLandSet", new Object[0]) + ":", 1, Iterables.filter(StaticData.instance().getSortedEditions(), CardEdition.Predicates.hasBasicLands));
    private final MainPanel panel = new MainPanel();
    private final LandPanel pnlPlains = new LandPanel("Plains");
    private final LandPanel pnlIsland = new LandPanel("Island");
    private final LandPanel pnlSwamp = new LandPanel("Swamp");
    private final LandPanel pnlMountain = new LandPanel("Mountain");
    private final LandPanel pnlForest = new LandPanel("Forest");
    private final FHtmlViewer lblDeckInfo = new FHtmlViewer();
    private final Deck deck;
    private FOptionPane optionPane;
    private int nonLandCount;
    private int oldLandCount;
    private CardEdition landSet;

    public AddBasicLandsDialog(Deck deck0) {
        this(deck0, null);
    }

    public AddBasicLandsDialog(Deck deck0, CardEdition defaultLandSet) {
        this.deck = deck0;
        if (defaultLandSet == null) {
            defaultLandSet = DeckProxy.getDefaultLandSet(this.deck);
        }
        this.panel.setMinimumSize(new Dimension(800, 400));
        this.panel.add(this.cbLandSet);
        this.panel.add(this.pnlPlains);
        this.panel.add(this.pnlIsland);
        this.panel.add(this.pnlSwamp);
        this.panel.add(this.pnlMountain);
        this.panel.add(this.pnlForest);
        this.panel.add(this.lblDeckInfo);
        this.lblDeckInfo.setFont(FSkin.getRelativeFont(14));
        this.lblDeckInfo.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                Map<ManaCostShard, Integer> suggestionMap = DeckgenUtil.suggestBasicLandCount(AddBasicLandsDialog.this.deck);
                AddBasicLandsDialog.this.pnlPlains.count = suggestionMap.get((Object)ManaCostShard.WHITE);
                AddBasicLandsDialog.this.pnlIsland.count = suggestionMap.get((Object)ManaCostShard.BLUE);
                AddBasicLandsDialog.this.pnlSwamp.count = suggestionMap.get((Object)ManaCostShard.BLACK);
                AddBasicLandsDialog.this.pnlMountain.count = suggestionMap.get((Object)ManaCostShard.RED);
                AddBasicLandsDialog.this.pnlForest.count = suggestionMap.get((Object)ManaCostShard.GREEN);
                AddBasicLandsDialog.this.pnlPlains.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlPlains.count));
                AddBasicLandsDialog.this.pnlIsland.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlIsland.count));
                AddBasicLandsDialog.this.pnlSwamp.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlSwamp.count));
                AddBasicLandsDialog.this.pnlMountain.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlMountain.count));
                AddBasicLandsDialog.this.pnlForest.lblCount.setText(String.valueOf(AddBasicLandsDialog.this.pnlForest.count));
                AddBasicLandsDialog.this.updateDeckInfoLabel();
            }
        });
        this.lblDeckInfo.setToolTipText(Localizer.getInstance().getMessage("lblDeckStatisticsAutoSuggest", new Object[0]));
        this.cbLandSet.addActionListener(arg0 -> {
            this.landSet = this.cbLandSet.getSelectedItem();
            this.pnlPlains.refreshArtChoices();
            this.pnlIsland.refreshArtChoices();
            this.pnlSwamp.refreshArtChoices();
            this.pnlMountain.refreshArtChoices();
            this.pnlForest.refreshArtChoices();
        });
        this.cbLandSet.setSelectedItem(defaultLandSet);
        int halfCountW = 0;
        int halfCountU = 0;
        int halfCountB = 0;
        int halfCountR = 0;
        int halfCountG = 0;
        for (Map.Entry entry : this.deck.getMain()) {
            CardRules cardRules = ((PaperCard)entry.getKey()).getRules();
            int count = entry.getValue();
            if (cardRules.getType().isLand()) {
                this.oldLandCount += count;
            } else {
                this.nonLandCount += count;
                for (ManaCostShard shard : cardRules.getManaCost()) {
                    boolean isMonoColor = shard.isMonoColor();
                    if (shard.isWhite()) {
                        if (isMonoColor) {
                            this.pnlPlains.symbolCount += count;
                            continue;
                        }
                        halfCountW += count;
                    }
                    if (shard.isBlue()) {
                        if (isMonoColor) {
                            this.pnlIsland.symbolCount += count;
                            continue;
                        }
                        halfCountU += count;
                    }
                    if (shard.isBlack()) {
                        if (isMonoColor) {
                            this.pnlSwamp.symbolCount += count;
                            continue;
                        }
                        halfCountB += count;
                    }
                    if (shard.isRed()) {
                        if (isMonoColor) {
                            this.pnlMountain.symbolCount += count;
                            continue;
                        }
                        halfCountR += count;
                    }
                    if (!shard.isGreen()) continue;
                    if (isMonoColor) {
                        this.pnlForest.symbolCount += count;
                        continue;
                    }
                    halfCountG += count;
                }
            }
            if (this.pnlPlains.symbolCount > 0 && halfCountW > 0) {
                this.pnlPlains.symbolCount = (int)((double)this.pnlPlains.symbolCount + (double)halfCountW * 0.5);
            }
            if (this.pnlIsland.symbolCount > 0 && halfCountU > 0) {
                this.pnlIsland.symbolCount = (int)((double)this.pnlIsland.symbolCount + (double)halfCountU * 0.5);
            }
            if (this.pnlSwamp.symbolCount > 0 && halfCountB > 0) {
                this.pnlSwamp.symbolCount = (int)((double)this.pnlSwamp.symbolCount + (double)halfCountB * 0.5);
            }
            if (this.pnlMountain.symbolCount > 0 && halfCountR > 0) {
                this.pnlMountain.symbolCount = (int)((double)this.pnlMountain.symbolCount + (double)halfCountR * 0.5);
            }
            if (this.pnlForest.symbolCount <= 0 || halfCountG <= 0) continue;
            this.pnlForest.symbolCount = (int)((double)this.pnlForest.symbolCount + (double)halfCountG * 0.5);
        }
        this.updateDeckInfoLabel();
    }

    public CardPool show() {
        this.optionPane = new FOptionPane(null, Localizer.getInstance().getMessage("lblAddBasicLands", new Object[0]), null, this.panel, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])), 0);
        this.panel.revalidate();
        this.panel.repaint();
        this.optionPane.setVisible(true);
        int result = this.optionPane.getResult();
        this.optionPane.dispose();
        if (result == 0) {
            CardPool landsToAdd = new CardPool();
            this.pnlPlains.addToCardPool(landsToAdd);
            this.pnlIsland.addToCardPool(landsToAdd);
            this.pnlSwamp.addToCardPool(landsToAdd);
            this.pnlMountain.addToCardPool(landsToAdd);
            this.pnlForest.addToCardPool(landsToAdd);
            return landsToAdd;
        }
        return null;
    }

    private void updateDeckInfoLabel() {
        int newLandCount = this.pnlPlains.count + this.pnlIsland.count + this.pnlSwamp.count + this.pnlMountain.count + this.pnlForest.count;
        int totalSymbolCount = this.pnlPlains.symbolCount + this.pnlIsland.symbolCount + this.pnlSwamp.symbolCount + this.pnlMountain.symbolCount + this.pnlForest.symbolCount;
        int newTotalCount = this.nonLandCount + this.oldLandCount + newLandCount;
        if (totalSymbolCount == 0) {
            totalSymbolCount = 1;
        }
        Localizer localizer = Localizer.getInstance();
        String infoLabel = String.format("<div 'text-align: center;'>%s</div><div 'text-align: center;'> %s + %s + %s = %s</div><div style='text-align: center;'>{W} %d (%d%%) | {U} %d (%d%%) ) | {B} %d (%d%%) | {R} %d (%d%%) | {G} %d (%d%%) </div>", localizer.getMessage("lblMainDeck", new Object[0]), String.format(localizer.getMessage("lblNonLandCount", new Object[0]), this.nonLandCount), String.format(localizer.getMessage("lblOldLandCount", new Object[0]), this.oldLandCount), String.format(localizer.getMessage("lblNewLandCount", new Object[0]), newLandCount), String.format(localizer.getMessage("lblNewTotalCount", new Object[0]), newTotalCount), this.pnlPlains.symbolCount, this.pnlPlains.symbolCount * 100 / totalSymbolCount, this.pnlIsland.symbolCount, this.pnlIsland.symbolCount * 100 / totalSymbolCount, this.pnlSwamp.symbolCount, this.pnlSwamp.symbolCount * 100 / totalSymbolCount, this.pnlMountain.symbolCount, this.pnlMountain.symbolCount * 100 / totalSymbolCount, this.pnlForest.symbolCount, this.pnlForest.symbolCount * 100 / totalSymbolCount);
        this.lblDeckInfo.setText(FSkin.encodeSymbols(infoLabel, false));
    }

    private class LandPanel
    extends FSkin.SkinnedPanel {
        private final LandCardPanel cardPanel;
        private final FLabel lblCount;
        private final FLabel btnSubtract;
        private final FLabel btnAdd;
        private final FComboBox<String> cbLandArt;
        private final String cardName;
        private PaperCard card;
        private int count;
        private int maxCount;
        private int symbolCount;

        private LandPanel(String cardName0) {
            super(null);
            this.setOpaque(false);
            this.cardName = cardName0;
            this.cardPanel = new LandCardPanel();
            this.cbLandArt = new FComboBox();
            this.cbLandArt.setFont(FSkin.getFont());
            this.cbLandArt.addActionListener(arg0 -> {
                int artIndex = this.cbLandArt.getSelectedIndex();
                if (artIndex < 0) {
                    return;
                }
                this.card = this.generateCard(artIndex);
                this.cardPanel.repaint();
            });
            this.lblCount = new FLabel.Builder().text("0").fontSize(22).fontAlign(0).build();
            this.btnSubtract = new FLabel.ButtonBuilder().icon(FSkin.getIcon(FSkinProp.ICO_MINUS)).cmdClick(() -> {
                if (this.count > 0) {
                    --this.count;
                    this.lblCount.setText(String.valueOf(this.count));
                    AddBasicLandsDialog.this.updateDeckInfoLabel();
                }
            }).build();
            this.btnAdd = new FLabel.ButtonBuilder().icon(FSkin.getIcon(FSkinProp.ICO_PLUS)).cmdClick(() -> {
                if (this.maxCount == 0 || this.count < this.maxCount) {
                    ++this.count;
                    this.lblCount.setText(String.valueOf(this.count));
                    AddBasicLandsDialog.this.updateDeckInfoLabel();
                }
            }).build();
            this.btnSubtract.getAccessibleContext().setAccessibleName("Remove " + this.cardName);
            this.btnAdd.getAccessibleContext().setAccessibleName("Add " + this.cardName);
            this.add(this.cardPanel);
            this.add(this.cbLandArt);
            this.add(this.lblCount);
            this.add(this.btnSubtract);
            this.add(this.btnAdd);
        }

        private void addToCardPool(CardPool pool) {
            if (this.count == 0) {
                return;
            }
            int artIndex = this.cbLandArt.getSelectedIndex();
            if (artIndex < 0) {
                return;
            }
            if (artIndex > 0 && this.card != null) {
                pool.add(this.card, this.count);
            } else {
                int artChoiceCount = FModel.getMagicDb().getCommonCards().getArtCount(this.cardName, AddBasicLandsDialog.this.landSet.getCode());
                for (int i = 0; i < this.count; ++i) {
                    int rndArtIndex = MyRandom.getRandom().nextInt(artChoiceCount) + 1;
                    pool.add(this.generateCard(rndArtIndex));
                }
            }
        }

        private PaperCard generateCard(int artIndex) {
            PaperCard c = FModel.getMagicDb().getCommonCards().getCard(this.cardName, AddBasicLandsDialog.this.landSet.getCode(), artIndex);
            if (c == null) {
                c = FModel.getMagicDb().getCommonCards().getCard(this.cardName, "ZEN");
            }
            return c;
        }

        private void refreshArtChoices() {
            this.cbLandArt.removeAllItems();
            if (AddBasicLandsDialog.this.landSet == null) {
                return;
            }
            int artChoiceCount = FModel.getMagicDb().getCommonCards().getArtCount(this.cardName, AddBasicLandsDialog.this.landSet.getCode());
            this.cbLandArt.addItem(Localizer.getInstance().getMessage("lblAssortedArt", new Object[0]));
            for (int i = 1; i <= artChoiceCount; ++i) {
                this.cbLandArt.addItem(Localizer.getInstance().getMessage("lblCardArtN", String.valueOf(i)));
            }
        }

        @Override
        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            int y = height - 22;
            int buttonWidth = 22;
            int labelWidth = width - 44;
            int minLabelWidth = this.lblCount.getSkin().getFont().measureTextWidth(JOptionPane.getRootFrame().getGraphics(), "0") + 2 * this.lblCount.getInsets().left;
            if (labelWidth < minLabelWidth) {
                labelWidth = minLabelWidth;
                buttonWidth = (width - labelWidth) / 2;
            }
            this.btnAdd.setBounds(0, y, buttonWidth, 22);
            this.lblCount.setBounds(buttonWidth, y, labelWidth, 22);
            this.btnSubtract.setBounds(width - buttonWidth, y, buttonWidth, 22);
            this.cbLandArt.setBounds(0, y -= 28, width, 25);
            int cardPanelHeight = y - 3;
            int cardPanelWidth = Math.round((float)cardPanelHeight / 1.4f);
            this.cardPanel.setBounds((width - cardPanelWidth) / 2, 0, cardPanelWidth, cardPanelHeight);
        }

        private class LandCardPanel
        extends FSkin.SkinnedPanel {
            private LandCardPanel() {
                super(null);
                this.setOpaque(false);
            }

            @Override
            public void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                if (LandPanel.this.card == null) {
                    return;
                }
                Graphics2D g2d = (Graphics2D)g2;
                float screenScale = GuiBase.getInterface().getScreenScale();
                int drawWidth = this.getWidth();
                int drawHeight = this.getHeight();
                int imageWidth = Math.round((float)drawWidth * screenScale);
                int imageHeight = Math.round((float)drawHeight * screenScale);
                BufferedImage img = ImageCache.getImage(LandPanel.this.card, imageWidth, imageHeight);
                if (img != null) {
                    g2d.drawImage(img, 0, 0, drawWidth, drawHeight, 0, 0, imageWidth, imageHeight, null);
                }
            }
        }
    }

    private class MainPanel
    extends FSkin.SkinnedPanel {
        private MainPanel() {
            super(null);
            this.setOpaque(false);
        }

        @Override
        public void doLayout() {
            int padding;
            int x = padding = 10;
            int y = padding;
            int w = this.getWidth() - 2 * padding;
            int comboBoxHeight = 25;
            AddBasicLandsDialog.this.cbLandSet.setBounds(x, y, w, comboBoxHeight);
            int panelExtraHeight = AddBasicLandsDialog.this.pnlPlains.cbLandArt.getHeight() + 22 + 6;
            int panelWidth = (this.getWidth() - 6 * padding) / 5;
            int panelHeight = Math.round((float)panelWidth * 1.4f) + panelExtraHeight;
            AddBasicLandsDialog.this.pnlPlains.setBounds(x, y += comboBoxHeight + padding, panelWidth, panelHeight);
            AddBasicLandsDialog.this.pnlIsland.setBounds(x += panelWidth + padding, y, panelWidth, panelHeight);
            AddBasicLandsDialog.this.pnlSwamp.setBounds(x += panelWidth + padding, y, panelWidth, panelHeight);
            AddBasicLandsDialog.this.pnlMountain.setBounds(x += panelWidth + padding, y, panelWidth, panelHeight);
            AddBasicLandsDialog.this.pnlForest.setBounds(x += panelWidth + padding, y, panelWidth, panelHeight);
            x = padding;
            AddBasicLandsDialog.this.lblDeckInfo.setBounds(x, y += panelHeight + padding, w, this.getHeight() - y - padding);
        }
    }
}

