/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.bazaar;

import forge.gamemodes.quest.bazaar.QuestBazaarManager;
import forge.gui.GuiBase;
import forge.gui.framework.FScreen;
import forge.gui.framework.IVTopLevelUI;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.bazaar.CBazaarUI;
import forge.screens.home.quest.ViewStall;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import forge.view.FView;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public enum VBazaarUI implements IVTopLevelUI
{
    SINGLETON_INSTANCE;

    private JPanel pnlAllStalls;
    private ViewStall pnlSingleStall;
    private FLabel previousSelected;
    private QuestBazaarManager bazaar;

    public void populateStalls() {
        for (String s2 : this.bazaar.getStallNames()) {
            FLabel lbl = new FLabel.ButtonBuilder().text(s2 + "  ").fontAlign(4).iconInBackground(true).selectable().fontSize(16).icon((FSkin.SkinImage)GuiBase.getInterface().getSkinIcon(this.bazaar.getStall(s2).getIcon())).build();
            this.pnlAllStalls.add((Component)lbl, "h 80px!, w 90%!, gap 0 0 10px 10px");
            lbl.setCommand(() -> {
                if (this.previousSelected != null) {
                    this.previousSelected.setSelected(false);
                }
                lbl.setSelected(true);
                this.previousSelected = lbl;
                lbl.requestFocusInWindow();
                CBazaarUI.SINGLETON_INSTANCE.showStall(s2, this.bazaar);
            });
        }
    }

    public void refreshLastInstance() {
        SwingUtilities.invokeLater(() -> this.pnlSingleStall.updateStall());
    }

    public JPanel getPnlAllStalls() {
        return this.pnlAllStalls;
    }

    public ViewStall getPnlSingleStall() {
        return this.pnlSingleStall;
    }

    @Override
    public void instantiate() {
        this.pnlAllStalls = new JPanel();
        this.pnlSingleStall = new ViewStall(this);
        this.bazaar = FModel.getQuest().getBazaar();
        this.pnlAllStalls.setOpaque(false);
        this.pnlAllStalls.setLayout(new MigLayout("insets 0, gap 0, wrap, align center"));
        CBazaarUI.SINGLETON_INSTANCE.initBazaar(this.bazaar);
        this.previousSelected = (FLabel)this.pnlAllStalls.getComponent(0);
    }

    @Override
    public void populate() {
        FPanel pnl = FView.SINGLETON_INSTANCE.getPnlInsets();
        pnl.setBorder((Border)null);
        pnl.setLayout(new MigLayout("insets 0, gap 0"));
        pnl.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        pnl.add((Component)this.pnlAllStalls, "w 25%!, h 100%!");
        pnl.add((Component)this.pnlSingleStall, "w 75%!, h 100%!");
        SwingUtilities.invokeLater(() -> {
            if (this.previousSelected != null) {
                this.previousSelected.requestFocusInWindow();
            }
        });
    }

    @Override
    public boolean onSwitching(FScreen fromScreen, FScreen toScreen) {
        return true;
    }

    @Override
    public boolean onClosing(FScreen screen) {
        return true;
    }
}

