/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.collect.Maps;
import forge.game.player.PlayerView;
import forge.player.PlayerZoneUpdate;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class PlayerZoneUpdates
implements Iterable<PlayerZoneUpdate>,
Serializable {
    private static final long serialVersionUID = 7023549243041119023L;
    private final Map<PlayerView, PlayerZoneUpdate> updates = Collections.synchronizedMap(Maps.newHashMap());

    public PlayerZoneUpdates() {
    }

    public PlayerZoneUpdates(PlayerZoneUpdates other) {
        this.updates.putAll(other.updates);
    }

    @Override
    public Iterator<PlayerZoneUpdate> iterator() {
        return this.updates.values().iterator();
    }

    public void add(PlayerZoneUpdate update) {
        PlayerView player = update.getPlayer();
        PlayerZoneUpdate oldUpdate = this.updates.get(player);
        if (oldUpdate == null) {
            this.updates.put(player, update);
        } else {
            oldUpdate.add(update);
        }
    }

    public boolean isEmpty() {
        return this.updates.isEmpty();
    }

    public void clear() {
        this.updates.clear();
    }
}

