/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;

public class PlayerZoneUpdate
implements Serializable {
    private static final long serialVersionUID = -7666875897455073969L;
    private final PlayerView player;
    private final Set<ZoneType> zones;

    public PlayerZoneUpdate(PlayerView player, ZoneType zone) {
        if (player == null) {
            throw new NullPointerException();
        }
        this.player = player;
        this.zones = zone != null ? EnumSet.of(zone) : EnumSet.noneOf(ZoneType.class);
    }

    public PlayerView getPlayer() {
        return this.player;
    }

    public Set<ZoneType> getZones() {
        return this.zones;
    }

    void addZone(ZoneType zone) {
        if (zone == null) {
            return;
        }
        this.zones.add(zone);
    }

    void add(PlayerZoneUpdate other) {
        if (other == null) {
            return;
        }
        this.zones.addAll(other.getZones());
    }
}

