/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.collect.Iterables;
import forge.card.CardType;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.CharmEffect;
import forge.game.card.Card;
import forge.game.card.CardPlayOption;
import forge.game.cost.Cost;
import forge.game.cost.CostPayment;
import forge.game.mana.ManaPool;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbilityManaConvert;
import forge.game.zone.Zone;
import forge.player.HumanCostDecision;
import forge.player.PlayerControllerHuman;
import forge.util.Localizer;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class HumanPlaySpellAbility {
    private final PlayerControllerHuman controller;
    private SpellAbility ability;
    private boolean needX = true;

    public HumanPlaySpellAbility(PlayerControllerHuman controller0, SpellAbility ability0) {
        this.controller = controller0;
        this.ability = ability0;
    }

    public final boolean playAbility(boolean mayChooseTargets, boolean isFree, boolean skipStack) {
        Player human = this.ability.getActivatingPlayer();
        Game game = human.getGame();
        if (!skipStack) {
            game.setTopLibsCast();
            if (this.ability.getApi() == ApiType.Charm) {
                if (this.ability.isAnnouncing("X")) {
                    this.needX = this.ability.getPayCosts().hasXInAnyCostPart();
                    if (!this.announceValuesLikeX()) {
                        game.clearTopLibsCast(this.ability);
                        return false;
                    }
                }
                if (!CharmEffect.makeChoices(this.ability)) {
                    game.clearTopLibsCast(this.ability);
                    return false;
                }
            }
            this.ability = AbilityUtils.addSpliceEffects(this.ability);
        }
        Zone fromZone = null;
        int zonePosition = 0;
        ManaPool manapool = human.getManaPool();
        Card c = this.ability.getHostCard();
        CardPlayOption option = c.mayPlay(this.ability.getMayPlay());
        boolean refreeze = game.getStack().isFrozen();
        if (this.ability.isSpell() && !c.isCopiedSpell()) {
            fromZone = game.getZoneOf(c);
            if (fromZone != null) {
                zonePosition = fromZone.getCards().indexOf(c);
            }
            this.ability.setHostCard(game.getAction().moveToStack(c, this.ability));
            this.ability.changeText();
        }
        if (!this.ability.isCopied()) {
            this.ability.resetPaidHash();
            this.ability.setPaidLife(0);
        }
        this.ability = GameActionUtil.addExtraKeywordCost(this.ability);
        Cost abCost = this.ability.getPayCosts();
        CostPayment payment = new CostPayment(abCost, this.ability);
        boolean playerManaConversion = human.hasManaConversion() && human.getController().confirmStaticApplication(c, null, "Do you want to spend mana as though it were mana of any type to pay the cost?", null);
        boolean manaColorConversion = false;
        if (!this.ability.isCopied()) {
            if (this.ability.isSpell()) {
                if (option != null && option.applyManaConvert(payment)) {
                    manaColorConversion = true;
                }
                if (option != null && option.isIgnoreSnowSourceManaCostColor()) {
                    payment.setSnowForColor(true);
                }
            }
            if (this.ability.isActivatedAbility() && this.ability.getGrantorStatic() != null && this.ability.getGrantorStatic().hasParam("ManaConversion")) {
                AbilityUtils.applyManaColorConversion(payment, this.ability.getGrantorStatic().getParam("ManaConversion"));
                manaColorConversion = true;
            }
            if (StaticAbilityManaConvert.manaConvert(payment, human, this.ability.getHostCard(), this.ability)) {
                manaColorConversion = true;
            }
            if (this.ability.hasParam("ManaConversion")) {
                AbilityUtils.applyManaColorConversion(manapool, this.ability.getParam("ManaConversion"));
                manaColorConversion = true;
            }
        }
        if (playerManaConversion) {
            AbilityUtils.applyManaColorConversion(payment, "AnyType->AnyType");
            human.incNumManaConversion();
        }
        this.ability.clearManaPaid();
        this.ability.getPayingManaAbilities().clear();
        boolean preCostRequisites = this.announceType() && this.announceValuesLikeX() && this.ability.checkRestrictions(human) && (!mayChooseTargets || this.ability.setupTargets()) && this.ability.canCastTiming(human) && this.ability.isLegalAfterStack();
        game.getStack().freezeStack(this.ability);
        boolean prerequisitesMet = preCostRequisites && (isFree || payment.payCost(new HumanCostDecision(this.controller, human, this.ability, this.ability.isTrigger())));
        game.clearTopLibsCast(this.ability);
        if (!prerequisitesMet) {
            if (this.ability.isTrigger()) {
                if (game.EXPERIMENTAL_RESTORE_SNAPSHOT && preCostRequisites) {
                    GameActionUtil.rollbackAbility(this.ability, fromZone, zonePosition, payment, c);
                } else {
                    payment.refundPayment();
                }
            } else {
                GameActionUtil.rollbackAbility(this.ability, fromZone, zonePosition, payment, c);
            }
            if (!refreeze) {
                game.getStack().unfreezeStack();
            }
            if (manaColorConversion) {
                manapool.restoreColorReplacements();
            }
            if (playerManaConversion) {
                manapool.restoreColorReplacements();
                human.decNumManaConversion();
            }
            return false;
        }
        if (isFree || payment.isFullyPaid()) {
            human.getAchievementTracker().onSpellAbilityPlayed(this.ability);
            if (skipStack) {
                AbilityUtils.resolve(this.ability);
                if (!this.ability.isReplacementAbility()) {
                    game.getStack().unfreezeStack();
                }
            } else {
                HumanPlaySpellAbility.ensureAbilityHasDescription(this.ability);
                game.getStack().addAndUnfreeze(this.ability);
            }
            if (manaColorConversion) {
                manapool.restoreColorReplacements();
            }
        }
        return true;
    }

    private boolean announceValuesLikeX() {
        if (this.ability.isCopied() || this.ability.isWrapper()) {
            return true;
        }
        Cost cost = this.ability.getPayCosts();
        Card card = this.ability.getHostCard();
        String announce = this.ability.getParam("Announce");
        if (announce != null && this.needX) {
            for (String aVar : announce.split(",")) {
                String varName = aVar.trim();
                Integer value = this.controller.announceRequirements(this.ability, varName);
                if (value == null) {
                    return false;
                }
                if ("X".equalsIgnoreCase(varName)) {
                    this.needX = false;
                    this.ability.setXManaCostPaid(value);
                    continue;
                }
                this.ability.setSVar(varName, value.toString());
                card.setSVar(varName, value.toString());
            }
        }
        if (this.needX) {
            if (cost.hasXInAnyCostPart()) {
                boolean replacedXshard;
                String sVar = this.ability.getParamOrDefault("XAlternative", this.ability.getSVar("X"));
                boolean bl = replacedXshard = this.ability.isSpell() && this.ability.getHostCard().getManaCost().countX() > 0 && !cost.hasXInAnyCostPart();
                if ("Count$xPaid".equals(sVar) && !replacedXshard || sVar.isEmpty()) {
                    Integer value = this.controller.announceRequirements(this.ability, "X");
                    if (value == null) {
                        return false;
                    }
                    this.ability.setXManaCostPaid(value);
                }
            } else {
                this.ability.setXManaCostPaid(null);
            }
        }
        return true;
    }

    private boolean announceType() {
        if (this.ability.isCopied()) {
            return true;
        }
        String announce = this.ability.getParam("AnnounceType");
        PlayerController pc = this.ability.getActivatingPlayer().getController();
        if (announce != null) {
            for (String aVar : announce.split(",")) {
                String varName = aVar.trim();
                if ("CreatureType".equals(varName)) {
                    String choice = pc.chooseSomeType("Creature", this.ability, CardType.Constant.CREATURE_TYPES, Collections.emptyList());
                    this.ability.getHostCard().setChosenType(choice);
                }
                if ("ChooseNumber".equals(varName)) {
                    int min2 = Integer.parseInt(this.ability.getParam("Min"));
                    int max = Integer.parseInt(this.ability.getParam("Max"));
                    int i = this.ability.getActivatingPlayer().getController().chooseNumber(this.ability, Localizer.getInstance().getMessage("lblChooseNumber", new Object[0]), min2, max);
                    this.ability.getHostCard().setChosenNumber(i);
                }
                if (!"Opponent".equals(varName)) continue;
                Player opp = this.ability.getActivatingPlayer().getController().chooseSingleEntityForEffect(this.ability.getActivatingPlayer().getOpponents(), this.ability, Localizer.getInstance().getMessage("lblChooseAnOpponent", new Object[0]), null);
                this.ability.getHostCard().setChosenPlayer(opp);
            }
        }
        return true;
    }

    private static void ensureAbilityHasDescription(SpellAbility ability) {
        TargetChoices targets;
        if (!StringUtils.isBlank(ability.getStackDescription())) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ability.getHostCard().getName());
        if (ability.usesTargeting() && !Iterables.isEmpty(targets = ability.getTargets())) {
            sb.append(" - Targeting ");
            for (GameObject o : targets) {
                sb.append(o.toString()).append(" ");
            }
        }
        ability.setStackDescription(sb.toString());
    }
}

