/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.collect.Lists;
import forge.game.GameEntityView;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardView;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.player.actions.PlayerAction;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputPassPriority;
import forge.interfaces.IMacroSystem;
import forge.localinstance.skin.FSkinProp;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BasicMacroSystem
implements IMacroSystem {
    private final PlayerControllerHuman playerControllerHuman;
    private int sequenceIndex = 0;
    private final List<Pair<GameEntityView, Boolean>> rememberedActions = Lists.newArrayList();
    private String rememberedSequenceText = "";
    private final Localizer localizer = Localizer.getInstance();

    public BasicMacroSystem(PlayerControllerHuman playerControllerHuman) {
        this.playerControllerHuman = playerControllerHuman;
    }

    @Override
    public void addRememberedAction(PlayerAction action) {
    }

    @Override
    public void setRememberedActions() {
        String[] splitSequence;
        String dialogTitle = this.localizer.getMessage("lblRememberActionSequence", new Object[0]);
        Input input = this.playerControllerHuman.inputQueue.getInput();
        if (!(input instanceof InputPassPriority)) {
            this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblYouMustHavePrioritytoUseThisFeature", new Object[0]), dialogTitle);
            return;
        }
        int currentIndex = this.sequenceIndex;
        this.sequenceIndex = 0;
        ArrayList<Pair<Integer, Boolean>> entityInfo = Lists.newArrayList();
        int playerID = this.playerControllerHuman.getPlayer().getId();
        int opponentID = 0;
        for (Player player : this.playerControllerHuman.getGame().getPlayers()) {
            if (player.getId() == playerID) continue;
            opponentID = player.getId();
            break;
        }
        String prompt = this.localizer.getMessage("lblEnterASequence", new Object[0]);
        String textSequence = this.playerControllerHuman.getGui().showInputDialog(prompt, dialogTitle, FSkinProp.ICO_QUEST_NOTES, this.rememberedSequenceText);
        if (textSequence == null || textSequence.trim().isEmpty()) {
            this.rememberedActions.clear();
            if (!this.rememberedSequenceText.isEmpty()) {
                this.rememberedSequenceText = "";
                this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblActionSequenceCleared", new Object[0]), dialogTitle);
            }
            return;
        }
        if (textSequence.equals(this.rememberedSequenceText)) {
            if (currentIndex > 0 && currentIndex < this.rememberedActions.size()) {
                this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblRestartingActionSequence", new Object[0]), dialogTitle);
            }
            return;
        }
        this.rememberedSequenceText = textSequence;
        this.rememberedActions.clear();
        textSequence = textSequence.trim().toLowerCase().replaceAll("[@%]", "");
        textSequence = textSequence.replaceAll("\\bopponent\\b", "%").replaceAll("\\bme\\b", "@");
        textSequence = textSequence.replaceAll("[^\\d\\s,@%]", "");
        textSequence = textSequence.replaceAll("(,\\s+|,|\\s+)", "_");
        for (String string : splitSequence = textSequence.split("_")) {
            if (StringUtils.isNumeric(string)) {
                entityInfo.add(Pair.of(Integer.valueOf(string), false));
                continue;
            }
            if (string.equals("%")) {
                entityInfo.add(Pair.of(opponentID, true));
                continue;
            }
            if (!string.equals("@")) continue;
            entityInfo.add(Pair.of(playerID, true));
        }
        if (entityInfo.isEmpty()) {
            this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblErrorPleaseCheckID", new Object[0]), dialogTitle);
            return;
        }
        ZoneType[] zones = new ZoneType[]{ZoneType.Battlefield, ZoneType.Hand, ZoneType.Graveyard, ZoneType.Exile, ZoneType.Command};
        CardCollectionView cards = this.playerControllerHuman.getGame().getCardsIn(Arrays.asList(zones));
        for (Pair pair : entityInfo) {
            boolean found = false;
            boolean isPlayer = (Boolean)pair.getValue();
            if (isPlayer) {
                for (Player player : this.playerControllerHuman.getGame().getPlayers()) {
                    if (player.getId() != ((Integer)pair.getKey()).intValue()) continue;
                    found = true;
                    this.rememberedActions.add(Pair.of(player.getView(), true));
                    break;
                }
            } else {
                for (Card card : cards) {
                    if (card.getId() != ((Integer)pair.getKey()).intValue()) continue;
                    found = true;
                    this.rememberedActions.add(Pair.of(card.getView(), false));
                    break;
                }
            }
            if (found) continue;
            this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblErrorEntityWithId", new Object[0]) + " " + pair.getKey() + " " + this.localizer.getMessage("lblNotFound", new Object[0]) + ".", dialogTitle);
            this.rememberedActions.clear();
            return;
        }
    }

    @Override
    public void nextRememberedAction() {
        Pair<GameEntityView, Boolean> action;
        boolean isPlayer;
        String dialogTitle = this.localizer.getMessage("lblDoNextActioninSequence", new Object[0]);
        if (this.rememberedActions.isEmpty()) {
            this.playerControllerHuman.getGui().message(this.localizer.getMessage("lblPleaseDefineanActionSequenceFirst", new Object[0]), dialogTitle);
            return;
        }
        if (this.sequenceIndex >= this.rememberedActions.size()) {
            this.sequenceIndex = 0;
        }
        if (isPlayer = (action = this.rememberedActions.get(this.sequenceIndex)).getValue().booleanValue()) {
            this.playerControllerHuman.selectPlayer((PlayerView)action.getKey(), new DummyTriggerEvent());
        } else {
            this.playerControllerHuman.selectCard((CardView)action.getKey(), null, new DummyTriggerEvent());
        }
        ++this.sequenceIndex;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    @Override
    public String playbackText() {
        if (!"".equals(this.rememberedSequenceText)) {
            return this.sequenceIndex + " / " + this.rememberedActions.size();
        }
        return null;
    }

    private class DummyTriggerEvent
    implements ITriggerEvent {
        private DummyTriggerEvent() {
        }

        @Override
        public int getButton() {
            return 1;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }
    }
}

