/*
 * Decompiled with CFR 0.152.
 */
package forge.model;

import forge.gui.util.SGuiChoose;
import forge.item.PaperCard;
import forge.item.generation.IUnOpenedProduct;
import forge.model.MetaSet;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnOpenedMeta
implements IUnOpenedProduct {
    private final List<MetaSet> metaSets = new ArrayList<MetaSet>();
    private final JoinOperation operation;

    private UnOpenedMeta(String creationString, JoinOperation op) {
        this.operation = op;
        for (String m4 : TextUtil.splitWithParenthesis(creationString, ';')) {
            this.metaSets.add(new MetaSet(m4, true));
        }
    }

    @Override
    public List<PaperCard> get() {
        return this.open(true, false);
    }

    public List<PaperCard> open(boolean isHuman, boolean allowCancel) {
        if (this.metaSets.isEmpty()) {
            throw new RuntimeException("Empty UnOpenedMetaset, cannot generate booster.");
        }
        switch (this.operation) {
            case ChooseOne: {
                if (isHuman) {
                    MetaSet ms;
                    if (allowCancel) {
                        ms = SGuiChoose.oneOrNone("Choose Booster", this.metaSets);
                        if (ms == null) {
                            return null;
                        }
                    } else {
                        ms = SGuiChoose.one("Choose Booster", this.metaSets);
                    }
                    return ms.getBooster().get();
                }
            }
            case RandomOne: {
                int selected = MyRandom.getRandom().nextInt(this.metaSets.size());
                IUnOpenedProduct newBooster = this.metaSets.get(selected).getBooster();
                return newBooster.get();
            }
            case SelectAll: {
                ArrayList<PaperCard> allCards = new ArrayList<PaperCard>();
                for (MetaSet ms : this.metaSets) {
                    allCards.addAll((Collection<PaperCard>)ms.getBooster().get());
                }
                return allCards;
            }
        }
        throw new IllegalStateException("Got wrong operation type in unopenedMeta - execution should never reach this point");
    }

    public static UnOpenedMeta choose(String desc) {
        return new UnOpenedMeta(desc, JoinOperation.ChooseOne);
    }

    public static UnOpenedMeta random(String desc) {
        return new UnOpenedMeta(desc, JoinOperation.RandomOne);
    }

    public static UnOpenedMeta selectAll(String desc) {
        return new UnOpenedMeta(desc, JoinOperation.SelectAll);
    }

    private static enum JoinOperation {
        RandomOne,
        ChooseOne,
        SelectAll;

    }
}

