/*
 * Decompiled with CFR 0.152.
 */
package forge.model;

import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.io.DeckGroupSerializer;
import forge.deck.io.DeckStorage;
import forge.localinstance.properties.ForgeConstants;
import forge.util.storage.IStorage;
import forge.util.storage.StorageImmediatelySerialized;
import java.io.File;

public class CardCollections {
    private IStorage<Deck> constructed;
    private IStorage<DeckGroup> draft;
    private IStorage<DeckGroup> sealed;
    private IStorage<DeckGroup> winston;
    private IStorage<Deck> cube;
    private IStorage<Deck> scheme;
    private IStorage<Deck> plane;
    private IStorage<Deck> commander;
    private IStorage<Deck> commanderPrecons;
    private IStorage<Deck> oathbreaker;
    private IStorage<Deck> tinyLeaders;
    private IStorage<Deck> brawl;
    private IStorage<Deck> genetic;
    private IStorage<Deck> customStarter;

    public final IStorage<Deck> getConstructed() {
        if (this.constructed == null) {
            this.constructed = new StorageImmediatelySerialized<Deck>("Constructed decks", new DeckStorage(new File(ForgeConstants.DECK_CONSTRUCTED_DIR), ForgeConstants.DECK_BASE_DIR, true), true);
        }
        return this.constructed;
    }

    public final IStorage<DeckGroup> getDraft() {
        if (this.draft == null) {
            this.draft = new StorageImmediatelySerialized<DeckGroup>("Draft deck sets", new DeckGroupSerializer(new File(ForgeConstants.DECK_DRAFT_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.draft;
    }

    public IStorage<DeckGroup> getSealed() {
        if (this.sealed == null) {
            this.sealed = new StorageImmediatelySerialized<DeckGroup>("Sealed deck sets", new DeckGroupSerializer(new File(ForgeConstants.DECK_SEALED_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.sealed;
    }

    public final IStorage<DeckGroup> getWinston() {
        if (this.winston == null) {
            this.winston = new StorageImmediatelySerialized<DeckGroup>("Winston draft deck sets", new DeckGroupSerializer(new File(ForgeConstants.DECK_WINSTON_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.winston;
    }

    public final IStorage<Deck> getCubes() {
        if (this.cube == null) {
            this.cube = new StorageImmediatelySerialized<Deck>("Cubes", new DeckStorage(new File(ForgeConstants.DECK_CUBE_DIR), ForgeConstants.RES_DIR));
        }
        return this.cube;
    }

    public IStorage<Deck> getScheme() {
        if (this.scheme == null) {
            this.scheme = new StorageImmediatelySerialized<Deck>("Archenemy decks", new DeckStorage(new File(ForgeConstants.DECK_SCHEME_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.scheme;
    }

    public IStorage<Deck> getPlane() {
        if (this.plane == null) {
            this.plane = new StorageImmediatelySerialized<Deck>("Planechase decks", new DeckStorage(new File(ForgeConstants.DECK_PLANE_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.plane;
    }

    public IStorage<Deck> getCommander() {
        if (this.commander == null) {
            this.commander = new StorageImmediatelySerialized<Deck>("Commander decks", new DeckStorage(new File(ForgeConstants.DECK_COMMANDER_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.commander;
    }

    public IStorage<Deck> getOathbreaker() {
        if (this.oathbreaker == null) {
            this.oathbreaker = new StorageImmediatelySerialized<Deck>("Oathbreaker decks", new DeckStorage(new File(ForgeConstants.DECK_OATHBREAKER_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.oathbreaker;
    }

    public IStorage<Deck> getCommanderPrecons() {
        if (this.commanderPrecons == null) {
            this.commanderPrecons = new StorageImmediatelySerialized<Deck>("Commander Precon decks", new DeckStorage(new File(ForgeConstants.COMMANDER_PRECON_DIR), ForgeConstants.QUEST_PRECON_DIR));
        }
        return this.commanderPrecons;
    }

    public IStorage<Deck> getTinyLeaders() {
        if (this.tinyLeaders == null) {
            this.tinyLeaders = new StorageImmediatelySerialized<Deck>("Tiny Leaders decks", new DeckStorage(new File(ForgeConstants.DECK_TINY_LEADERS_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.tinyLeaders;
    }

    public IStorage<Deck> getBrawl() {
        if (this.brawl == null) {
            this.brawl = new StorageImmediatelySerialized<Deck>("Brawl decks", new DeckStorage(new File(ForgeConstants.DECK_BRAWL_DIR), ForgeConstants.DECK_BASE_DIR));
        }
        return this.brawl;
    }

    public final IStorage<Deck> getGeneticAIDecks() {
        if (this.genetic == null) {
            this.genetic = new StorageImmediatelySerialized<Deck>("Genetic AI decks", new DeckStorage(new File(ForgeConstants.GENETIC_AI_DECK_DIR), ForgeConstants.RES_DIR));
        }
        return this.genetic;
    }

    public final IStorage<Deck> getCustomStarterDecks() {
        if (this.customStarter == null) {
            this.customStarter = new StorageImmediatelySerialized<Deck>("Custom Starter decks", new DeckStorage(new File(ForgeConstants.CUSTOM_STARTER_DECK_DIR), ForgeConstants.USER_CUSTOM_DIR));
        }
        return this.customStarter;
    }
}

