/*
 * Decompiled with CFR 0.152.
 */
package forge.model;

import com.google.common.base.Predicate;
import forge.card.CardEdition;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.generation.IUnOpenedProduct;
import forge.item.generation.UnOpenedProduct;
import forge.model.FModel;
import forge.model.MetaSet;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public final class CardBlock
implements Comparable<CardBlock> {
    private final int orderNum;
    private final String name;
    private final List<CardEdition> sets;
    private final Map<String, MetaSet> metaSets = new TreeMap<String, MetaSet>();
    private final CardEdition landSet;
    private final int cntBoostersDraft;
    private final int cntBoostersSealed;
    private Predicate<PaperCard> filter = null;

    public CardBlock(int index, String name, List<CardEdition> sets, List<MetaSet> metas, CardEdition landSet, int cntBoostersDraft, int cntBoostersSealed) {
        this.orderNum = index;
        this.name = name;
        this.sets = Collections.unmodifiableList(sets);
        for (MetaSet m4 : metas) {
            this.metaSets.put(m4.getCode(), m4);
        }
        this.landSet = landSet;
        this.cntBoostersDraft = cntBoostersDraft;
        this.cntBoostersSealed = cntBoostersSealed;
    }

    public String getName() {
        return this.name;
    }

    public List<CardEdition> getSets() {
        return this.sets;
    }

    public CardEdition getLandSet() {
        return this.landSet;
    }

    public int getCntBoostersDraft() {
        return this.cntBoostersDraft;
    }

    public int getCntBoostersSealed() {
        return this.cntBoostersSealed;
    }

    public Predicate<PaperCard> getFilter() {
        if (this.filter == null) {
            this.filter = this.buildFilter();
        }
        return this.filter;
    }

    private Predicate<PaperCard> buildFilter() {
        ArrayList<String> setCodes = new ArrayList<String>();
        for (CardEdition set : this.sets) {
            setCodes.add(set.getCode());
        }
        return IPaperCard.Predicates.printedInSets(setCodes, true);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.landSet == null ? 0 : this.landSet.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CardBlock other = (CardBlock)obj;
        if (!this.landSet.equals(other.landSet)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(CardBlock o) {
        return this.orderNum - o.orderNum;
    }

    public String toString() {
        if (this.metaSets.isEmpty() && this.sets.isEmpty()) {
            return this.name + " (empty)";
        }
        if (this.metaSets.size() + this.getNumberSets() < 2) {
            return this.name + " (set)";
        }
        return this.name + " (block)";
    }

    public int getNumberSets() {
        return this.sets == null ? 0 : this.sets.size();
    }

    public Iterable<String> getMetaSetNames() {
        return this.metaSets.keySet();
    }

    public MetaSet getMetaSet(String key) {
        return this.metaSets.get(key);
    }

    public IUnOpenedProduct getBooster(String code) {
        MetaSet ms = this.metaSets.get(code);
        return ms == null ? new UnOpenedProduct(FModel.getMagicDb().getBoosters().get(code)) : ms.getBooster();
    }

    public static class Reader
    extends StorageReaderFile<CardBlock> {
        private final CardEdition.Collection editions;

        public Reader(String pathname, CardEdition.Collection editions0) {
            super(pathname, CardBlock::getName);
            this.editions = editions0;
        }

        @Override
        protected CardBlock read(String line, int i) {
            String[] setNames;
            String[] sParts = TextUtil.splitWithParenthesis(line, ',', 3);
            String name = sParts[0];
            String[] numbers = sParts[1].trim().split("/");
            int draftBoosters = StringUtils.isNumeric(numbers[0]) ? Integer.parseInt(numbers[0]) : 0;
            int sealedBoosters = StringUtils.isNumeric(numbers[1]) ? Integer.parseInt(numbers[1]) : 0;
            CardEdition landSet = this.editions.getEditionByCodeOrThrow(numbers[2]);
            ArrayList<CardEdition> sets = new ArrayList<CardEdition>();
            ArrayList<MetaSet> metas = new ArrayList<MetaSet>();
            for (String set : setNames = TextUtil.splitWithParenthesis(sParts[2], ' ')) {
                if (set.startsWith("Meta-")) {
                    String metaSpec = set.substring(5);
                    boolean noDraft = metaSpec.startsWith("NoDraft-");
                    if (noDraft) {
                        metaSpec = metaSpec.substring(8);
                    }
                    metas.add(new MetaSet(metaSpec, !noDraft));
                    continue;
                }
                sets.add(this.editions.getEditionByCodeOrThrow(set));
            }
            return new CardBlock(i + 1, name, sets, metas, landSet, draftBoosters, sealedBoosters);
        }
    }
}

