/*
 * Decompiled with CFR 0.152.
 */
package forge.menus;

import forge.Singletons;
import forge.control.FControl;
import forge.gui.GuiChoose;
import forge.gui.MouseUtil;
import forge.gui.framework.FScreen;
import forge.gui.framework.SLayoutIO;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menus.MenuUtil;
import forge.model.FModel;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.view.FFrame;
import forge.view.FView;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public final class LayoutMenu {
    private FScreen currentScreen;
    private static final ForgePreferences prefs = FModel.getPreferences();
    private final boolean showIcons = false;
    private static final ActionListener changeSkin = e -> {
        MouseUtil.setCursor(3);
        FSkin.changeSkin(e.getActionCommand());
        MouseUtil.resetCursor();
    };
    private static JMenuItem fullScreenItem;

    public JMenu getMenu() {
        this.currentScreen = Singletons.getControl().getCurrentScreen();
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblLayout", new Object[0]));
        menu.setMnemonic(76);
        if (this.currentScreen != FScreen.HOME_SCREEN) {
            menu.add(this.getMenu_ViewOptions());
            menu.add(this.getMenu_FileOptions());
        }
        menu.add(LayoutMenu.getMenu_ThemeOptions());
        menu.addSeparator();
        menu.add(LayoutMenu.getMenuItem_FullScreen());
        menu.add(LayoutMenu.getMenuItem_SetWindowSize());
        if (this.currentScreen != FScreen.HOME_SCREEN) {
            menu.add(this.getMenuItem_RevertLayout());
        }
        return menu;
    }

    private JMenu getMenu_ViewOptions() {
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblView", new Object[0]));
        menu.add(LayoutMenu.getMenuItem_ShowTabs());
        if (this.currentScreen != null && this.currentScreen.isMatchScreen()) {
            menu.add(LayoutMenu.getMenuItem_ShowBackgroundImage());
        }
        return menu;
    }

    private JMenu getMenu_FileOptions() {
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblFile", new Object[0]));
        menu.add(this.getMenuItem_OpenLayout());
        menu.add(this.getMenuItem_SaveLayout());
        return menu;
    }

    private static JMenu getMenu_ThemeOptions() {
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblTheme", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        String currentSkin = prefs.getPref(ForgePreferences.FPref.UI_SKIN);
        for (String skin : FSkin.getAllSkins()) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(skin);
            group.add(menuItem);
            if (skin.equals(currentSkin)) {
                menuItem.setSelected(true);
            }
            menuItem.setActionCommand(skin);
            menuItem.addActionListener(changeSkin);
            menu.add(menuItem);
        }
        return menu;
    }

    private static JMenuItem getMenuItem_ShowBackgroundImage() {
        Localizer localizer = Localizer.getInstance();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(localizer.getMessage("lblBackgroundImage", new Object[0]));
        menuItem.setState(prefs.getPrefBoolean(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE));
        menuItem.addActionListener(LayoutMenu.getShowBackgroundImageAction(menuItem));
        return menuItem;
    }

    private static ActionListener getShowBackgroundImageAction(JCheckBoxMenuItem menuItem) {
        return e -> {
            boolean isVisible = menuItem.getState();
            prefs.setPref(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE, isVisible);
            if (isVisible) {
                if (FControl.instance.getCurrentScreen().getDaytime() == null) {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_MATCH), true);
                } else if ("Day".equals(FControl.instance.getCurrentScreen().getDaytime())) {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_DAY), true);
                } else {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_NIGHT), true);
                }
            } else {
                FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage((Image)null);
            }
            FView.SINGLETON_INSTANCE.getPnlInsets().repaint();
        };
    }

    private static JMenuItem getMenuItem_ShowTabs() {
        Localizer localizer = Localizer.getInstance();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(localizer.getMessage("lblPanelTabs", new Object[0]));
        menuItem.setAccelerator(MenuUtil.getAcceleratorKey(84));
        menuItem.setState(!prefs.getPrefBoolean(ForgePreferences.FPref.UI_HIDE_GAME_TABS));
        menuItem.addActionListener(LayoutMenu.getShowTabsAction(menuItem));
        return menuItem;
    }

    private static ActionListener getShowTabsAction(JCheckBoxMenuItem menuItem) {
        return e -> {
            boolean showTabs = menuItem.getState();
            FView.SINGLETON_INSTANCE.refreshAllCellLayouts(showTabs);
            prefs.setPref(ForgePreferences.FPref.UI_HIDE_GAME_TABS, !showTabs);
            prefs.save();
        };
    }

    private JMenuItem getMenuItem_SaveLayout() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblSaveCurrentLayout", new Object[0]));
        menuItem.setIcon((FSkin.SkinImage)null);
        menuItem.addActionListener(LayoutMenu.getSaveLayoutAction());
        return menuItem;
    }

    private static ActionListener getSaveLayoutAction() {
        return e -> SLayoutIO.saveLayout();
    }

    private JMenuItem getMenuItem_OpenLayout() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblOpen", new Object[0]) + "..");
        menuItem.setIcon((FSkin.SkinImage)null);
        menuItem.addActionListener(LayoutMenu.getOpenLayoutAction());
        return menuItem;
    }

    private static ActionListener getOpenLayoutAction() {
        return e -> SLayoutIO.openLayout();
    }

    private JMenuItem getMenuItem_RevertLayout() {
        Localizer localizer = Localizer.getInstance();
        FSkin.SkinnedMenuItem menuItem = new FSkin.SkinnedMenuItem(localizer.getMessage("lblRefresh", new Object[0]));
        menuItem.setIcon((FSkin.SkinImage)null);
        menuItem.addActionListener(LayoutMenu.getRevertLayoutAction());
        return menuItem;
    }

    private static ActionListener getRevertLayoutAction() {
        return e -> SLayoutIO.revertLayout();
    }

    private static JMenuItem getMenuItem_SetWindowSize() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblSetWindowSize", new Object[0]));
        menuItem.addActionListener(LayoutMenu.getSetWindowSizeAction());
        return menuItem;
    }

    private static ActionListener getSetWindowSizeAction() {
        return e -> {
            String[] options = new String[]{"800x600", "1024x768", "1280x720", "1600x900", "1920x1080", "2560x1440", "3840x2160"};
            Localizer localizer = Localizer.getInstance();
            String choice = GuiChoose.oneOrNone(localizer.getMessage("lblChooseNewWindowSize", new Object[0]), options);
            if (choice != null) {
                String[] dims = choice.split("x");
                Singletons.getView().getFrame().setSize(Integer.parseInt(dims[0]), Integer.parseInt(dims[1]));
            }
        };
    }

    public static void updateFullScreenItemText() {
        Localizer localizer = Localizer.getInstance();
        fullScreenItem.setText(Singletons.getView().getFrame().isFullScreen() ? localizer.getMessage("lblExitFullScreen", new Object[0]) : localizer.getMessage("lblFullScreen", new Object[0]));
    }

    private static JMenuItem getMenuItem_FullScreen() {
        Localizer localizer = Localizer.getInstance();
        fullScreenItem = new JMenuItem(localizer.getMessage("lblFullScreen", new Object[0]));
        LayoutMenu.updateFullScreenItemText();
        fullScreenItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        fullScreenItem.addActionListener(LayoutMenu.getFullScreenAction());
        return fullScreenItem;
    }

    private static ActionListener getFullScreenAction() {
        return e -> {
            FFrame frame;
            frame.setFullScreen(!(frame = Singletons.getView().getFrame()).isFullScreen());
        };
    }
}

