/*
 * Decompiled with CFR 0.152.
 */
package forge.menus;

import forge.localinstance.properties.ForgeConstants;
import forge.menus.MenuUtil;
import forge.toolbox.FOptionPane;
import forge.util.BuildInfo;
import forge.util.FileUtil;
import forge.util.Localizer;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class HelpMenu {
    private HelpMenu() {
    }

    public static JMenu getMenu() {
        Localizer localizer = Localizer.getInstance();
        JMenu menu = new JMenu(localizer.getMessage("lblHelp", new Object[0]));
        menu.setMnemonic(72);
        menu.add(HelpMenu.getMenu_GettingStarted());
        menu.add(HelpMenu.getMenu_Articles());
        menu.add(HelpMenu.getMenu_Troubleshooting());
        menu.addSeparator();
        menu.add(HelpMenu.getMenuItem_ReleaseNotes());
        menu.add(HelpMenu.getMenuItem_License());
        menu.addSeparator();
        menu.add(HelpMenu.getMenuItem_About());
        return menu;
    }

    private static JMenuItem getMenuItem_About() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblAboutForge", new Object[0]) + "...");
        menuItem.addActionListener(HelpMenu.getAboutForgeAction());
        return menuItem;
    }

    private static ActionListener getAboutForgeAction() {
        return e -> {
            Localizer localizer = Localizer.getInstance();
            FOptionPane.showMessageDialog("Version : " + BuildInfo.getVersionString(), localizer.getMessage("lblAboutForge", new Object[0]));
        };
    }

    private static JMenu getMenu_Troubleshooting() {
        Localizer localizer = Localizer.getInstance();
        JMenu mnu = new JMenu(localizer.getMessage("lblTroubleshooting", new Object[0]));
        mnu.add(HelpMenu.getMenuItem_OpenLogFile());
        mnu.add(HelpMenu.getMenuItem_ReadMeFile());
        return mnu;
    }

    private static JMenu getMenu_Articles() {
        Localizer localizer = Localizer.getInstance();
        JMenu mnu = new JMenu(localizer.getMessage("lblArticles", new Object[0]));
        mnu.add(HelpMenu.getMenuItem_UrlLink("HOW-TO: Customize your Sealed Deck games with fantasy blocks", "http://www.slightlymagic.net/forum/viewtopic.php?f=26&t=8164"));
        mnu.add(HelpMenu.getMenuItem_UrlLink("Quest Mode: Guide to Formats, Worlds, and everything", "http://www.slightlymagic.net/forum/viewtopic.php?f=26&t=9258"));
        return mnu;
    }

    private static JMenu getMenu_GettingStarted() {
        Localizer localizer = Localizer.getInstance();
        JMenu mnu = new JMenu(localizer.getMessage("lblGettingStarted", new Object[0]));
        mnu.add(HelpMenu.getMenuItem_HowToPlayFile());
        mnu.addSeparator();
        mnu.add(HelpMenu.getMenuItem_UrlLink("Forge Wiki", "https://github.com/Card-Forge/forge/wiki", KeyStroke.getKeyStroke(112, 0)));
        mnu.add(HelpMenu.getMenuItem_UrlLink("What is Forge?", "https://github.com/Card-Forge/forge/wiki#what-is-forge"));
        return mnu;
    }

    private static JMenuItem getMenuItem_HowToPlayFile() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblHowtoPlay", new Object[0]));
        menuItem.addActionListener(HelpMenu.getOpenFileAction(HelpMenu.getFile(ForgeConstants.HOWTO_FILE)));
        return menuItem;
    }

    private static JMenuItem getMenuItem_ReadMeFile() {
        JMenuItem menuItem = new JMenuItem("README.txt");
        menuItem.addActionListener(HelpMenu.getOpenFileAction(HelpMenu.getFile(ForgeConstants.README_FILE)));
        return menuItem;
    }

    private static JMenuItem getMenuItem_OpenLogFile() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblOpenLogFile", new Object[0]));
        menuItem.addActionListener(HelpMenu.getOpenFileAction(HelpMenu.getAbsoluteFile(ForgeConstants.LOG_FILE)));
        return menuItem;
    }

    private static JMenuItem getMenuItem_License() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblForgeLicense", new Object[0]));
        menuItem.addActionListener(HelpMenu.getOpenFileAction(HelpMenu.getFile(ForgeConstants.LICENSE_FILE)));
        return menuItem;
    }

    private static JMenuItem getMenuItem_ReleaseNotes() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblReleaseNotes", new Object[0]));
        menuItem.addActionListener(HelpMenu.getOpenFileAction(HelpMenu.getFile(ForgeConstants.CHANGES_FILE)));
        return menuItem;
    }

    private static ActionListener getOpenFileAction(File file) {
        return e -> {
            try {
                HelpMenu.openFile(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        };
    }

    protected static File getFile(String filename) {
        File file = null;
        String filePath = FileUtil.pathCombine(System.getProperty("user.dir"), filename);
        if (FileUtil.doesFileExist(filePath)) {
            file = new File(filePath);
        }
        return file;
    }

    protected static File getAbsoluteFile(String filename) {
        File file = null;
        if (FileUtil.doesFileExist(filename)) {
            file = new File(filename);
        }
        return file;
    }

    private static void openFile(File file) throws IOException {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            String cmd = "rundll32 url.dll,FileProtocolHandler " + file.getCanonicalPath();
            Runtime.getRuntime().exec(cmd);
        } else {
            Desktop.getDesktop().open(file);
        }
    }

    private static JMenuItem getMenuItem_UrlLink(String caption, String url) {
        JMenuItem menuItem = new JMenuItem(caption);
        menuItem.addActionListener(HelpMenu.getLaunchUrlAction(url));
        return menuItem;
    }

    private static JMenuItem getMenuItem_UrlLink(String caption, String url, KeyStroke accelerator) {
        JMenuItem menuItem = HelpMenu.getMenuItem_UrlLink(caption, url);
        menuItem.setAccelerator(accelerator);
        return menuItem;
    }

    private static ActionListener getLaunchUrlAction(String url) {
        return e -> MenuUtil.openUrlInBrowser(url);
    }
}

