/*
 * Decompiled with CFR 0.152.
 */
package forge.menus;

import forge.Singletons;
import forge.gui.GuiUtils;
import forge.menus.HelpMenu;
import forge.menus.IMenuProvider;
import forge.menus.LayoutMenu;
import forge.screens.home.online.OnlineMenu;
import forge.util.Localizer;
import forge.util.ReflectionUtil;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class ForgeMenu {
    private JPopupMenu popupMenu;
    private IMenuProvider provider;
    private static HashMap<KeyStroke, JMenuItem> activeShortcuts = new HashMap();

    public ForgeMenu() {
        this.refresh();
    }

    public void show() {
        this.show(false);
    }

    public void show(boolean hideIfAlreadyShown) {
        Singletons.getView().getNavigationBar().showForgeMenu(hideIfAlreadyShown);
    }

    public void hide() {
        this.popupMenu.setVisible(false);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setProvider(IMenuProvider provider0) {
        this.provider = provider0;
        this.refresh();
    }

    public void refresh() {
        List<JMenu> menus;
        activeShortcuts.clear();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                Singletons.getView().getNavigationBar().onForgeMenuHidden();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        if (this.provider != null && (menus = this.provider.getMenus()) != null) {
            for (JMenu m4 : menus) {
                m4.setBorderPainted(false);
                this.add(m4);
            }
        }
        this.add(new LayoutMenu().getMenu());
        this.add(HelpMenu.getMenu());
        this.addSeparator();
        this.add(OnlineMenu.getMenu());
        this.addSeparator();
        this.add(ForgeMenu.getMenuItem_Restart());
        this.add(ForgeMenu.getMenuItem_Exit());
    }

    public void add(JMenuItem item) {
        item = this.popupMenu.add(item);
        this.setupItem(item);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    private void setupMenu(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            this.setupItem(menu.getItem(i));
        }
    }

    private void setupItem(JMenuItem item) {
        JMenu subMenu;
        if (item == null) {
            return;
        }
        GuiUtils.setMenuItemSize(item);
        KeyStroke shortcut = item.getAccelerator();
        if (shortcut != null) {
            activeShortcuts.put(shortcut, item);
        }
        if ((subMenu = ReflectionUtil.safeCast(item, JMenu.class)) != null) {
            this.setupMenu(subMenu);
        }
    }

    public boolean handleKeyEvent(KeyEvent e) {
        JMenuItem item;
        if (this.popupMenu.isEnabled() && (item = activeShortcuts.get(KeyStroke.getKeyStrokeForEvent(e))) != null) {
            this.hide();
            item.doClick();
            return true;
        }
        return false;
    }

    private static JMenuItem getMenuItem_Restart() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblRestart", new Object[0]));
        menuItem.setMnemonic(82);
        menuItem.addActionListener(ForgeMenu.getRestartAction());
        return menuItem;
    }

    private static ActionListener getRestartAction() {
        return e -> Singletons.getControl().restartForge();
    }

    private static JMenuItem getMenuItem_Exit() {
        Localizer localizer = Localizer.getInstance();
        JMenuItem menuItem = new JMenuItem(localizer.getMessage("lblExit", new Object[0]));
        menuItem.setMnemonic(88);
        menuItem.addActionListener(ForgeMenu.getExitAction());
        return menuItem;
    }

    private static ActionListener getExitAction() {
        return e -> Singletons.getControl().exitForge();
    }
}

