/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.properties;

import forge.game.GameType;
import forge.util.FileUtil;
import forge.util.TextUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PreferencesStore<T extends Enum<T>> {
    private final Map<T, String> preferenceValues;
    private final String filename;

    public PreferencesStore(String filename0, Class<T> clasz) {
        this.preferenceValues = new EnumMap<T, String>(clasz);
        this.filename = filename0;
        List<String> lines = FileUtil.readFile(this.filename);
        for (String line : lines) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            String[] split = line.split("=");
            T pref = this.valueOf(split[0]);
            if (null == pref) {
                System.out.println("unknown preference: " + line);
                continue;
            }
            if (split.length == 2) {
                this.setPref(pref, split[1]);
                continue;
            }
            if (split.length != 1 || !line.endsWith("=")) continue;
            this.setPref(pref, "");
        }
    }

    protected abstract T[] getEnumValues();

    protected abstract T valueOf(String var1);

    protected abstract String getPrefDefault(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.filename));
            for (Enum key : this.getEnumValues()) {
                writer.write(key + "=" + this.getPref(key));
                writer.newLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    System.out.println("error while closing " + this.filename);
                }
            }
        }
    }

    public final void reset() {
        this.preferenceValues.clear();
    }

    public final void setPref(T q0, String s0) {
        this.preferenceValues.put(q0, s0);
    }

    public final void setPref(T q0, boolean val) {
        this.setPref(q0, String.valueOf(val));
    }

    public final String getPref(T fp0) {
        String val = this.preferenceValues.get(fp0);
        if (val == null) {
            val = this.getPrefDefault(fp0);
        }
        return val;
    }

    public final int getPrefInt(T fp0) {
        try {
            return Integer.parseInt(this.getPref(fp0));
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(this.getPrefDefault(fp0));
        }
    }

    public final boolean getPrefBoolean(T fp0) {
        return Boolean.parseBoolean(this.getPref(fp0));
    }

    public final double getPrefDouble(T fp0) {
        return Double.parseDouble(this.getPref(fp0));
    }

    public void setGameType(T q0, Set<GameType> gameTypes) {
        String s0 = "";
        HashSet<String> e = new HashSet<String>();
        for (GameType g2 : gameTypes) {
            e.add(g2.getEnglishName());
        }
        if (!e.isEmpty()) {
            s0 = s0 + String.join((CharSequence)",", e);
        }
        this.setPref(q0, s0);
    }

    public final Set<GameType> getGameType(T fp0) {
        HashSet<GameType> gameTypes = new HashSet<GameType>();
        String value = this.preferenceValues.get(fp0);
        if (value != null) {
            if (value.contains(",")) {
                String[] values;
                for (String gameType : values = TextUtil.split(value, ',')) {
                    this.addGameType(gameTypes, gameType);
                }
            } else {
                this.addGameType(gameTypes, value);
            }
        }
        return gameTypes;
    }

    void addGameType(Set<GameType> result, String gameType) {
        if (gameType.equals("Vanguard")) {
            result.add(GameType.Vanguard);
        } else if (gameType.equals("Momir Basic")) {
            result.add(GameType.MomirBasic);
        } else if (gameType.equals("MoJhoSto")) {
            result.add(GameType.MoJhoSto);
        } else if (gameType.equals("Commander")) {
            result.add(GameType.Commander);
        } else if (gameType.equals("Oathbreaker")) {
            result.add(GameType.Oathbreaker);
        } else if (gameType.equals("Tiny Leaders")) {
            result.add(GameType.TinyLeaders);
        } else if (gameType.equals("Brawl")) {
            result.add(GameType.Brawl);
        } else if (gameType.equals("Planechase")) {
            result.add(GameType.Planechase);
        } else if (gameType.equals("Archenemy")) {
            result.add(GameType.Archenemy);
        } else if (gameType.equals("Archenemy Rumble")) {
            result.add(GameType.ArchenemyRumble);
        }
    }
}

