/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.achievements;

import forge.deck.Deck;
import forge.game.Game;
import forge.game.GameType;
import forge.game.player.Player;
import forge.gui.GuiBase;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.achievements.AgainstAllOdds;
import forge.localinstance.achievements.Domain;
import forge.localinstance.achievements.NoCreatures;
import forge.localinstance.achievements.NoLands;
import forge.localinstance.achievements.NoSpells;
import forge.localinstance.achievements.ProgressiveAchievement;
import forge.localinstance.properties.ForgeConstants;
import forge.util.Localizer;

public class ChallengeAchievements
extends AchievementCollection {
    public static final ChallengeAchievements instance = new ChallengeAchievements();

    private ChallengeAchievements() {
        super("lblChallenges", ForgeConstants.ACHIEVEMENTS_DIR + "challenges.xml", false);
    }

    @Override
    protected void addSharedAchievements() {
    }

    @Override
    protected void addAchievements() {
        this.add(new NoCreatures());
        this.add(new NoSpells());
        this.add(new NoLands());
        this.add(new Domain());
        if (!GuiBase.getInterface().isLibgdxPort()) {
            this.add(new AgainstAllOdds());
        }
        this.add("Chromatic", Localizer.getInstance().getMessage("lblChromatic", new Object[0]), Localizer.getInstance().getMessage("lblWinGameAfterCasting5CSpell", new Object[0]), Localizer.getInstance().getMessage("lblGreatColorComesPower", new Object[0]));
        this.add("Epic", Localizer.getInstance().getMessage("lblEpic", new Object[0]), Localizer.getInstance().getMessage("lblWinGameAfterResolvingWithEpicSpell", new Object[0]), Localizer.getInstance().getMessage("lblWhenItsYouLastSpellBetterMakeCount", new Object[0]));
    }

    private void add(String key0, String displayName0, String description0, String flavorText0) {
        this.add(new ChallengeAchievement(key0, displayName0, description0, flavorText0));
    }

    public static boolean checkValidGameMode(Game game) {
        return !game.getRules().hasAppliedVariant(GameType.MomirBasic) && !game.getRules().hasAppliedVariant(GameType.MoJhoSto) && !game.getRules().hasAppliedVariant(GameType.Puzzle);
    }

    public static abstract class DeckChallengeAchievement
    extends ChallengeAchievement {
        protected DeckChallengeAchievement(String key0, String displayName0, String condition0, String flavorText0) {
            super(key0, displayName0, Localizer.getInstance().getMessage("lblWinGameUsingTargetDeck", condition0), flavorText0);
        }

        @Override
        protected final boolean eval(Player player, Game game) {
            if (!ChallengeAchievements.checkValidGameMode(game)) {
                return false;
            }
            if (player.getOutcome().hasWon()) {
                return this.eval(player.getRegisteredPlayer().getDeck());
            }
            return false;
        }

        protected abstract boolean eval(Deck var1);
    }

    public static class ChallengeAchievement
    extends ProgressiveAchievement {
        protected ChallengeAchievement(String key0, String displayName0, String description0, String flavorText0) {
            super(key0, displayName0, description0, flavorText0);
        }

        @Override
        protected final String getNoun() {
            return Localizer.getInstance().getMessage("lblWin", new Object[0]);
        }

        @Override
        protected boolean eval(Player player, Game game) {
            if (!ChallengeAchievements.checkValidGameMode(game)) {
                return false;
            }
            return player.getOutcome().hasWon() && player.getAchievementTracker().challengesCompleted.contains(this.getKey());
        }
    }
}

