/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.achievements;

import forge.game.Game;
import forge.game.player.Player;
import forge.item.IPaperCard;
import forge.localinstance.achievements.Achievement;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.achievements.ProgressiveAchievement;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.CardTranslation;
import forge.util.Localizer;
import org.apache.commons.lang3.StringUtils;

public class AltWinAchievements
extends AchievementCollection {
    public static final AltWinAchievements instance = new AltWinAchievements();

    private AltWinAchievements() {
        super("lblAlternateWinConditions", ForgeConstants.ACHIEVEMENTS_DIR + "altwin.xml", false, ForgeConstants.ALTWIN_ACHIEVEMENT_LIST_FILE);
    }

    @Override
    protected void addSharedAchievements() {
    }

    @Override
    protected void add(String cardName0, String displayName0, String flavorText0) {
        this.add(new AltWinAchievement(cardName0, displayName0, flavorText0));
    }

    @Override
    public void updateAll(Player player) {
        if (player.getOutcome().hasWon()) {
            Achievement achievement;
            String altWinCondition = player.getOutcome().altWinSourceName;
            if (StringUtils.isEmpty(altWinCondition)) {
                Player opponent = player.getSingleOpponent();
                if (opponent == null) {
                    return;
                }
                altWinCondition = opponent.getOutcome().loseConditionSpell;
                if (StringUtils.isEmpty(altWinCondition)) {
                    return;
                }
            }
            if ((achievement = (Achievement)this.achievements.get(altWinCondition)) == null) {
                achievement = (Achievement)this.achievements.get("Emblem \u2014 " + altWinCondition);
            }
            if (achievement != null) {
                achievement.update(player);
                this.save();
            }
        }
    }

    private class AltWinAchievement
    extends ProgressiveAchievement {
        private AltWinAchievement(String cardName0, String displayName0, String flavorText0) {
            super(CardTranslation.getTranslatedName(cardName0), displayName0, Localizer.getInstance().getMessage("lblWinGameWithCard", CardTranslation.getTranslatedName(cardName0)), flavorText0);
        }

        @Override
        protected boolean eval(Player player, Game game) {
            return true;
        }

        @Override
        public IPaperCard getPaperCard() {
            return FModel.getMagicDb().getCommonCards().getCard(this.getKey());
        }

        @Override
        public String getNoun() {
            return Localizer.getInstance().getMessage("lblWin", new Object[0]);
        }
    }
}

