/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.achievements;

import forge.game.Game;
import forge.game.player.Player;
import forge.gui.GuiBase;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.XmlUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Element;

public abstract class Achievement {
    private final String key;
    private final String displayName;
    private final String sharedDesc;
    private final String commonDesc;
    private final String uncommonDesc;
    private final String rareDesc;
    private final String mythicDesc;
    private final int commonThreshold;
    private final int uncommonThreshold;
    private final int rareThreshold;
    private final int mythicThreshold;
    private final boolean checkGreaterThan;
    protected final int defaultValue;
    private ISkinImage image;
    private long timestamp;
    private int best;

    protected Achievement(String key0, String displayName0, String description0, String flavorText0, int defaultValue0) {
        this(key0, displayName0, description0, defaultValue0, null, 1, null, 1, null, 1, "(" + flavorText0 + ")", 1);
    }

    protected Achievement(String key0, String displayName0, String sharedDesc0, int defaultValue0, String commonDesc0, int commonThreshold0, String uncommonDesc0, int uncommonThreshold0, String rareDesc0, int rareThreshold0, String mythicDesc0, int mythicThreshold0) {
        this.key = key0;
        this.displayName = displayName0;
        this.sharedDesc = sharedDesc0;
        this.commonDesc = commonDesc0;
        this.commonThreshold = commonThreshold0;
        this.uncommonDesc = uncommonDesc0;
        this.uncommonThreshold = uncommonThreshold0;
        this.rareDesc = rareDesc0;
        this.rareThreshold = rareThreshold0;
        this.mythicDesc = mythicDesc0;
        this.mythicThreshold = mythicThreshold0;
        this.checkGreaterThan = rareThreshold0 >= uncommonThreshold0;
        this.best = defaultValue0;
        this.defaultValue = defaultValue0;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSharedDesc() {
        return this.sharedDesc;
    }

    public String getCommonDesc() {
        return this.commonDesc;
    }

    public String getUncommonDesc() {
        return this.uncommonDesc;
    }

    public String getRareDesc() {
        return this.rareDesc;
    }

    public String getMythicDesc() {
        return this.mythicDesc;
    }

    public ISkinImage getImage() {
        if (this.image == null) {
            this.updateTrophyImage();
        }
        return this.image;
    }

    public int getBest() {
        return this.best;
    }

    public boolean isSpecial() {
        return this.mythicThreshold == this.commonThreshold;
    }

    private boolean earnedSpecial() {
        return this.isSpecial() && this.best > 0;
    }

    public boolean earnedMythic() {
        if (this.isSpecial()) {
            return false;
        }
        if (this.checkGreaterThan) {
            return this.best >= this.mythicThreshold;
        }
        return this.best <= this.mythicThreshold;
    }

    public boolean earnedRare() {
        if (this.isSpecial()) {
            return false;
        }
        if (this.checkGreaterThan) {
            return this.best >= this.rareThreshold;
        }
        return this.best <= this.rareThreshold;
    }

    public boolean earnedUncommon() {
        if (this.isSpecial()) {
            return false;
        }
        if (this.checkGreaterThan) {
            return this.best >= this.uncommonThreshold;
        }
        return this.best <= this.uncommonThreshold;
    }

    public boolean earnedCommon() {
        if (this.isSpecial()) {
            return false;
        }
        if (this.checkGreaterThan) {
            return this.best >= this.commonThreshold;
        }
        return this.best <= this.commonThreshold;
    }

    public IPaperCard getPaperCard() {
        return null;
    }

    protected abstract int evaluate(Player var1, Game var2);

    public boolean isActive() {
        return this.earnedSpecial() || this.earnedMythic() || this.earnedRare() || this.earnedUncommon() || this.earnedCommon();
    }

    public void updateTrophyImage() {
        FSkinProp background;
        float opacity = 1.0f;
        if (this.earnedSpecial()) {
            background = FSkinProp.IMG_SPECIAL_TROPHY;
        } else if (this.earnedMythic()) {
            background = FSkinProp.IMG_MYTHIC_TROPHY;
        } else if (this.earnedRare()) {
            background = FSkinProp.IMG_RARE_TROPHY;
        } else if (this.earnedUncommon()) {
            background = FSkinProp.IMG_UNCOMMON_TROPHY;
        } else if (this.earnedCommon()) {
            background = FSkinProp.IMG_COMMON_TROPHY;
        } else {
            opacity = 0.25f;
            background = this.mythicThreshold == this.commonThreshold ? FSkinProp.IMG_SPECIAL_TROPHY : FSkinProp.IMG_COMMON_TROPHY;
        }
        this.image = GuiBase.getInterface().createLayeredImage((PaperCard)this.getPaperCard(), background, ForgeConstants.CACHE_ACHIEVEMENTS_DIR + "/" + this.key + ".png", opacity);
    }

    public int update(Player player) {
        int value = this.evaluate(player, player.getGame());
        if (this.checkGreaterThan ? value <= this.best : value >= this.best) {
            return value;
        }
        boolean hadEarnedSpecial = this.earnedSpecial();
        boolean hadEarnedMythic = this.earnedMythic();
        boolean hadEarnedRare = this.earnedRare();
        boolean hadEarnedUncommon = this.earnedUncommon();
        boolean hadEarnedCommon = this.earnedCommon();
        this.best = value;
        this.timestamp = new Date().getTime();
        if (this.earnedSpecial()) {
            if (!hadEarnedSpecial) {
                this.updateTrophyImage();
                GuiBase.getInterface().showImageDialog(this.image, this.displayName + "\n" + this.sharedDesc + "\n" + this.mythicDesc, "Achievement Earned");
            }
            return value;
        }
        String type = null;
        String desc = null;
        if (this.earnedMythic()) {
            if (!hadEarnedMythic) {
                type = Localizer.getInstance().getMessage("lblMythic", new Object[0]);
                desc = this.mythicDesc;
            }
        } else if (this.earnedRare()) {
            if (!hadEarnedRare) {
                type = Localizer.getInstance().getMessage("lblRare", new Object[0]);
                desc = this.rareDesc;
            }
        } else if (this.earnedUncommon()) {
            if (!hadEarnedUncommon) {
                type = Localizer.getInstance().getMessage("lblUncommon", new Object[0]);
                desc = this.uncommonDesc;
            }
        } else if (this.earnedCommon() && !hadEarnedCommon) {
            type = Localizer.getInstance().getMessage("lblCommon", new Object[0]);
            desc = this.commonDesc;
        }
        if (type != null) {
            this.updateTrophyImage();
            if (this.sharedDesc != null) {
                desc = this.sharedDesc + " " + desc;
            }
            GuiBase.getInterface().showImageDialog(this.image, this.displayName + " (" + type + ")\n" + desc, Localizer.getInstance().getMessage("lblAchievementEarned", new Object[0]));
        }
        return value;
    }

    public final boolean needSave() {
        return this.best != this.defaultValue;
    }

    public void saveToXml(Element el) {
        el.setAttribute("best", String.valueOf(this.best));
        el.setAttribute("time", String.valueOf(this.timestamp));
    }

    public void loadFromXml(Element el) {
        this.best = XmlUtil.getIntAttribute(el, "best");
        this.timestamp = XmlUtil.getLongAttribute(el, "time");
        this.best = this.performConversion(this.best, this.timestamp);
    }

    protected int performConversion(int value, long timestamp) {
        return value;
    }

    protected abstract String getNoun();

    protected boolean pluralizeNoun() {
        return this.best != 1;
    }

    protected boolean displayNounBefore() {
        return false;
    }

    protected final String getFormattedTimestamp() {
        if (this.timestamp == 0L) {
            return null;
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        return formatter.format(new Date(this.timestamp));
    }

    public String getSubTitle(boolean includeTimestamp) {
        String formattedTimestamp;
        if (this.best == this.defaultValue) {
            return null;
        }
        String subTitle = this.displayNounBefore() ? Localizer.getInstance().getMessage("lblBest", new Object[0]) + ": " + this.getNoun() + " " + this.best : Localizer.getInstance().getMessage("lblBest", new Object[0]) + ": " + this.best + " " + (this.pluralizeNoun() ? Lang.getPlural(this.getNoun()) : this.getNoun());
        if (includeTimestamp && (formattedTimestamp = this.getFormattedTimestamp()) != null) {
            subTitle = subTitle + " (" + formattedTimestamp + ")";
        }
        return subTitle;
    }
}

