/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.itemmanager.views.ItemCellRenderer;
import forge.toolbox.CardFaceSymbols;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;

public class ManaCostRenderer
extends ItemCellRenderer {
    private static final long serialVersionUID = 1770527102334163549L;
    private static final int elemtWidth = 13;
    private static final int elemtGap = 0;
    private static final int padding0 = 2;
    private static final int spaceBetweenSplitCosts = 3;
    private ManaCost v1;
    private ManaCost v2;

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.v2 = null;
        if (value instanceof CardRules) {
            CardRules v = (CardRules)value;
            this.v1 = v.getMainPart().getManaCost();
            this.v2 = v.getSplitType() == CardSplitType.Split ? v.getOtherPart().getManaCost() : null;
        } else {
            this.v1 = value instanceof ManaCost ? (ManaCost)value : ManaCost.NO_COST;
        }
        this.setToolTipText(this.v2 == null ? this.v1.toString() : this.v1.toString() + " // " + this.v2.toString());
        return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
    }

    @Override
    public final void paint(Graphics g2) {
        super.paint(g2);
        int cellWidth = this.getWidth();
        if (this.v2 == null) {
            this.drawCost(g2, this.v1, 2, cellWidth);
        } else {
            int shards1 = this.v1.getGlyphCount();
            int shards2 = this.v2.getGlyphCount();
            int perGlyph = (cellWidth - 2 - 3) / (shards1 + shards2);
            perGlyph = Math.min(perGlyph, 13);
            this.drawCost(g2, this.v1, 2, 2 + perGlyph * shards1);
            this.drawCost(g2, this.v2, cellWidth - perGlyph * shards2 - 2, cellWidth);
        }
    }

    private void drawCost(Graphics g2, ManaCost value, int padding, int cellWidth) {
        int x = padding;
        int y = 3;
        int genericManaCost = value.getGenericCost();
        int xManaCosts = value.countX();
        boolean hasGeneric = genericManaCost > 0 || this.v1.isPureGeneric();
        int cntGlyphs = value.getGlyphCount();
        int offsetIfNoSpace = cntGlyphs > 1 ? (cellWidth - padding - 13) / (cntGlyphs - 1) : 13;
        int dx = Math.min(13, offsetIfNoSpace);
        if (xManaCosts > 0) {
            for (int i = 0; i < xManaCosts; ++i) {
                CardFaceSymbols.drawManaSymbol(ManaCostShard.X.getImageKey(), g2, x, y);
                x += dx;
            }
        }
        if (hasGeneric) {
            String sGeneric = Integer.toString(genericManaCost);
            CardFaceSymbols.drawManaSymbol(sGeneric, g2, x, y);
            x += dx;
        }
        for (ManaCostShard s2 : value) {
            if (s2.equals((Object)ManaCostShard.X)) continue;
            CardFaceSymbols.drawManaSymbol(s2.getImageKey(), g2, x, y);
            x += dx;
        }
    }
}

