/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.views.ItemTableColumn;
import forge.toolbox.FCheckBox;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FScrollPanel;
import forge.toolbox.FSkin;
import forge.toolbox.ToolTipListener;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ItemView<T extends InventoryItem> {
    private static final FSkin.SkinColor BORDER_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    static final FSkin.SkinFont ROW_FONT = FSkin.getFont();
    protected final Localizer localizer = Localizer.getInstance();
    protected final ItemManager<T> itemManager;
    protected final ItemManagerModel<T> model;
    private final FScrollPane scroller;
    private final FLabel button;
    private final FScrollPanel pnlOptions = new FScrollPanel(new MigLayout("insets 3 1 0 1, gap 3 4, hidemode 3"), true, 21, 30);
    protected FCheckBox uniqueCardsOnlyChkBox;
    private int heightBackup;
    private boolean isIncrementalSearchActive = false;

    protected ItemView(ItemManager<T> itemManager0, ItemManagerModel<T> model0) {
        this.itemManager = itemManager0;
        this.model = model0;
        this.scroller = new FScrollPane(false){

            @Override
            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    ItemView.this.onMouseWheelZoom(e);
                    return;
                }
                super.processMouseWheelEvent(e);
            }
        };
        this.pnlOptions.setOpaque(false);
        this.pnlOptions.setBorder(new FSkin.MatteSkinBorder(1, 0, 0, 0, BORDER_COLOR));
        this.scroller.setBorder(new FSkin.LineSkinBorder(BORDER_COLOR));
        this.button = new FLabel.Builder().hoverable().selectable(true).icon(this.getIcon()).iconScaleAuto(false).tooltip(this.getCaption()).build();
        this.uniqueCardsOnlyChkBox = new FCheckBox(this.localizer.getMessage("lblUniqueCardsOnly", new Object[0]), this.itemManager.getWantUnique());
    }

    public void initialize(int index) {
        JComponent comp = this.getComponent();
        final IncrementalSearch incrementalSearch = new IncrementalSearch();
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                incrementalSearch.cancel();
            }
        });
        comp.addKeyListener(incrementalSearch);
        this.button.setCommand(() -> {
            if (this.button.isSelected()) {
                this.itemManager.setViewIndex(index);
            } else {
                this.button.setSelected(true);
            }
        });
        this.scroller.setViewportView(comp);
        this.scroller.getVerticalScrollBar().addAdjustmentListener(new ToolTipListener());
        this.scroller.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ItemView.this.onResize();
                int height = e.getComponent().getHeight();
                if (height != ItemView.this.heightBackup) {
                    ItemView.this.heightBackup = height;
                    ItemView.this.scrollSelectionIntoView();
                }
            }
        });
    }

    public FLabel getButton() {
        return this.button;
    }

    public FScrollPane getScroller() {
        return this.scroller;
    }

    public FScrollPanel getPnlOptions() {
        return this.pnlOptions;
    }

    public int getScrollValue() {
        return this.scroller.getVerticalScrollBar().getValue();
    }

    public void setScrollValue(int value) {
        this.scroller.getVerticalScrollBar().setValue(value);
    }

    protected void onMouseWheelZoom(MouseWheelEvent e) {
    }

    public boolean isIncrementalSearchActive() {
        return this.isIncrementalSearchActive;
    }

    public void refresh(Iterable<T> itemsToSelect, int backupIndexToSelect, int scrollValueToRestore) {
        this.model.refreshSort();
        this.onRefresh();
        this.fixSelection(itemsToSelect, backupIndexToSelect, scrollValueToRestore);
        this.uniqueCardsOnlyChkBox.setSelected(this.itemManager.getWantUnique());
    }

    protected abstract void onResize();

    protected abstract void onRefresh();

    protected void setUniqueCardsOnlyFilter() {
        this.uniqueCardsOnlyChkBox.setFont(ROW_FONT);
        this.uniqueCardsOnlyChkBox.setToolTipText(this.localizer.getMessage("ttUniqueCardsOnly", new Object[0]));
        this.uniqueCardsOnlyChkBox.addChangeListener(arg0 -> {
            boolean wantUnique = this.uniqueCardsOnlyChkBox.isSelected();
            if (this.itemManager.getWantUnique() == wantUnique) {
                return;
            }
            this.itemManager.setWantUnique(wantUnique);
            this.itemManager.refresh();
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setUniqueCardsOnly(wantUnique);
            }
        });
        this.getPnlOptions().add(this.uniqueCardsOnlyChkBox);
    }

    protected void fixSelection(Iterable<T> itemsToSelect, int backupIndexToSelect, int scrollValueToRestore) {
        if (itemsToSelect == null) {
            this.setSelectedIndex(0, false);
            this.setScrollValue(0);
        } else if (!this.setSelectedItems(itemsToSelect)) {
            this.setSelectedIndex(backupIndexToSelect);
        }
    }

    public final T getSelectedItem() {
        return this.getItemAtIndex(this.getSelectedIndex());
    }

    public final Collection<T> getSelectedItems() {
        ArrayList<T> items = new ArrayList<T>();
        for (Integer i : this.getSelectedIndices()) {
            T item = this.getItemAtIndex(i);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public final boolean setSelectedItem(T item) {
        return this.setSelectedItem(item, true);
    }

    public final boolean setSelectedItem(T item, boolean scrollIntoView) {
        int index = this.getIndexOfItem(item);
        if (index != -1) {
            this.setSelectedIndex(index, scrollIntoView);
            return true;
        }
        return false;
    }

    public final boolean setSelectedItems(Iterable<T> items) {
        return this.setSelectedItems(items, true);
    }

    public final boolean setSelectedItems(Iterable<T> items, boolean scrollIntoView) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (InventoryItem item : items) {
            int index = this.getIndexOfItem(item);
            if (index == -1) continue;
            indices.add(index);
        }
        if (indices.size() > 0) {
            this.onSetSelectedIndices(indices);
            if (scrollIntoView) {
                this.scrollSelectionIntoView();
            }
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean scrollIntoView) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= count) {
            index = count - 1;
        }
        this.onSetSelectedIndex(index);
        if (scrollIntoView) {
            this.scrollSelectionIntoView();
        }
    }

    public void setSelectedIndices(Iterable<Integer> indices) {
        this.setSelectedIndices(indices, true);
    }

    public void setSelectedIndices(Iterable<Integer> indices, boolean scrollIntoView) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (Integer index : indices) {
            if (index < 0 || index >= count) continue;
            indexList.add(index);
        }
        if (indexList.isEmpty()) {
            Iterator<Integer> iterator = indices.iterator();
            if (iterator.hasNext()) {
                Integer index;
                index = iterator.next();
                this.setSelectedIndex(index);
                return;
            }
            return;
        }
        this.onSetSelectedIndices(indexList);
        if (scrollIntoView) {
            this.scrollSelectionIntoView();
        }
    }

    protected void onSelectionChange() {
        int index = this.getSelectedIndex();
        if (index != -1) {
            ListSelectionEvent event = new ListSelectionEvent(this.itemManager, index, index, false);
            for (ListSelectionListener listener : this.itemManager.getSelectionListeners()) {
                listener.valueChanged(event);
            }
        }
    }

    public void scrollSelectionIntoView() {
        Container parent = this.getComponent().getParent();
        if (parent instanceof JViewport) {
            this.onScrollSelectionIntoView((JViewport)parent);
        }
    }

    public void focus() {
        this.getComponent().requestFocusInWindow();
    }

    public boolean hasFocus() {
        return this.getComponent().hasFocus();
    }

    public Point getLocationOnScreen() {
        return this.getComponent().getParent().getLocationOnScreen();
    }

    public String toString() {
        return this.getCaption();
    }

    public abstract JComponent getComponent();

    public abstract void setup(ItemManagerConfig var1, Map<ColumnDef, ItemTableColumn> var2);

    public abstract void setAllowMultipleSelections(boolean var1);

    public abstract T getItemAtIndex(int var1);

    public abstract int getIndexOfItem(T var1);

    public abstract int getSelectedIndex();

    public abstract Iterable<Integer> getSelectedIndices();

    public abstract void selectAll();

    public abstract int getCount();

    public abstract int getSelectionCount();

    public abstract int getIndexAtPoint(Point var1);

    protected abstract FSkin.SkinImage getIcon();

    protected abstract String getCaption();

    protected abstract void onSetSelectedIndex(int var1);

    protected abstract void onSetSelectedIndices(Iterable<Integer> var1);

    protected abstract void onScrollSelectionIntoView(JViewport var1);

    private class IncrementalSearch
    extends KeyAdapter {
        private StringBuilder str = new StringBuilder();
        private final FLabel popupLabel = new FLabel.Builder().fontAlign(2).opaque().build();
        private boolean popupShowing = false;
        private Popup popup;
        private Timer popupTimer;
        private static final int okModifiers = 8256;

        private void setPopupSize() {
            Dimension labelDimension = this.popupLabel.getPreferredSize();
            Dimension popupDimension = new Dimension(labelDimension.width + 12, labelDimension.height + 4);
            SwingUtilities.getRoot(this.popupLabel).setSize(popupDimension);
        }

        private void findNextMatch(int startIdx, boolean reverse) {
            Object item;
            int numItems = ItemView.this.itemManager.getItemCount();
            if (0 == numItems) {
                this.cancel();
                return;
            }
            int increment = reverse ? numItems - 1 : 1;
            int stopIdx = ((startIdx %= numItems) + numItems - increment) % numItems;
            String searchStr = this.str.toString();
            boolean found = false;
            int idx = startIdx;
            while ((item = ItemView.this.getItemAtIndex(idx)) != null) {
                if (StringUtils.containsIgnoreCase(item.getName(), searchStr)) {
                    ItemView.this.setSelectedIndex(idx);
                    found = true;
                    break;
                }
                if (idx == stopIdx) break;
                idx = (idx + increment) % numItems;
            }
            if (searchStr.isEmpty()) {
                this.cancel();
                return;
            }
            this.popupLabel.setText(searchStr + " (hit Enter for next match, Esc to cancel)");
            if (found) {
                this.popupLabel.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
            } else {
                this.popupLabel.setForeground(new Color(255, 0, 0));
            }
            if (this.popupShowing) {
                this.setPopupSize();
                this.popupTimer.restart();
            } else {
                PopupFactory factory = PopupFactory.getSharedInstance();
                Point tableLoc = ItemView.this.getLocationOnScreen();
                this.popup = factory.getPopup(null, this.popupLabel, tableLoc.x + 10, tableLoc.y + 10);
                FSkin.setTempBackground(SwingUtilities.getRoot(this.popupLabel), FSkin.getColor(FSkin.Colors.CLR_INACTIVE));
                this.popupTimer = new Timer(5000, e -> this.cancel());
                this.popupTimer.setRepeats(false);
                this.popup.show();
                this.setPopupSize();
                this.popupTimer.start();
                ItemView.this.isIncrementalSearchActive = true;
                this.popupShowing = true;
            }
        }

        public void cancel() {
            this.str = new StringBuilder();
            this.popupShowing = false;
            if (null != this.popup) {
                this.popup.hide();
                this.popup = null;
            }
            if (null != this.popupTimer) {
                this.popupTimer.stop();
                this.popupTimer = null;
            }
            ItemView.this.isIncrementalSearchActive = false;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.popupShowing) {
                if (27 == e.getKeyCode()) {
                    this.cancel();
                }
            } else {
                for (KeyListener keyListener : ItemView.this.itemManager.getKeyListeners()) {
                    keyListener.keyPressed(e);
                    if (!e.isConsumed()) continue;
                    return;
                }
                if (70 == e.getKeyCode() && (e.isControlDown() || e.isMetaDown())) {
                    ItemView.this.itemManager.focusSearch();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (!this.popupShowing) {
                for (KeyListener keyListener : ItemView.this.itemManager.getKeyListeners()) {
                    keyListener.keyTyped(e);
                    if (!e.isConsumed()) continue;
                    return;
                }
            }
            switch (e.getKeyChar()) {
                case '\uffff': {
                    return;
                }
                case '\n': 
                case '\r': {
                    if (!this.str.toString().isEmpty()) {
                        this.findNextMatch(ItemView.this.getSelectedIndex(), e.isShiftDown());
                    }
                    return;
                }
                case '\b': {
                    if (this.str.toString().isEmpty()) break;
                    this.str.deleteCharAt(this.str.toString().length() - 1);
                    break;
                }
                case ' ': {
                    if (this.str.toString().isEmpty()) {
                        return;
                    }
                }
                default: {
                    if (8256 != (e.getModifiersEx() | 0x2040) || !CharUtils.isAsciiPrintable(e.getKeyChar())) {
                        return;
                    }
                    this.str.append(e.getKeyChar());
                }
            }
            this.findNextMatch(Math.max(0, ItemView.this.getSelectedIndex()), false);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!this.popupShowing) {
                for (KeyListener keyListener : ItemView.this.itemManager.getKeyListeners()) {
                    keyListener.keyReleased(e);
                    if (!e.isConsumed()) continue;
                    return;
                }
            }
        }
    }
}

